# 通知設計書 14-unknownDep

## 概要

本ドキュメントは、拡張機能のアクティベーション時に依存する拡張機能が不明な場合に表示される `unknownDep` 通知の設計仕様を記述する。

### 本通知の処理概要

この通知は、拡張機能が依存として指定している他の拡張機能が、ローカルにもインストールされておらず、マーケットプレイスでも見つからない場合にエラーとして表示される。

**業務上の目的・背景**：VS Code の拡張機能は、他の拡張機能への依存関係を宣言できる。拡張機能がアクティベートされる際に、その依存関係が解決できない場合、ユーザーに問題を通知する必要がある。依存拡張機能が見つからない原因としては、拡張機能の廃止、マーケットプレイスからの削除、または拡張機能マニフェストの誤った依存関係指定などが考えられる。

**通知の送信タイミング**：拡張機能のアクティベーション失敗時、依存拡張機能が見つからない場合に通知が表示される。具体的には、ローカルにインストールされておらず、マーケットプレイス検索でも見つからなかった場合。

**通知の受信者**：対象の拡張機能を使用しようとした VS Code ユーザー本人。

**通知内容の概要**：「Cannot activate the '{拡張機能名}' extension because it depends on an unknown '{依存拡張機能ID}' extension.」というエラーメッセージが表示される。

**期待されるアクション**：ユーザーは以下のいずれかの対処を行う。(1) 依存拡張機能を手動で検索・インストールする、(2) 対象拡張機能をアンインストールまたは無効化する、(3) 拡張機能の作者に依存関係の問題を報告する。

## 通知種別

アプリ内通知（Error レベル）

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 同期 |
| 優先度 | 中 |
| リトライ | 無し |

### 送信先決定ロジック

拡張機能のアクティベーションに失敗したユーザーに対してのみ通知が表示される。

## 通知テンプレート

### アプリ内通知

| 項目 | 内容 |
|-----|------|
| 深刻度 | Error |
| スティッキー | デフォルト（明示的な設定なし） |

### 本文テンプレート

```
Cannot activate the '{0}' extension because it depends on an unknown '{1}' extension.
```

## テンプレート変数

| 変数名 | 説明 | データ取得元 | 必須 |
|--------|------|-------------|-----|
| {0} | アクティベーションに失敗した拡張機能名 | `extension.displayName \|\| extension.name` | Yes |
| {1} | 見つからなかった依存拡張機能ID | `missingDependency` | Yes |

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| システムイベント | 拡張機能アクティベーション失敗 | 依存拡張機能がローカルにもマーケットプレイスにもない | `_handleMissingNotInstalledDependency` で検出 |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| 依存拡張機能がマーケットプレイスで見つかった場合 | 別の通知（uninstalledDep）が表示される |
| 依存拡張機能がローカルにインストール済みの場合 | 別の通知（disabledDep等）が表示される |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A[拡張機能アクティベーション] --> B{エラー発生?}
    B -->|No| C[正常アクティベート]
    B -->|Yes| D{MissingExtensionDependency?}
    D -->|No| E[その他のエラー処理]
    D -->|Yes| F{依存拡張機能ローカルにあり?}
    F -->|Yes| G[_handleMissingInstalledDependency]
    F -->|No| H[_handleMissingNotInstalledDependency]
    H --> I{マーケットプレイスで発見?}
    I -->|Yes| J[uninstalledDep 通知]
    I -->|No| K[unknownDep 通知]
```

## データベース参照・更新仕様

### 参照テーブル一覧

| テーブル名 | 用途 | 備考 |
|-----------|------|------|
| なし | 本通知ではデータベースは使用しない | - |

### 外部サービス参照

| サービス | 用途 | 備考 |
|---------|------|------|
| Extensions Workbench Service | マーケットプレイスでの拡張機能検索 | `_extensionsWorkbenchService.getExtensions()` |

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| 依存拡張機能未発見 | マーケットプレイス検索結果が null | unknownDep エラー通知を表示 |

## 配信設定

### レート制限

| 項目 | 内容 |
|-----|------|
| 制限なし | 拡張機能アクティベーション時に表示 |

### 配信時間帯

制限なし

## セキュリティ考慮事項

- 拡張機能名と依存拡張機能IDのみが通知に含まれ、個人情報は含まれない

## 備考

- この通知は、依存拡張機能が完全に見つからない場合の最終手段として表示される
- 関連する通知として以下がある：
  - `uninstalledDep`: 依存拡張機能がマーケットプレイスで見つかった場合
  - `disabledDep`: 依存拡張機能が無効化されている場合
  - `reload window`: 依存拡張機能がインストール済みだが読み込まれていない場合

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

拡張機能の依存関係エラーの構造を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | mainThreadExtensionService.ts | `src/vs/workbench/api/browser/mainThreadExtensionService.ts` | `MissingExtensionDependency` エラー型 |
| 1-2 | extensionHostProtocol.ts | `src/vs/workbench/services/extensions/common/extensionHostProtocol.ts` | 拡張機能ホストとのプロトコル定義 |

**読解のコツ**: `MissingExtensionDependency` エラーは `dependency` プロパティを持ち、見つからなかった依存拡張機能IDを含む。

#### Step 2: エントリーポイントを理解する

エラー処理の起点を特定する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | mainThreadExtensionService.ts | `src/vs/workbench/api/browser/mainThreadExtensionService.ts` | `$onExtensionActivationError` メソッド |

**主要処理フロー**:
1. **行85-100**: `MissingExtensionDependency` エラーの判定
2. **行90-94**: ローカルにインストール済みか確認
3. **行96**: 未インストールの場合 `_handleMissingNotInstalledDependency` 呼び出し

#### Step 3: 未インストール依存の処理を理解する

マーケットプレイス検索と通知発行の処理を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | mainThreadExtensionService.ts | `src/vs/workbench/api/browser/mainThreadExtensionService.ts` | `_handleMissingNotInstalledDependency` メソッド |

**主要処理フロー**:
- **行157-163**: マーケットプレイスで依存拡張機能を検索
- **行164-176**: 見つかった場合は `uninstalledDep` 通知
- **行177-179**: 見つからなかった場合は `unknownDep` 通知

### プログラム呼び出し階層図

```
拡張機能アクティベーションエラー
    │
    ├─ MainThreadExtensionService.$onExtensionActivationError()
    │      │
    │      ├─ MissingExtensionDependency エラー判定
    │      │
    │      ├─ extensionsWorkbenchService.queryLocal()
    │      │      └─ ローカル拡張機能検索
    │      │
    │      └─ _handleMissingNotInstalledDependency()
    │             │
    │             ├─ extensionsWorkbenchService.getExtensions()
    │             │      └─ マーケットプレイス検索
    │             │
    │             └─ dependencyExtension が null の場合
    │                    │
    │                    └─ notificationService.error()
    │                           │
    │                           └─ "unknownDep"
```

### データフロー図

```
[入力]                    [処理]                         [出力]

extension            ───▶ $onExtensionActivationError ───▶ エラー分類
  │                                │
  ├─ displayName                   │
  └─ name                          │
                                   │
missingDependency    ───▶ extensionsWorkbenchService  ───▶ dependencyExtension
  │                       .getExtensions([{id}])            │
  └─ dependency ID                                          └─ null (見つからず)
                                   │
                                   ↓
[通知]

notificationService  ───▶ error()                     ───▶ Notification
                           localize('unknownDep',          (Error レベル)
                           extName, missingDependency)
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| mainThreadExtensionService.ts | `src/vs/workbench/api/browser/mainThreadExtensionService.ts` | ソース | 通知発行元、エラー処理 |
| extensionsWorkbenchService.ts | `src/vs/workbench/contrib/extensions/browser/extensionsWorkbenchService.ts` | ソース | 拡張機能検索サービス |
| notification.ts | `src/vs/platform/notification/common/notification.ts` | ソース | 通知サービスインターフェース |
| extensionHostProtocol.ts | `src/vs/workbench/services/extensions/common/extensionHostProtocol.ts` | ソース | エラー型定義 |
