# 通知設計書 15-getEnvironmentFailure

## 概要

本ドキュメントは、リモート環境の取得に失敗した場合に表示される `getEnvironmentFailure` 通知の設計仕様を記述する。

### 本通知の処理概要

この通知は、VS Code がリモート環境（SSH、コンテナ、WSL など）に接続した後、リモートエージェントから環境情報を取得しようとしたが失敗した場合にエラーとして表示される。

**業務上の目的・背景**：VS Code のリモート開発機能では、リモートエージェントから環境情報（OS情報、ファイルシステム情報など）を取得する必要がある。この情報取得に失敗すると、リモート拡張機能の正常な動作が保証されない。ユーザーにエラーを通知し、問題を認識させることが重要である。

**通知の送信タイミング**：リモート接続後、`remoteAgentService.getEnvironment()` が `null` を返した場合に通知が表示される。

**通知の受信者**：リモート環境に接続しようとした VS Code ユーザー本人。

**通知内容の概要**：「Could not fetch remote environment」というエラーメッセージが表示される。

**期待されるアクション**：ユーザーは以下のいずれかの対処を行う。(1) リモート接続を再試行する、(2) リモートサーバーの状態を確認する、(3) ネットワーク接続を確認する、(4) ローカル拡張機能ホストで作業を続行する。

## 通知種別

アプリ内通知（Error レベル）

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 同期 |
| 優先度 | 中 |
| リトライ | 無し |

### 送信先決定ロジック

リモート環境の取得に失敗したユーザーに対してのみ通知が表示される。

## 通知テンプレート

### アプリ内通知

| 項目 | 内容 |
|-----|------|
| 深刻度 | Error |
| スティッキー | デフォルト（明示的な設定なし） |

### 本文テンプレート

```
Could not fetch remote environment
```

## テンプレート変数

| 変数名 | 説明 | データ取得元 | 必須 |
|--------|------|-------------|-----|
| なし | 本通知には動的変数は含まれない | - | - |

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| システムイベント | リモート環境情報取得 | `remoteAgentService.getEnvironment()` が `null` を返す | リモートエージェントとの通信失敗 |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| リモート接続が成功した場合 | 環境情報が正常に取得できた場合は通知しない |
| リモート権限がない場合 | そもそもリモート接続を試みない |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A[リモート拡張機能ホスト起動] --> B[権限解決]
    B --> C{解決成功?}
    C -->|No| D[エラー処理]
    C -->|Yes| E[リモート環境取得]
    E --> F{remoteEnv 取得成功?}
    F -->|Yes| G[リモート拡張機能スキャン]
    F -->|No| H[getEnvironmentFailure 通知]
    H --> I[ローカル拡張機能ホスト起動]
    G --> I
```

## データベース参照・更新仕様

### 参照テーブル一覧

| テーブル名 | 用途 | 備考 |
|-----------|------|------|
| なし | 本通知ではデータベースは使用しない | - |

### 外部サービス参照

| サービス | 用途 | 備考 |
|---------|------|------|
| Remote Agent Service | リモート環境情報の取得 | `_remoteAgentService.getEnvironment()` |

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| 環境取得失敗 | getEnvironment() が null | エラー通知を表示し、ローカルで続行 |

## 配信設定

### レート制限

| 項目 | 内容 |
|-----|------|
| 制限なし | リモート接続試行時に表示 |

### 配信時間帯

制限なし

## セキュリティ考慮事項

- 通知メッセージには個人情報やサーバー情報は含まれない

## 備考

- このエラーが発生しても、VS Code はローカル拡張機能ホストを起動して作業を続行する
- リモートエージェントとの接続は確立されているが、環境情報の取得に失敗した状態
- ターミナルなど他のリモート機能でも同様のエラーが発生する可能性がある

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

リモート環境情報の構造を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | remoteAgentService.ts | `src/vs/workbench/services/remote/common/remoteAgentService.ts` | `IRemoteAgentEnvironment` インターフェース |

**読解のコツ**: `IRemoteAgentEnvironment` には OS、プロセスID、環境変数などの情報が含まれる。

#### Step 2: エントリーポイントを理解する

リモート環境取得処理の起点を特定する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | nativeExtensionService.ts | `src/vs/workbench/services/extensions/electron-browser/nativeExtensionService.ts` | 拡張機能ホスト起動処理 |

**主要処理フロー**:
1. **行390-391**: リモート権限解決の結果設定
2. **行405-408**: `Promise.all()` でリモート環境とリモート拡張機能を並行取得
3. **行410-414**: `remoteEnv` が `null` の場合の処理
4. **行411**: `notificationService.notify()` でエラー通知発行
5. **行413**: ローカル拡張機能ホストで続行

#### Step 3: リモートエージェントサービスを理解する

リモートエージェントの仕組みを理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | remoteAgentService.ts | `src/vs/workbench/services/remote/common/remoteAgentService.ts` | `getEnvironment()` メソッド |

**主要処理フロー**:
- リモートエージェントへのRPC呼び出しで環境情報を取得
- 通信失敗やタイムアウトの場合は `null` を返す

### プログラム呼び出し階層図

```
NativeExtensionService 起動
    │
    ├─ リモート権限解決
    │      └─ _remoteAuthorityResolverService._setResolvedAuthority()
    │
    ├─ Promise.all()
    │      │
    │      ├─ _remoteAgentService.getEnvironment()
    │      │      └─ リモート環境情報取得
    │      │
    │      └─ _remoteExtensionsScannerService.scanExtensions()
    │             └─ リモート拡張機能スキャン
    │
    └─ remoteEnv === null の場合
           │
           ├─ notificationService.notify()
           │      │
           │      └─ "getEnvironmentFailure"
           │             (Severity.Error)
           │
           └─ _startLocalExtensionHost()
                  └─ ローカルで続行
```

### データフロー図

```
[入力]                    [処理]                         [出力]

remoteAuthority      ───▶ 権限解決                  ───▶ resolverResult
                                │
                                ↓
                          remoteAgentService
                          .getEnvironment()
                                │
                                ↓
                          [結果判定]
                                │
                    ┌───────────┴───────────┐
                    │                       │
              remoteEnv !== null      remoteEnv === null
                    │                       │
                    ↓                       ↓
              正常処理続行            notificationService
                                     .notify()
                                           │
                                           ↓
                                     Notification
                                     (Error レベル)
                                           │
                                           ↓
                                     ローカルで続行
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| nativeExtensionService.ts | `src/vs/workbench/services/extensions/electron-browser/nativeExtensionService.ts` | ソース | 通知発行元 |
| remoteAgentService.ts | `src/vs/workbench/services/remote/common/remoteAgentService.ts` | ソース | リモートエージェントサービス |
| notification.ts | `src/vs/platform/notification/common/notification.ts` | ソース | 通知サービスインターフェース |
| remoteTerminalBackend.ts | `src/vs/workbench/contrib/terminal/browser/remoteTerminalBackend.ts` | ソース | 同様のエラーを発生させる箇所 |
