# 通知設計書 16-remoteFileDialog.notConnectedToRemote

## 概要

本ドキュメントは、リモートファイルシステムプロバイダーが利用できない場合に表示される `remoteFileDialog.notConnectedToRemote` 通知の設計仕様を記述する。

### 本通知の処理概要

この通知は、ファイル選択ダイアログ（開く/保存）を表示しようとした際に、対象のファイルシステムプロバイダーが利用できない場合に情報として表示される。

**業務上の目的・背景**：VS Code のファイルダイアログは、ローカルファイルシステムだけでなく、リモートファイルシステム（SSH、コンテナ、WSLなど）にもアクセスできる。しかし、リモート接続が確立されていない場合や、ファイルシステムプロバイダーが未登録の場合、ダイアログを表示することができない。ユーザーにこの状況を通知し、適切な対処（リモート接続の確立など）を促す必要がある。

**通知の送信タイミング**：ファイルダイアログ（開く/保存）を表示しようとした際に、`fileService.hasProvider(defaultUri)` が `false` を返した場合に通知が表示される。

**通知の受信者**：ファイルダイアログを開こうとした VS Code ユーザー本人。

**通知内容の概要**：「File system provider for {URI} is not available.」という情報メッセージが表示される。

**期待されるアクション**：ユーザーは以下のいずれかの対処を行う。(1) リモート接続を確立する、(2) 別のファイルシステムを選択する、(3) ローカルファイルシステムを使用する。

## 通知種別

アプリ内通知（Info レベル）

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 同期 |
| 優先度 | 低 |
| リトライ | 無し |

### 送信先決定ロジック

ファイルダイアログを開こうとしたユーザーに対してのみ通知が表示される。

## 通知テンプレート

### アプリ内通知

| 項目 | 内容 |
|-----|------|
| 深刻度 | Info |
| スティッキー | デフォルト（明示的な設定なし） |

### 本文テンプレート

```
File system provider for {0} is not available.
```

## テンプレート変数

| 変数名 | 説明 | データ取得元 | 必須 |
|--------|------|-------------|-----|
| {0} | ファイルシステムのURI | `defaultUri.toString()` | Yes |

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| ユーザー操作 | ファイルダイアログを開く | `fileService.hasProvider(defaultUri) === false` かつ `scheme !== Schemas.file` | リモートプロバイダーが未登録 |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| ローカルファイルシステムの場合 | `scheme === Schemas.file` の場合は常に利用可能 |
| プロバイダーが登録済みの場合 | `hasProvider()` が `true` を返す場合 |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A[ファイルダイアログを開く] --> B[getOptions 呼び出し]
    B --> C{scheme === file?}
    C -->|Yes| D[通常処理続行]
    C -->|No| E{hasProvider(defaultUri)?}
    E -->|Yes| D
    E -->|No| F[notConnectedToRemote 通知]
    F --> G[undefined を返す]
    G --> H[ダイアログ表示キャンセル]
```

## データベース参照・更新仕様

### 参照テーブル一覧

| テーブル名 | 用途 | 備考 |
|-----------|------|------|
| なし | 本通知ではデータベースは使用しない | - |

### 外部サービス参照

| サービス | 用途 | 備考 |
|---------|------|------|
| File Service | ファイルシステムプロバイダーの確認 | `fileService.hasProvider()` |

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| プロバイダー未登録 | hasProvider() が false | Info 通知を表示し、ダイアログをキャンセル |

## 配信設定

### レート制限

| 項目 | 内容 |
|-----|------|
| 制限なし | ユーザー操作に応じて表示 |

### 配信時間帯

制限なし

## セキュリティ考慮事項

- URI がメッセージに含まれるが、通常は機密情報ではない
- リモートサーバーの接続情報が一部露出する可能性があるが、ユーザー自身に対してのみ表示される

## 備考

- この通知は Error ではなく Info レベルで表示される
- ダイアログ自体は表示されず、`undefined` が返される
- ユーザーは手動でリモート接続を確立してから再度操作する必要がある

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

ファイルダイアログのオプション構造を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | dialogs.ts | `src/vs/platform/dialogs/common/dialogs.ts` | `IOpenDialogOptions`、`ISaveDialogOptions` インターフェース |

**読解のコツ**: `availableFileSystems` プロパティで利用可能なファイルシステムスキームが指定される。

#### Step 2: エントリーポイントを理解する

ファイルダイアログの表示処理を特定する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | simpleFileDialog.ts | `src/vs/workbench/services/dialogs/browser/simpleFileDialog.ts` | `showOpenDialog`、`showSaveDialog` メソッド |

**主要処理フロー**:
1. **行180-202**: `showOpenDialog` - 開くダイアログの表示
2. **行204-222**: `showSaveDialog` - 保存ダイアログの表示
3. **行224-244**: `getOptions` - オプション生成とプロバイダーチェック

#### Step 3: プロバイダーチェックを理解する

ファイルシステムプロバイダーの確認処理を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | simpleFileDialog.ts | `src/vs/workbench/services/dialogs/browser/simpleFileDialog.ts` | `getOptions` メソッド内の条件分岐 |

**主要処理フロー**:
- **行237-240**: プロバイダーチェックと通知発行
  - `scheme !== Schemas.file` - ローカルファイル以外
  - `!fileService.hasProvider(defaultUri)` - プロバイダー未登録
  - 両条件を満たす場合に通知を発行

### プログラム呼び出し階層図

```
ユーザー操作（ファイルを開く/保存）
    │
    ├─ SimpleFileDialog.showOpenDialog()
    │      │
    │      └─ getOptions()
    │             │
    │             ├─ scheme !== Schemas.file
    │             │
    │             └─ fileService.hasProvider(defaultUri)
    │                    │
    │                    ├─ true → 正常処理続行
    │                    │
    │                    └─ false → notificationService.info()
    │                                      │
    │                                      └─ "notConnectedToRemote"
    │                                             │
    │                                             └─ return undefined
    │
    └─ SimpleFileDialog.showSaveDialog()
           │
           └─ 同様の処理フロー
```

### データフロー図

```
[入力]                    [処理]                         [出力]

options              ───▶ getScheme()               ───▶ scheme
  │                                │
  ├─ availableFileSystems          │
  └─ defaultUri                    ↓
                            scheme !== Schemas.file?
                                   │
                    ┌──────────────┴──────────────┐
                    │                             │
                  No (file)                  Yes (remote)
                    │                             │
                    ↓                             ↓
              正常処理続行              fileService.hasProvider()
                                              │
                               ┌──────────────┴──────────────┐
                               │                             │
                             true                          false
                               │                             │
                               ↓                             ↓
                         正常処理続行              notificationService.info()
                                                         │
                                                         ↓
                                                   Notification
                                                   (Info レベル)
                                                         │
                                                         ↓
                                                   return undefined
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| simpleFileDialog.ts | `src/vs/workbench/services/dialogs/browser/simpleFileDialog.ts` | ソース | 通知発行元、ファイルダイアログ実装 |
| dialogs.ts | `src/vs/platform/dialogs/common/dialogs.ts` | ソース | ダイアログインターフェース定義 |
| fileService.ts | `src/vs/platform/files/common/fileService.ts` | ソース | ファイルサービス（hasProvider） |
| notification.ts | `src/vs/platform/notification/common/notification.ts` | ソース | 通知サービスインターフェース |
