# 通知設計書 17-debugAdapterCrash

## 概要

本ドキュメントは、デバッグアダプタープロセスが予期せず終了した場合に表示される `debugAdapterCrash` 通知の設計仕様を記述する。

### 本通知の処理概要

この通知は、デバッグセッション中にデバッグアダプター（Debug Adapter）プロセスが予期せず終了した場合にエラーとして表示される。

**業務上の目的・背景**：VS Code のデバッグ機能は、Debug Adapter Protocol (DAP) に準拠したデバッグアダプターを使用して各種言語・環境のデバッグを実現する。デバッグアダプターは独立したプロセスとして実行されるため、バグや例外、リソース不足などの理由で予期せず終了する可能性がある。この場合、ユーザーにデバッグセッションが中断された理由を通知し、問題を認識させることが重要である。

**通知の送信タイミング**：デバッグアダプターの終了イベント（`onDidEndAdapter`）が発生し、そのイベントにエラー情報が含まれている場合に通知が表示される。

**通知の受信者**：デバッグセッションを実行していた VS Code ユーザー本人。

**通知内容の概要**：「Debug adapter process has terminated unexpectedly ({エラーメッセージ})」というエラーメッセージが表示される。

**期待されるアクション**：ユーザーは以下のいずれかの対処を行う。(1) デバッグセッションを再開する、(2) デバッグアダプターの更新を確認する、(3) デバッグ対象のアプリケーションや設定を確認する、(4) エラーメッセージを元に問題を調査する。

## 通知種別

アプリ内通知（Error レベル）

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 同期 |
| 優先度 | 高 |
| リトライ | 無し |

### 送信先決定ロジック

デバッグセッションが中断されたユーザーに対してのみ通知が表示される。

## 通知テンプレート

### アプリ内通知

| 項目 | 内容 |
|-----|------|
| 深刻度 | Error |
| スティッキー | デフォルト（明示的な設定なし） |

### 本文テンプレート

```
Debug adapter process has terminated unexpectedly ({0})
```

## テンプレート変数

| 変数名 | 説明 | データ取得元 | 必須 |
|--------|------|-------------|-----|
| {0} | エラーメッセージ | `adapterExitEvent.error.message \|\| adapterExitEvent.error.toString()` | Yes |

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| システムイベント | session.onDidEndAdapter | `adapterExitEvent.error` が存在する | デバッグアダプターの異常終了 |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| エラーがない場合 | `adapterExitEvent.error` が null/undefined の場合は通知しない |
| 正常終了の場合 | デバッグセッションが正常に終了した場合 |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A[デバッグセッション実行中] --> B[onDidEndAdapter イベント発生]
    B --> C{adapterExitEvent 存在?}
    C -->|No| D[終了処理のみ]
    C -->|Yes| E{error 存在?}
    E -->|No| F[テレメトリ送信のみ]
    E -->|Yes| G[debugAdapterCrash 通知]
    G --> F
    F --> H[postDebugTask 実行]
    H --> I[セッション終了処理]
```

## データベース参照・更新仕様

### 参照テーブル一覧

| テーブル名 | 用途 | 備考 |
|-----------|------|------|
| なし | 本通知ではデータベースは使用しない | - |

### テレメトリ送信

| データ | 用途 | 備考 |
|--------|------|------|
| セッション情報 | デバッグ統計 | `telemetry.logDebugSessionStop()` |

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| アダプタークラッシュ | デバッグアダプターの予期せぬ終了 | エラー通知を表示 |
| postDebugTask エラー | 終了後タスクの実行失敗 | 別途エラー通知を表示 |

## 配信設定

### レート制限

| 項目 | 内容 |
|-----|------|
| 制限なし | デバッグアダプター終了時に表示 |

### 配信時間帯

制限なし

## セキュリティ考慮事項

- エラーメッセージにはデバッグアダプターからの情報が含まれる
- 一般的にパスや環境情報が含まれる可能性があるが、ユーザー自身に対してのみ表示される

## 備考

- デバッグアダプターは Debug Adapter Protocol (DAP) に準拠した独立プロセス
- 各言語のデバッグ拡張機能がそれぞれのデバッグアダプターを提供
- エラー後も postDebugTask は実行される

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

デバッグアダプター終了イベントの構造を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | debug.ts | `src/vs/workbench/contrib/debug/common/debug.ts` | `AdapterEndEvent` インターフェース |

**読解のコツ**: `AdapterEndEvent` には `error` プロパティがあり、異常終了時にエラー情報を含む。

#### Step 2: エントリーポイントを理解する

通知が発行される処理を特定する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | debugService.ts | `src/vs/workbench/contrib/debug/browser/debugService.ts` | `registerSessionListeners` メソッド |

**主要処理フロー**:
1. **行724-726**: セッションリスナーの登録開始
2. **行747**: `session.onDidEndAdapter` イベントのリスナー登録
3. **行749-754**: アダプター終了時の処理
4. **行750-752**: エラーがある場合に通知発行

#### Step 3: デバッグセッションを理解する

デバッグセッションの構造とアダプターとの関係を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | debugSession.ts | `src/vs/workbench/contrib/debug/browser/debugSession.ts` | `DebugSession` クラス |

**主要処理フロー**:
- デバッグアダプターとの通信管理
- `onDidEndAdapter` イベントの発火タイミング

### プログラム呼び出し階層図

```
デバッグセッション開始
    │
    ├─ DebugService.launchOrAttachToSession()
    │      │
    │      └─ registerSessionListeners()
    │             │
    │             └─ session.onDidEndAdapter リスナー登録
    │
    └─ デバッグアダプター実行中
           │
           └─ アダプターが予期せず終了
                  │
                  └─ onDidEndAdapter イベント発火
                         │
                         ├─ adapterExitEvent.error チェック
                         │      │
                         │      └─ error 存在する場合
                         │             │
                         │             └─ notificationService.error()
                         │                    │
                         │                    └─ "debugAdapterCrash"
                         │
                         ├─ telemetry.logDebugSessionStop()
                         │
                         └─ セッション終了処理
```

### データフロー図

```
[入力]                    [処理]                         [出力]

デバッグアダプター   ───▶ プロセス異常終了          ───▶ AdapterEndEvent
プロセス                                                    │
                                                            ├─ error
                                                            │    ├─ message
                                                            │    └─ stack
                                                            └─ sessionLengthInSeconds
                                   │
                                   ↓
                          onDidEndAdapter 発火
                                   │
                                   ↓
                          [エラーチェック]
                                   │
                    ┌──────────────┴──────────────┐
                    │                             │
              error なし                    error あり
                    │                             │
                    ↓                             ↓
              通知なし               notificationService.error()
                                              │
                                              ↓
                                        Notification
                                        (Error レベル)
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| debugService.ts | `src/vs/workbench/contrib/debug/browser/debugService.ts` | ソース | 通知発行元、デバッグサービス |
| debugSession.ts | `src/vs/workbench/contrib/debug/browser/debugSession.ts` | ソース | デバッグセッション管理 |
| debug.ts | `src/vs/workbench/contrib/debug/common/debug.ts` | ソース | デバッグ関連インターフェース |
| notification.ts | `src/vs/platform/notification/common/notification.ts` | ソース | 通知サービスインターフェース |
| rawDebugSession.ts | `src/vs/workbench/contrib/debug/browser/rawDebugSession.ts` | ソース | デバッグアダプターとの通信 |
