# 通知設計書 18-failedToLoadFrames

## 概要

本ドキュメントは、スタックフレームの読み込みに失敗した場合に表示される `failedToLoadFrames` 通知の設計仕様を記述する。

### 本通知の処理概要

この通知は、デバッグ中にコールスタックウィジェットで追加のスタックフレームを読み込もうとした際に失敗した場合にエラーとして表示される。

**業務上の目的・背景**：VS Code のデバッグ機能では、パフォーマンス最適化のためにスタックフレームを段階的に読み込む仕組みがある。「Load More Frames」などのボタンをクリックすると、追加のスタックフレームがデバッグアダプターからロードされる。この読み込みが失敗した場合、ユーザーに問題を通知し、デバッグ作業の継続を支援する必要がある。

**通知の送信タイミング**：コールスタックウィジェットで「Load More Frames」ボタンをクリックした際に、スタックフレームの読み込みが失敗した場合に通知が表示される。

**通知の受信者**：デバッグセッションを実行し、追加のスタックフレームを読み込もうとした VS Code ユーザー本人。

**通知内容の概要**：「Failed to load stack frames: {エラーメッセージ}」というエラーメッセージが表示される。

**期待されるアクション**：ユーザーは以下のいずれかの対処を行う。(1) 再度読み込みを試みる、(2) デバッグセッションを再起動する、(3) エラーメッセージを元に問題を調査する。

## 通知種別

アプリ内通知（Error レベル）

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 同期 |
| 優先度 | 中 |
| リトライ | 無し |

### 送信先決定ロジック

スタックフレームの読み込みを試みたユーザーに対してのみ通知が表示される。

## 通知テンプレート

### アプリ内通知

| 項目 | 内容 |
|-----|------|
| 深刻度 | Error |
| スティッキー | デフォルト（明示的な設定なし） |

### 本文テンプレート

```
Failed to load stack frames: {0}
```

## テンプレート変数

| 変数名 | 説明 | データ取得元 | 必須 |
|--------|------|-------------|-----|
| {0} | エラーメッセージ | `e.message` | Yes |

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| ユーザー操作 | Load More Frames ボタンクリック | `loadFrames()` が例外をスロー | スタックフレーム読み込み失敗 |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| 読み込み成功の場合 | Promise が正常に resolve した場合 |
| ボタンが無効化されている場合 | `button.enabled === false` の場合はそもそも処理されない |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A[デバッグセッション中] --> B[コールスタックウィジェット表示]
    B --> C[Load More Frames ボタン表示]
    C --> D{ボタンクリック}
    D --> E{button.enabled?}
    E -->|No| F[処理なし]
    E -->|Yes| G[button.enabled = false]
    G --> H[loadFrames 呼び出し]
    H --> I{成功?}
    I -->|Yes| J[スタックフレーム表示更新]
    I -->|No| K[failedToLoadFrames 通知]
```

## データベース参照・更新仕様

### 参照テーブル一覧

| テーブル名 | 用途 | 備考 |
|-----------|------|------|
| なし | 本通知ではデータベースは使用しない | - |

### 外部サービス参照

| サービス | 用途 | 備考 |
|---------|------|------|
| Debug Adapter | スタックフレームの取得 | DAP の `stackTrace` リクエスト |

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| 読み込み失敗 | loadFrames() が reject | エラー通知を表示 |

## 配信設定

### レート制限

| 項目 | 内容 |
|-----|------|
| 制限なし | ユーザー操作に応じて表示 |

### 配信時間帯

制限なし

## セキュリティ考慮事項

- エラーメッセージにはデバッグアダプターからの情報が含まれる
- 一般的にスタック情報やパスが含まれる可能性があるが、ユーザー自身に対してのみ表示される

## 備考

- ボタンクリック時に即座に `button.enabled = false` を設定することで、連打による重複リクエストを防止
- エラー発生後もボタンは無効状態のまま

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

スタックフレームとスキップされたフレームの構造を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | callStackWidget.ts | `src/vs/workbench/contrib/debug/browser/callStackWidget.ts` | `SkippedCallFrames` クラス |
| 1-2 | debugModel.ts | `src/vs/workbench/contrib/debug/common/debugModel.ts` | `StackFrame` インターフェース |

**読解のコツ**: `SkippedCallFrames` は「Load More Frames」ボタンの表現であり、クリックすると `loadFrames` が呼ばれる。

#### Step 2: エントリーポイントを理解する

通知が発行される処理を特定する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | callStackWidget.ts | `src/vs/workbench/contrib/debug/browser/callStackWidget.ts` | `SkippedRenderer` クラス |

**主要処理フロー**:
1. **行620-627**: `SkippedRenderer` クラスの定義
2. **行629-647**: `renderTemplate` メソッド - ボタンとイベントハンドラの設定
3. **行635-644**: ボタンクリック時の処理
4. **行641-643**: `loadFrames` の呼び出しとエラーハンドリング
5. **行642**: エラー時の通知発行

#### Step 3: loadFrames の処理を理解する

スタックフレーム読み込み処理の詳細を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | callStackWidget.ts | `src/vs/workbench/contrib/debug/browser/callStackWidget.ts` | `loadFrames` メソッドの実装 |

**主要処理フロー**:
- コンストラクタで渡された `loadFrames` 関数が呼び出される
- この関数はデバッグアダプターに追加のスタックフレームをリクエストする
- 失敗した場合は Promise が reject され、catch ブロックで通知が発行される

### プログラム呼び出し階層図

```
コールスタックウィジェット
    │
    ├─ SkippedRenderer.renderTemplate()
    │      │
    │      └─ Button 作成
    │             │
    │             └─ onDidClick イベントハンドラ登録
    │
    └─ ユーザーがボタンをクリック
           │
           ├─ button.enabled チェック
           │
           ├─ button.enabled = false
           │
           └─ loadFrames(data.current)
                  │
                  ├─ Promise.resolve → スタックフレーム表示更新
                  │
                  └─ Promise.reject → catch
                                        │
                                        └─ notificationService.error()
                                               │
                                               └─ "failedToLoadFrames"
```

### データフロー図

```
[入力]                    [処理]                         [出力]

SkippedCallFrames    ───▶ Button.onDidClick         ───▶ loadFrames 呼び出し
  │                                                         │
  ├─ label                                                  │
  └─ totalFrameCount                                        ↓
                                                    [デバッグアダプター]
                                                           │
                                                           ↓
                                                    stackTrace リクエスト
                                                           │
                                            ┌──────────────┴──────────────┐
                                            │                             │
                                        成功                          失敗
                                            │                             │
                                            ↓                             ↓
                                      フレーム表示更新        notificationService.error()
                                                                      │
                                                                      ↓
                                                                Notification
                                                                (Error レベル)
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| callStackWidget.ts | `src/vs/workbench/contrib/debug/browser/callStackWidget.ts` | ソース | 通知発行元、コールスタックウィジェット |
| debugModel.ts | `src/vs/workbench/contrib/debug/common/debugModel.ts` | ソース | スタックフレームモデル |
| debugSession.ts | `src/vs/workbench/contrib/debug/browser/debugSession.ts` | ソース | デバッグセッション管理 |
| notification.ts | `src/vs/platform/notification/common/notification.ts` | ソース | 通知サービスインターフェース |
