# 通知設計書 19-sync turned on

## 概要

本ドキュメントは、設定同期（Settings Sync）がオンになった場合に表示される `sync turned on` 通知の設計仕様を記述する。

### 本通知の処理概要

この通知は、ユーザーが Settings Sync を有効化した際に、同期が正常に開始されたことを確認する情報通知として表示される。

**業務上の目的・背景**：VS Code の Settings Sync 機能は、設定、キーバインド、拡張機能などをクラウド経由で複数のデバイス間で同期する機能である。ユーザーが同期を有効化した際に、その操作が成功したことを明確に通知することで、ユーザーの安心感を高め、機能が正常に動作していることを確認できる。

**通知の送信タイミング**：`turnOn()` メソッドの処理が完了し、同期が正常に開始された直後に通知が表示される。具体的には、認証、初期同期、自動同期サービスの有効化がすべて完了した後。

**通知の受信者**：Settings Sync を有効化した VS Code ユーザー本人。

**通知内容の概要**：「Settings Sync is turned on」という情報メッセージが表示される。

**期待されるアクション**：通知を確認し、必要に応じて Settings Sync の設定画面で同期対象を確認する。特別なアクションは必要なく、確認のための通知である。

## 通知種別

アプリ内通知（Info レベル）

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 同期 |
| 優先度 | 低 |
| リトライ | 無し |

### 送信先決定ロジック

Settings Sync を有効化したユーザーに対してのみ通知が表示される。

## 通知テンプレート

### アプリ内通知

| 項目 | 内容 |
|-----|------|
| 深刻度 | Info |
| スティッキー | デフォルト（明示的な設定なし） |

### 本文テンプレート

```
{0} is turned on
```

実際の表示例：
```
Settings Sync is turned on
```

## テンプレート変数

| 変数名 | 説明 | データ取得元 | 必須 |
|--------|------|-------------|-----|
| {0} | 同期機能のタイトル | `SYNC_TITLE.value`（"Settings Sync"） | Yes |

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| ユーザー操作 | Settings Sync を有効化 | `turnOn()` が正常に完了 | 認証と初期同期が成功 |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| 既に同期が有効な場合 | `userDataSyncEnablementService.isEnabled()` が true の場合は早期リターン |
| キャンセルされた場合 | ユーザーが認証をキャンセルした場合 |
| エラーが発生した場合 | 認証や同期でエラーが発生した場合 |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A[Settings Sync 有効化開始] --> B{認証プロバイダーあり?}
    B -->|No| C[エラー]
    B -->|Yes| D{既に有効?}
    D -->|Yes| E[早期リターン]
    D -->|No| F[アカウント選択]
    F --> G{アカウント選択成功?}
    G -->|No| H[キャンセル]
    G -->|Yes| I[doTurnOnSync 実行]
    I --> J{成功?}
    J -->|No| K[エラー処理]
    J -->|Yes| L[userDataAutoSyncService.turnOn]
    L --> M[sync turned on 通知]
    M --> N[_onDidTurnOnSync 発火]
```

## データベース参照・更新仕様

### 参照テーブル一覧

| テーブル名 | 用途 | 備考 |
|-----------|------|------|
| なし | ローカルデータベースは使用しない | - |

### 外部サービス参照

| サービス | 用途 | 備考 |
|---------|------|------|
| Authentication Provider | ユーザー認証 | Microsoft/GitHub アカウント |
| User Data Sync Store | 同期データの保存・取得 | クラウドストレージ |

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| 認証失敗 | アカウントが利用できない | エラーメッセージを表示 |
| 同期エラー | 同期処理中のエラー | エラーメッセージを表示 |

## 配信設定

### レート制限

| 項目 | 内容 |
|-----|------|
| 制限なし | ユーザー操作に応じて1回表示 |

### 配信時間帯

制限なし

## セキュリティ考慮事項

- 通知には機密情報は含まれない
- 認証情報はこの通知には含まれない

## 備考

- `SYNC_TITLE` は国際化対応されており、表示言語に応じて変わる
- この通知の後、`_onDidTurnOnSync` イベントが発火し、UI が更新される

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

Settings Sync の基本構造を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | userDataSync.ts | `src/vs/workbench/services/userDataSync/common/userDataSync.ts` | `SYNC_TITLE` 定義、インターフェース |

**読解のコツ**: `SYNC_TITLE` は国際化対応のため `localize2` を使用し、`.value` プロパティで実際の文字列を取得する。

#### Step 2: エントリーポイントを理解する

通知が発行される処理を特定する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | userDataSyncWorkbenchService.ts | `src/vs/workbench/services/userDataSync/browser/userDataSyncWorkbenchService.ts` | `turnOn()` メソッド |

**主要処理フロー**:
1. **行288-294**: 前提条件チェック（認証プロバイダー、既存の有効化状態）
2. **行299-307**: アカウント選択
3. **行324**: `doTurnOnSync()` で初期同期実行
4. **行329**: `userDataAutoSyncService.turnOn()` で自動同期有効化
5. **行340**: `notificationService.info()` で通知発行
6. **行341**: `_onDidTurnOnSync.fire()` でイベント発火

#### Step 3: 同期処理の詳細を理解する

初期同期処理の詳細を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | userDataSyncWorkbenchService.ts | `src/vs/workbench/services/userDataSync/browser/userDataSyncWorkbenchService.ts` | `doTurnOnSync()` メソッド |

**主要処理フロー**:
- マニュアル同期タスクを作成
- プログレスダイアログを表示
- 初期同期を実行

### プログラム呼び出し階層図

```
ユーザーが Settings Sync を有効化
    │
    ├─ UserDataSyncWorkbenchService.turnOn()
    │      │
    │      ├─ 前提条件チェック
    │      │      ├─ authenticationProviders.length > 0
    │      │      └─ !userDataSyncEnablementService.isEnabled()
    │      │
    │      ├─ pick() - アカウント選択
    │      │
    │      ├─ doTurnOnSync()
    │      │      └─ 初期同期実行
    │      │
    │      ├─ userDataAutoSyncService.turnOn()
    │      │      └─ 自動同期有効化
    │      │
    │      ├─ notificationService.info()
    │      │      │
    │      │      └─ "sync turned on"
    │      │             (SYNC_TITLE.value + " is turned on")
    │      │
    │      └─ _onDidTurnOnSync.fire()
    │             └─ UI 更新トリガー
```

### データフロー図

```
[入力]                    [処理]                         [出力]

ユーザー操作         ───▶ turnOn()                 ───▶ 同期有効化
(Settings Sync                  │
 を有効化)                      │
                                ↓
                          [認証フロー]
                                │
                                ↓
                          [初期同期]
                                │
                                ↓
                          [自動同期有効化]
                                │
                                ↓
                          notificationService.info()
                                │
                                ↓
                          Notification
                          (Info レベル)
                          "Settings Sync is turned on"
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| userDataSyncWorkbenchService.ts | `src/vs/workbench/services/userDataSync/browser/userDataSyncWorkbenchService.ts` | ソース | 通知発行元、同期サービス |
| userDataSync.ts | `src/vs/workbench/services/userDataSync/common/userDataSync.ts` | ソース | 定数・インターフェース定義 |
| userDataAutoSyncService.ts | `src/vs/platform/userDataSync/common/userDataAutoSyncService.ts` | ソース | 自動同期サービス |
| notification.ts | `src/vs/platform/notification/common/notification.ts` | ソース | 通知サービスインターフェース |
