# 通知設計書 21-accept failed

## 概要

本ドキュメントは、VSCodeの設定同期機能において、同期の競合解決時に変更の受け入れに失敗した場合に表示されるエラー通知「accept failed」の設計仕様を記載したものである。

### 本通知の処理概要

本通知は、ユーザーデータ同期（Settings Sync）において、競合が発生した際に「Replace Remote」または「Replace Local」の操作を選択したが、その変更の適用処理が失敗した場合にユーザーに通知するエラーメッセージである。

**業務上の目的・背景**：設定同期機能では、ローカルとリモートのデータに差異（競合）が生じることがある。ユーザーはどちらの変更を採用するか選択できるが、その適用処理が技術的な問題（ネットワークエラー、サーバーエラー、データ整合性エラーなど）で失敗することがある。この通知により、ユーザーは操作が失敗したことを認識し、ログを確認して原因を調査したり、再試行したりするアクションを取ることができる。

**通知の送信タイミング**：`acceptRemote`または`acceptLocal`メソッド内で`userDataSyncService.accept`を呼び出し、例外がスローされたときに発火する。

**通知の受信者**：VSCodeを使用中で、設定同期機能を有効にしており、競合解決操作を実行したユーザー。

**通知内容の概要**：「Error while accepting changes. Please check [logs]({0}) for more details.」というメッセージが表示され、{0}にはログを表示するコマンドへのリンクが埋め込まれる。

**期待されるアクション**：ユーザーはログリンクをクリックして詳細な原因を確認し、問題を理解した上で再度操作を試みるか、必要に応じてサポートに問い合わせる。

## 通知種別

アプリ内通知（VSCode Notification Service）

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 同期 |
| 優先度 | 高（エラー通知） |
| リトライ | 無し |

### 送信先決定ロジック

操作を実行したユーザーのVSCodeインスタンスに直接表示される。

## 通知テンプレート

### アプリ内通知

| 項目 | 内容 |
|-----|------|
| 通知タイプ | Error（notificationService.error） |
| メッセージキー | 'accept failed' |
| ローカライズ | Yes（nls.localize使用） |

### 本文テンプレート

```
Error while accepting changes. Please check [logs](command:workbench.userDataSync.actions.showLog) for more details.
```

### 添付ファイル

| ファイル名 | 形式 | 条件 | 説明 |
|----------|------|------|------|
| なし | - | - | 添付ファイルなし |

## テンプレート変数

| 変数名 | 説明 | データ取得元 | 必須 |
|--------|------|-------------|-----|
| {0} | ログ表示コマンドへのリンク | SHOW_SYNC_LOG_COMMAND_ID定数 | Yes |

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| ユーザー操作 | Replace Remote/Replace Localボタンクリック | acceptRemote/acceptLocalメソッドで例外発生時 | 競合解決の変更受け入れ失敗 |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| 正常完了時 | accept処理が正常に完了した場合は通知しない |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A[競合通知からReplace Remote/Localを選択] --> B[acceptRemote/acceptLocalメソッド呼び出し]
    B --> C[userDataSyncService.accept実行]
    C --> D{処理結果}
    D -->|成功| E[正常終了]
    D -->|例外発生| F[notificationService.errorでエラー通知]
    F --> G[ユーザーにエラーメッセージ表示]
    G --> H[ログリンク提供]
```

## データベース参照・更新仕様

### 参照テーブル一覧

| テーブル名 | 用途 | 備考 |
|-----------|------|------|
| なし | - | データベースは使用しない |

### 更新テーブル一覧

| テーブル名 | 操作 | 概要 |
|-----------|------|------|
| なし | - | データベースは使用しない |

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| ネットワークエラー | サーバーとの通信失敗 | ログで詳細確認、再試行 |
| データ整合性エラー | 同期データの不整合 | ログで詳細確認、データリセット |
| 認証エラー | セッション期限切れ | 再ログイン |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 0（自動リトライなし） |
| リトライ間隔 | - |
| リトライ対象エラー | - |

## 配信設定

### レート制限

| 項目 | 内容 |
|-----|------|
| 1分あたり上限 | 制限なし |
| 1日あたり上限 | 制限なし |

### 配信時間帯

制限なし（操作時即座に通知）

## セキュリティ考慮事項

- エラーメッセージに機密情報を含めない
- ログへのリンクはコマンドプロトコルを使用

## 備考

- この通知はVSCodeのNotification Serviceを使用して表示される
- ログリンクはMarkdown形式でコマンドURIを埋め込んでいる

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

競合解決に関連するデータ構造を理解することが重要。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | userDataSync.ts | `src/vs/platform/userDataSync/common/userDataSync.ts` | IUserDataSyncResource、IResourcePreviewなどの型定義を確認 |

**読解のコツ**: TypeScriptのインターフェース定義を先に確認し、データの構造を把握する。

#### Step 2: エントリーポイントを理解する

通知が発火する起点を特定する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | userDataSync.ts | `src/vs/workbench/contrib/userDataSync/browser/userDataSync.ts` | acceptRemote/acceptLocalメソッドの実装 |

**主要処理フロー**:
1. **226-231行目**: acceptRemoteメソッド - リモート変更の受け入れ処理
2. **234-240行目**: acceptLocalメソッド - ローカル変更の受け入れ処理
3. **230行目、239行目**: 例外発生時のnotificationService.error呼び出し

#### Step 3: 通知サービスの仕組みを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | notification.ts | `src/vs/platform/notification/common/notification.ts` | INotificationServiceインターフェースの定義 |

**主要処理フロー**:
- notificationService.errorメソッドがエラー通知を表示

### プログラム呼び出し階層図

```
UserDataSyncWorkbenchContribution (userDataSync.ts)
    │
    ├─ acceptRemote(syncResource, conflict)
    │      └─ userDataSyncService.accept()
    │              └─ [例外時] notificationService.error('accept failed', ...)
    │
    └─ acceptLocal(syncResource, conflict)
           └─ userDataSyncService.accept()
                   └─ [例外時] notificationService.error('accept failed', ...)
```

### データフロー図

```
[入力]                    [処理]                         [出力]

ユーザー操作          acceptRemote/acceptLocal        エラー通知
(ボタンクリック) ───▶  メソッド実行              ───▶ Notification Service
                              │
                              ▼
                      userDataSyncService.accept
                              │
                              ▼
                         [例外発生]
                              │
                              ▼
                      notificationService.error
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| userDataSync.ts | `src/vs/workbench/contrib/userDataSync/browser/userDataSync.ts` | ソース | メイン実装、通知発火ロジック |
| userDataSync.ts | `src/vs/platform/userDataSync/common/userDataSync.ts` | ソース | 同期サービスインターフェース定義 |
| notification.ts | `src/vs/platform/notification/common/notification.ts` | ソース | 通知サービスインターフェース |
| nls.ts | `src/vs/nls.ts` | ソース | ローカライズ機能 |
