# 通知設計書 22-too many profiles

## 概要

本ドキュメントは、VSCodeの設定同期機能において、同期対象のプロファイル数が上限（20個）を超えた場合に表示されるエラー通知「too many profiles」の設計仕様を記載したものである。

### 本通知の処理概要

本通知は、ユーザーデータ同期（Settings Sync）において、ローカルに作成されたプロファイル数が20個を超えた場合に、プロファイルの同期を自動的に無効化し、ユーザーにその旨を通知するエラーメッセージである。

**業務上の目的・背景**：VSCodeは複数のプロファイルをサポートしており、各プロファイルには独自の設定、拡張機能、キーバインドなどを保存できる。しかし、Settings Syncサービスには同期可能なプロファイル数に上限（20個）が設けられている。この制限を超えるとサービスの安定性やパフォーマンスに影響を与える可能性があるため、自動的に同期を無効化し、ユーザーにアクションを促す必要がある。

**通知の送信タイミング**：`onAutoSyncError`メソッド内で、`UserDataSyncErrorCode.LocalTooManyProfiles`エラーコードを受信したとき、または`UserDataProfilesManifestSynchroniser.applyResult`メソッド内でプロファイル数が20を超えた場合に発火する。

**通知の受信者**：VSCodeを使用中で、設定同期機能を有効にしており、20個以上のプロファイルを作成したユーザー。

**通知内容の概要**：「Disabled syncing profiles because there are too many profiles to sync. Settings Sync supports syncing maximum 20 profiles. Please reduce the number of profiles and enable sync」というメッセージが表示される。

**期待されるアクション**：ユーザーは不要なプロファイルを削除して20個以下に減らし、その後プロファイルの同期を手動で再有効化する。

## 通知種別

アプリ内通知（VSCode Notification Service）

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 同期 |
| 優先度 | 高（エラー通知） |
| リトライ | 無し |

### 送信先決定ロジック

設定同期を実行中のユーザーのVSCodeインスタンスに直接表示される。

## 通知テンプレート

### アプリ内通知

| 項目 | 内容 |
|-----|------|
| 通知タイプ | Error（notificationService.error） |
| メッセージキー | 'too many profiles' |
| ローカライズ | Yes（nls.localize使用） |

### 本文テンプレート

```
Disabled syncing profiles because there are too many profiles to sync. Settings Sync supports syncing maximum 20 profiles. Please reduce the number of profiles and enable sync
```

### 添付ファイル

| ファイル名 | 形式 | 条件 | 説明 |
|----------|------|------|------|
| なし | - | - | 添付ファイルなし |

## テンプレート変数

| 変数名 | 説明 | データ取得元 | 必須 |
|--------|------|-------------|-----|
| なし | - | - | - |

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| 自動同期 | onAutoSyncError | UserDataSyncErrorCode.LocalTooManyProfiles | プロファイル数超過エラー |
| 同期処理 | applyResult実行時 | プロファイル数 > 20 | プロファイルマニフェスト同期時の検証 |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| プロファイル数が20以下 | 正常範囲内の場合は通知しない |
| 同期が無効 | 既に同期が無効化されている場合は通知しない |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A[自動同期実行] --> B{プロファイル数チェック}
    B -->|20以下| C[正常同期継続]
    B -->|20超過| D[LocalTooManyProfilesエラー発生]
    D --> E[プロファイル同期を無効化]
    E --> F[notificationService.errorでエラー通知]
    F --> G[ユーザーにアクション促す]
```

## データベース参照・更新仕様

### 参照テーブル一覧

| テーブル名 | 用途 | 備考 |
|-----------|------|------|
| なし | - | データベースは使用しない |

### 更新テーブル一覧

| テーブル名 | 操作 | 概要 |
|-----------|------|------|
| なし | - | データベースは使用しない |

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| LocalTooManyProfiles | プロファイル数が20を超過 | プロファイル削減後、手動で同期再有効化 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 0（自動リトライなし） |
| リトライ間隔 | - |
| リトライ対象エラー | - |

## 配信設定

### レート制限

| 項目 | 内容 |
|-----|------|
| 1分あたり上限 | 制限なし |
| 1日あたり上限 | 制限なし |

### 配信時間帯

制限なし（同期エラー発生時即座に通知）

## セキュリティ考慮事項

- プロファイル名などの個人情報はメッセージに含めない
- 上限値（20）は定数としてコードに埋め込まれている

## 備考

- プロファイル数の上限20は`userDataProfilesManifestSync.ts`の行181-182で検証されている
- 同期無効化は`disableSync(SyncResource.Profiles)`で実行される

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

プロファイル同期に関連するデータ構造を理解することが重要。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | userDataSync.ts | `src/vs/platform/userDataSync/common/userDataSync.ts` | UserDataSyncErrorCode、SyncResourceの定義 |
| 1-2 | userDataProfilesManifestSync.ts | `src/vs/platform/userDataSync/common/userDataProfilesManifestSync.ts` | ISyncUserDataProfile型定義 |

**読解のコツ**: エラーコード`LocalTooManyProfiles`がどのように定義されているかを確認する。

#### Step 2: エントリーポイントを理解する

通知が発火する起点を特定する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | userDataSync.ts | `src/vs/workbench/contrib/userDataSync/browser/userDataSync.ts` | onAutoSyncErrorメソッドの実装 |

**主要処理フロー**:
1. **277-279行目**: LocalTooManyProfilesエラーケースの処理
2. **278行目**: disableSync(SyncResource.Profiles)呼び出し
3. **279行目**: notificationService.error呼び出し

#### Step 3: プロファイル同期の検証ロジックを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | userDataProfilesManifestSync.ts | `src/vs/platform/userDataSync/common/userDataProfilesManifestSync.ts` | applyResultメソッドの実装 |

**主要処理フロー**:
- **181-182行目**: プロファイル数の検証（20を超えるとエラー）
- **182行目**: UserDataSyncError生成

### プログラム呼び出し階層図

```
UserDataSyncWorkbenchContribution (userDataSync.ts)
    │
    ├─ onAutoSyncError(error)
    │      │
    │      └─ [case LocalTooManyProfiles]
    │             ├─ disableSync(SyncResource.Profiles)
    │             └─ notificationService.error('too many profiles', ...)
    │
UserDataProfilesManifestSynchroniser (userDataProfilesManifestSync.ts)
    │
    └─ applyResult(...)
           └─ [プロファイル数 > 20]
                  └─ throw UserDataSyncError('Too many profiles...', LocalTooManyProfiles)
```

### データフロー図

```
[入力]                    [処理]                         [出力]

自動同期実行          プロファイル数検証            エラー通知
                ───▶  (applyResult)           ───▶
                              │
                              ▼
                      [20超過検出]
                              │
                              ▼
                      UserDataSyncError
                              │
                              ▼
                      onAutoSyncError
                              │
                              ▼
                      notificationService.error
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| userDataSync.ts | `src/vs/workbench/contrib/userDataSync/browser/userDataSync.ts` | ソース | エラーハンドリング、通知発火 |
| userDataProfilesManifestSync.ts | `src/vs/platform/userDataSync/common/userDataProfilesManifestSync.ts` | ソース | プロファイル同期、数量検証 |
| userDataSync.ts | `src/vs/platform/userDataSync/common/userDataSync.ts` | ソース | エラーコード定義 |
| notification.ts | `src/vs/platform/notification/common/notification.ts` | ソース | 通知サービスインターフェース |
