# 通知設計書 23-auth failed

## 概要

本ドキュメントは、VSCodeの設定同期機能において、設定同期をオンにしようとした際に認証に失敗した場合に表示されるエラー通知「auth failed」の設計仕様を記載したものである。

### 本通知の処理概要

本通知は、ユーザーが設定同期（Settings Sync）を有効化しようとした際に、認証プロバイダー（Microsoft、GitHubなど）での認証が失敗した場合にユーザーに通知するエラーメッセージである。

**業務上の目的・背景**：設定同期機能を利用するには、ユーザーは認証プロバイダーを通じてサインインする必要がある。認証失敗は、無効な資格情報、セッションの期限切れ、アカウントの権限不足、またはサービス側の問題など、様々な原因で発生する可能性がある。この通知により、ユーザーは認証が失敗したことを認識し、再試行や別の方法でのサインインを検討できる。

**通知の送信タイミング**：`turnOn`メソッド内で、`UserDataSyncErrorCode.Unauthorized`または`UserDataSyncErrorCode.Forbidden`エラーコードを持つ`UserDataSyncError`がスローされたときに発火する。

**通知の受信者**：VSCodeで設定同期を有効化しようとしており、認証プロセスで失敗したユーザー。

**通知内容の概要**：「Error while turning on Settings Sync: Authentication failed.」というシンプルなエラーメッセージが表示される。

**期待されるアクション**：ユーザーは認証情報を確認し、再度サインインを試みる。必要に応じて、別の認証プロバイダーを使用するか、アカウントの権限を確認する。

## 通知種別

アプリ内通知（VSCode Notification Service）

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 同期 |
| 優先度 | 高（エラー通知） |
| リトライ | 無し |

### 送信先決定ロジック

設定同期のオン操作を実行したユーザーのVSCodeインスタンスに直接表示される。

## 通知テンプレート

### アプリ内通知

| 項目 | 内容 |
|-----|------|
| 通知タイプ | Error（notificationService.error） |
| メッセージキー | 'auth failed' |
| ローカライズ | Yes（nls.localize使用） |

### 本文テンプレート

```
Error while turning on Settings Sync: Authentication failed.
```

### 添付ファイル

| ファイル名 | 形式 | 条件 | 説明 |
|----------|------|------|------|
| なし | - | - | 添付ファイルなし |

## テンプレート変数

| 変数名 | 説明 | データ取得元 | 必須 |
|--------|------|-------------|-----|
| なし | - | - | - |

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| ユーザー操作 | Turn On Sync実行 | UserDataSyncError.Unauthorized発生時 | 認証されていない |
| ユーザー操作 | Turn On Sync実行 | UserDataSyncError.Forbidden発生時 | アクセス禁止 |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| 認証成功時 | 正常に認証が完了した場合は通知しない |
| キャンセル時 | ユーザーが操作をキャンセルした場合は通知しない |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A[Turn On Sync実行] --> B[認証プロバイダー選択]
    B --> C[認証プロセス開始]
    C --> D{認証結果}
    D -->|成功| E[同期有効化完了]
    D -->|Unauthorized/Forbidden| F[notificationService.errorでエラー通知]
    F --> G[ユーザーにエラーメッセージ表示]
    D -->|キャンセル| H[処理終了（通知なし）]
```

## データベース参照・更新仕様

### 参照テーブル一覧

| テーブル名 | 用途 | 備考 |
|-----------|------|------|
| なし | - | データベースは使用しない |

### 更新テーブル一覧

| テーブル名 | 操作 | 概要 |
|-----------|------|------|
| なし | - | データベースは使用しない |

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| Unauthorized | 認証トークンが無効または期限切れ | 再サインイン |
| Forbidden | アクセス権限がない | アカウント権限の確認、別アカウントでの試行 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 0（自動リトライなし） |
| リトライ間隔 | - |
| リトライ対象エラー | - |

## 配信設定

### レート制限

| 項目 | 内容 |
|-----|------|
| 1分あたり上限 | 制限なし |
| 1日あたり上限 | 制限なし |

### 配信時間帯

制限なし（操作時即座に通知）

## セキュリティ考慮事項

- 認証エラーの詳細情報（トークン、アカウント情報など）をエラーメッセージに含めない
- 汎用的な「Authentication failed」メッセージで情報漏洩を防止

## 備考

- UnauthorizedとForbiddenは同じメッセージで処理される
- この通知はturnOnメソッドのcatchブロック内で処理される

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

認証エラーに関連するエラーコードを理解することが重要。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | userDataSync.ts | `src/vs/platform/userDataSync/common/userDataSync.ts` | UserDataSyncErrorCode.Unauthorized、UserDataSyncErrorCode.Forbiddenの定義 |

**読解のコツ**: エラーコードの列挙型を確認し、認証関連のエラーコードを把握する。

#### Step 2: エントリーポイントを理解する

通知が発火する起点を特定する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | userDataSync.ts | `src/vs/workbench/contrib/userDataSync/browser/userDataSync.ts` | turnOnメソッドの実装 |

**主要処理フロー**:
1. **486-552行目**: turnOnメソッド全体
2. **503行目**: UserDataSyncErrorのinstanceof判定
3. **542-545行目**: Unauthorized/Forbiddenエラーケースの処理
4. **544行目**: notificationService.error('auth failed', ...)呼び出し

#### Step 3: 認証サービスとの連携を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | userDataSyncWorkbenchService.ts | `src/vs/workbench/services/userDataSync/browser/userDataSyncWorkbenchService.ts` | turnOnメソッドの実装 |

**主要処理フロー**:
- 認証プロバイダーの選択と認証プロセス

### プログラム呼び出し階層図

```
UserDataSyncWorkbenchContribution (userDataSync.ts)
    │
    └─ turnOn()
           │
           ├─ askToConfigure()
           │
           ├─ userDataSyncWorkbenchService.turnOn()
           │
           └─ [catch UserDataSyncError]
                  │
                  └─ [case Unauthorized/Forbidden]
                         └─ notificationService.error('auth failed', ...)
```

### データフロー図

```
[入力]                    [処理]                         [出力]

Turn On Sync操作     認証プロバイダーでの認証       エラー通知
(メニュー選択)  ───▶  処理                    ───▶
                              │
                              ▼
                      [認証失敗]
                              │
                              ▼
                      UserDataSyncError
                      (Unauthorized/Forbidden)
                              │
                              ▼
                      notificationService.error
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| userDataSync.ts | `src/vs/workbench/contrib/userDataSync/browser/userDataSync.ts` | ソース | turnOnメソッド、エラーハンドリング |
| userDataSyncWorkbenchService.ts | `src/vs/workbench/services/userDataSync/browser/userDataSyncWorkbenchService.ts` | ソース | 認証サービス連携 |
| userDataSync.ts | `src/vs/platform/userDataSync/common/userDataSync.ts` | ソース | エラーコード定義 |
| notification.ts | `src/vs/platform/notification/common/notification.ts` | ソース | 通知サービスインターフェース |
