# 通知設計書 24-turn on failed with user data sync error

## 概要

本ドキュメントは、VSCodeの設定同期機能において、設定同期をオンにしようとした際に様々なユーザーデータ同期エラーが発生した場合に表示されるエラー通知「turn on failed with user data sync error」の設計仕様を記載したものである。

### 本通知の処理概要

本通知は、ユーザーが設定同期（Settings Sync）を有効化しようとした際に、認証エラー以外の`UserDataSyncError`が発生した場合にユーザーに通知するエラーメッセージである。エラーの詳細はログを通じて確認できるようになっている。

**業務上の目的・背景**：設定同期を有効化する際には、様々な技術的な問題が発生する可能性がある（ネットワーク接続の問題、サーバーエラー、データの不整合など）。この汎用的なエラー通知により、ユーザーは問題が発生したことを認識し、ログを確認することで原因を特定し、適切な対処を行うことができる。

**通知の送信タイミング**：`turnOn`メソッド内で、認証エラー（Unauthorized/Forbidden）以外の`UserDataSyncError`がスローされたときに発火する。

**通知の受信者**：VSCodeで設定同期を有効化しようとしており、同期プロセスでエラーが発生したユーザー。

**通知内容の概要**：「Error while turning on Settings Sync. Please check [logs]({0}) for more details.」というメッセージが表示され、{0}にはログを表示するコマンドへのリンクが埋め込まれる。

**期待されるアクション**：ユーザーはログリンクをクリックして詳細なエラー情報を確認し、問題を理解した上で再度操作を試みるか、必要に応じてサポートに問い合わせる。

## 通知種別

アプリ内通知（VSCode Notification Service）

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 同期 |
| 優先度 | 高（エラー通知） |
| リトライ | 無し |

### 送信先決定ロジック

設定同期のオン操作を実行したユーザーのVSCodeインスタンスに直接表示される。

## 通知テンプレート

### アプリ内通知

| 項目 | 内容 |
|-----|------|
| 通知タイプ | Error（notificationService.error） |
| メッセージキー | 'turn on failed with user data sync error' |
| ローカライズ | Yes（nls.localize使用） |

### 本文テンプレート

```
Error while turning on Settings Sync. Please check [logs](command:workbench.userDataSync.actions.showLog) for more details.
```

### 添付ファイル

| ファイル名 | 形式 | 条件 | 説明 |
|----------|------|------|------|
| なし | - | - | 添付ファイルなし |

## テンプレート変数

| 変数名 | 説明 | データ取得元 | 必須 |
|--------|------|-------------|-----|
| {0} | ログ表示コマンドへのリンク | SHOW_SYNC_LOG_COMMAND_ID定数 | Yes |

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| ユーザー操作 | Turn On Sync実行 | UserDataSyncError発生時（Unauthorized/Forbidden以外） | 一般的な同期エラー |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| 正常完了時 | 同期が正常に有効化された場合は通知しない |
| キャンセル時 | ユーザーが操作をキャンセルした場合は通知しない |
| 認証エラー時 | Unauthorized/Forbiddenエラーは別の通知（auth failed）で処理 |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A[Turn On Sync実行] --> B[同期有効化プロセス開始]
    B --> C{処理結果}
    C -->|成功| D[同期有効化完了]
    C -->|Unauthorized/Forbidden| E[auth failed通知]
    C -->|その他のUserDataSyncError| F[本通知を発火]
    F --> G[notificationService.errorでエラー通知]
    G --> H[ログリンク付きメッセージ表示]
    C -->|キャンセル| I[処理終了（通知なし）]
```

## データベース参照・更新仕様

### 参照テーブル一覧

| テーブル名 | 用途 | 備考 |
|-----------|------|------|
| なし | - | データベースは使用しない |

### 更新テーブル一覧

| テーブル名 | 操作 | 概要 |
|-----------|------|------|
| なし | - | データベースは使用しない |

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| ネットワークエラー | サーバーとの通信失敗 | ログ確認、ネットワーク接続確認後再試行 |
| サーバーエラー | バックエンドサービスの問題 | ログ確認、時間をおいて再試行 |
| データ整合性エラー | 同期データの不整合 | ログ確認、データリセット |
| 設定エラー | 無効な設定値 | ログ確認、設定の見直し |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 0（自動リトライなし） |
| リトライ間隔 | - |
| リトライ対象エラー | - |

## 配信設定

### レート制限

| 項目 | 内容 |
|-----|------|
| 1分あたり上限 | 制限なし |
| 1日あたり上限 | 制限なし |

### 配信時間帯

制限なし（操作時即座に通知）

## セキュリティ考慮事項

- エラーの詳細情報は通知メッセージに含めず、ログに出力
- ログへのリンクはコマンドプロトコルを使用

## 備考

- この通知は認証エラー以外の全てのUserDataSyncErrorをカバーする汎用エラー通知
- ログリンクはMarkdown形式でコマンドURIを埋め込んでいる

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

UserDataSyncErrorに関連するエラーコードを理解することが重要。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | userDataSync.ts | `src/vs/platform/userDataSync/common/userDataSync.ts` | UserDataSyncErrorCode列挙型の全体を確認 |

**読解のコツ**: 様々なエラーコード（TooManyRequests、TooManyRequestsAndRetryAfter、LocalPreconditionFailed等）を把握する。

#### Step 2: エントリーポイントを理解する

通知が発火する起点を特定する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | userDataSync.ts | `src/vs/workbench/contrib/userDataSync/browser/userDataSync.ts` | turnOnメソッドのcatchブロック |

**主要処理フロー**:
1. **486-552行目**: turnOnメソッド全体
2. **503行目**: UserDataSyncErrorのinstanceof判定
3. **546-548行目**: default caseの処理（auth failed以外のUserDataSyncError）
4. **547行目**: notificationService.error('turn on failed with user data sync error', ...)呼び出し

#### Step 3: ログ表示コマンドを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | userDataSync.ts | `src/vs/workbench/services/userDataSync/common/userDataSync.ts` | SHOW_SYNC_LOG_COMMAND_ID定数 |

**主要処理フロー**:
- ログ表示コマンドのID定義

### プログラム呼び出し階層図

```
UserDataSyncWorkbenchContribution (userDataSync.ts)
    │
    └─ turnOn()
           │
           ├─ askToConfigure()
           │
           ├─ userDataSyncWorkbenchService.turnOn()
           │
           └─ [catch UserDataSyncError]
                  │
                  ├─ [case Unauthorized/Forbidden]
                  │      └─ notificationService.error('auth failed', ...)
                  │
                  └─ [default]
                         └─ notificationService.error('turn on failed...', ...)
```

### データフロー図

```
[入力]                    [処理]                         [出力]

Turn On Sync操作     同期有効化プロセス             エラー通知
(メニュー選択)  ───▶                          ───▶
                              │
                              ▼
                      [エラー発生]
                      (認証以外)
                              │
                              ▼
                      UserDataSyncError
                              │
                              ▼
                      notificationService.error
                              │
                              ▼
                      ログリンク付きメッセージ
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| userDataSync.ts | `src/vs/workbench/contrib/userDataSync/browser/userDataSync.ts` | ソース | turnOnメソッド、エラーハンドリング |
| userDataSync.ts | `src/vs/platform/userDataSync/common/userDataSync.ts` | ソース | UserDataSyncErrorCode定義 |
| userDataSync.ts | `src/vs/workbench/services/userDataSync/common/userDataSync.ts` | ソース | SHOW_SYNC_LOG_COMMAND_ID定義 |
| notification.ts | `src/vs/platform/notification/common/notification.ts` | ソース | 通知サービスインターフェース |
