# 通知設計書 25-testError

## 概要

本ドキュメントは、VSCodeのテスト機能において、テスト実行中にエラーが発生した場合に表示されるエラー通知「testError」の設計仕様を記載したものである。

### 本通知の処理概要

本通知は、ユーザーがテストを実行した際に、テストコントローラーからエラーが返された場合にユーザーに通知するエラーメッセージである。

**業務上の目的・背景**：VSCodeはテストエクスプローラーを通じて、様々なテストフレームワーク（Jest、Mocha、pytest等）のテストを実行できる。テスト実行中に、テストフレームワーク自体のエラー、設定の問題、テストコントローラーの内部エラーなどが発生する可能性がある。この通知により、ユーザーはテスト実行が正常に完了しなかったことを認識し、問題の原因を調査できる。

**通知の送信タイミング**：`runTests`または`startContinuousRun`メソッド内で、テストコントローラーからエラーが返されたときに発火する。

**通知の受信者**：VSCodeでテストを実行しており、テスト実行中にエラーが発生したユーザー。

**通知内容の概要**：「An error occurred attempting to run tests: {0}」というメッセージが表示され、{0}には具体的なエラーメッセージが挿入される。

**期待されるアクション**：ユーザーはエラーメッセージを確認し、テスト設定の見直し、テストコントローラーの更新、またはテストコードの修正を行う。

## 通知種別

アプリ内通知（VSCode Notification Service）

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 同期 |
| 優先度 | 高（エラー通知） |
| リトライ | 無し |

### 送信先決定ロジック

テスト実行を開始したユーザーのVSCodeインスタンスに直接表示される。

## 通知テンプレート

### アプリ内通知

| 項目 | 内容 |
|-----|------|
| 通知タイプ | Error（notificationService.error） |
| メッセージキー | 'testError' |
| ローカライズ | Yes（localize使用） |

### 本文テンプレート

```
An error occurred attempting to run tests: {0}
```

### 添付ファイル

| ファイル名 | 形式 | 条件 | 説明 |
|----------|------|------|------|
| なし | - | - | 添付ファイルなし |

## テンプレート変数

| 変数名 | 説明 | データ取得元 | 必須 |
|--------|------|-------------|-----|
| {0} | エラーメッセージの連結 | result.map(r => r.error).filter(isDefined).join(' ') | Yes |

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| ユーザー操作 | runTests実行 | テストコントローラーからエラー返却時 | 単発テスト実行エラー |
| ユーザー操作 | startContinuousRun実行 | テストコントローラーからエラー返却時 | 継続的テスト実行エラー |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| 正常完了時 | テストが正常に実行された場合は通知しない |
| エラーなし | result内にerrorプロパティがない場合は通知しない |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A[テスト実行開始] --> B[テストコントローラーにリクエスト]
    B --> C[テスト実行]
    C --> D{結果確認}
    D -->|成功| E[テスト結果表示]
    D -->|エラーあり| F[エラーメッセージ収集]
    F --> G[notificationService.errorでエラー通知]
    G --> H[ユーザーにエラーメッセージ表示]
```

## データベース参照・更新仕様

### 参照テーブル一覧

| テーブル名 | 用途 | 備考 |
|-----------|------|------|
| なし | - | データベースは使用しない |

### 更新テーブル一覧

| テーブル名 | 操作 | 概要 |
|-----------|------|------|
| なし | - | データベースは使用しない |

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| テストコントローラーエラー | テストコントローラーの内部エラー | 拡張機能の更新・再インストール |
| 設定エラー | テスト設定の問題 | テスト設定の見直し |
| ランタイムエラー | テスト実行環境の問題 | 環境設定の確認 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 0（自動リトライなし） |
| リトライ間隔 | - |
| リトライ対象エラー | - |

## 配信設定

### レート制限

| 項目 | 内容 |
|-----|------|
| 1分あたり上限 | 制限なし |
| 1日あたり上限 | 制限なし |

### 配信時間帯

制限なし（テスト実行時即座に通知）

## セキュリティ考慮事項

- エラーメッセージにはテストコントローラーから返されたメッセージがそのまま含まれる
- 機密情報がエラーメッセージに含まれないようテストコントローラー側での配慮が必要

## 備考

- 複数のエラーがある場合はスペースで連結して表示される
- この通知はTestServiceクラス内で処理される

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

テスト実行結果に関連するデータ構造を理解することが重要。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | testService.ts | `src/vs/workbench/contrib/testing/common/testService.ts` | ITestRunResult、IMainThreadTestControllerインターフェース |

**読解のコツ**: テスト実行結果の構造と、errorプロパティの存在を確認する。

#### Step 2: エントリーポイントを理解する

通知が発火する起点を特定する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | testServiceImpl.ts | `src/vs/workbench/contrib/testing/common/testServiceImpl.ts` | runTests、startContinuousRunメソッド |

**主要処理フロー**:
1. **251-295行目**: runResolvedTestsメソッド
2. **281-285行目**: テストコントローラー呼び出しと結果処理
3. **283-284行目**: エラー収集と通知表示
4. **214-246行目**: startContinuousRunメソッドでも同様の処理

#### Step 3: テストコントローラーとの連携を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | testService.ts | `src/vs/workbench/contrib/testing/common/testService.ts` | IMainThreadTestControllerインターフェース |

**主要処理フロー**:
- runTestsメソッドの戻り値にerrorが含まれる場合の処理

### プログラム呼び出し階層図

```
TestService (testServiceImpl.ts)
    │
    ├─ runTests(req)
    │      └─ runResolvedTests(req)
    │             │
    │             ├─ testController.runTests(...)
    │             │      └─ [結果にerrorあり]
    │             │
    │             └─ notificationService.error('testError', ...)
    │
    └─ startContinuousRun(req)
           │
           ├─ testController.startContinuousRun(...)
           │      └─ [結果にerrorあり]
           │
           └─ notificationService.error('testError', ...)
```

### データフロー図

```
[入力]                    [処理]                         [出力]

テスト実行操作      テストコントローラー呼び出し    エラー通知
(Run Test)    ───▶                           ───▶
                              │
                              ▼
                      [結果受信]
                              │
                              ▼
                      [エラー抽出]
                      result.filter(r => r.error)
                              │
                              ▼
                      [エラー連結]
                      errs.join(' ')
                              │
                              ▼
                      notificationService.error
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| testServiceImpl.ts | `src/vs/workbench/contrib/testing/common/testServiceImpl.ts` | ソース | テストサービス実装、通知発火 |
| testService.ts | `src/vs/workbench/contrib/testing/common/testService.ts` | ソース | テストサービスインターフェース |
| notification.ts | `src/vs/platform/notification/common/notification.ts` | ソース | 通知サービスインターフェース |
| nls.ts | `src/vs/nls.ts` | ソース | ローカライズ機能 |
