# 通知設計書 26-testing.markdownPeekError

## 概要

本ドキュメントは、VSCodeのテスト機能において、テスト結果のMarkdownプレビューを開こうとした際にエラーが発生した場合に表示されるエラー通知「testing.markdownPeekError」の設計仕様を記載したものである。

### 本通知の処理概要

本通知は、ユーザーがテスト結果に含まれるMarkdownコンテンツ（テストメッセージなど）をプレビュー表示しようとした際に、何らかの理由でプレビューを開けなかった場合にユーザーに通知するエラーメッセージである。

**業務上の目的・背景**：VSCodeのテスト機能では、テスト結果にMarkdown形式のメッセージが含まれることがある。これらのメッセージをより読みやすくするために、Markdownプレビュー機能が提供されている。しかし、Markdownプレビュー拡張機能がインストールされていない、または有効になっていない場合など、プレビューを開けないケースがある。この通知により、ユーザーはプレビュー機能が利用できないことを認識できる。

**通知の送信タイミング**：`testingOutputPeek.ts`内で、Markdownプレビューを開く際に例外がスローされたときに発火する。

**通知の受信者**：VSCodeでテスト結果のMarkdownプレビューを開こうとしており、プレビューの表示に失敗したユーザー。

**通知内容の概要**：「Could not open markdown preview for message.」というシンプルなエラーメッセージが表示される。

**期待されるアクション**：ユーザーはMarkdownプレビュー拡張機能のインストール状態を確認する、または代替手段（テキストとして表示など）を利用する。

## 通知種別

アプリ内通知（VSCode Notification Service）

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 同期 |
| 優先度 | 中（警告レベル） |
| リトライ | 無し |

### 送信先決定ロジック

Markdownプレビューを開こうとしたユーザーのVSCodeインスタンスに直接表示される。

## 通知テンプレート

### アプリ内通知

| 項目 | 内容 |
|-----|------|
| 通知タイプ | Warn（notificationService.warn） |
| メッセージキー | 'testing.markdownPeekError' |
| ローカライズ | Yes（localize使用） |

### 本文テンプレート

```
Could not open markdown preview for message.
```

### 添付ファイル

| ファイル名 | 形式 | 条件 | 説明 |
|----------|------|------|------|
| なし | - | - | 添付ファイルなし |

## テンプレート変数

| 変数名 | 説明 | データ取得元 | 必須 |
|--------|------|-------------|-----|
| なし | - | - | - |

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| ユーザー操作 | Markdownプレビュー開く | プレビュー表示処理で例外発生時 | プレビュー失敗 |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| 正常表示時 | プレビューが正常に表示された場合は通知しない |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A[テスト結果のMarkdownプレビュー開く] --> B[プレビュー表示処理]
    B --> C{処理結果}
    C -->|成功| D[Markdownプレビュー表示]
    C -->|例外発生| E[notificationService.warnでエラー通知]
    E --> F[ユーザーにエラーメッセージ表示]
```

## データベース参照・更新仕様

### 参照テーブル一覧

| テーブル名 | 用途 | 備考 |
|-----------|------|------|
| なし | - | データベースは使用しない |

### 更新テーブル一覧

| テーブル名 | 操作 | 概要 |
|-----------|------|------|
| なし | - | データベースは使用しない |

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| 拡張機能なし | Markdownプレビュー拡張機能が未インストール | 拡張機能のインストール |
| 拡張機能無効 | Markdownプレビュー拡張機能が無効化されている | 拡張機能の有効化 |
| 内部エラー | プレビュー処理の内部エラー | VSCodeの再起動 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 0（自動リトライなし） |
| リトライ間隔 | - |
| リトライ対象エラー | - |

## 配信設定

### レート制限

| 項目 | 内容 |
|-----|------|
| 1分あたり上限 | 制限なし |
| 1日あたり上限 | 制限なし |

### 配信時間帯

制限なし（操作時即座に通知）

## セキュリティ考慮事項

- メッセージは汎用的な内容で、詳細なエラー情報を含まない
- テスト内容やMarkdownの内容は通知に含めない

## 備考

- この通知は警告レベル（warn）で表示される
- testingOutputPeek.tsファイル内のMarkdownプレビュー処理で使用される

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

テスト結果メッセージに関連するデータ構造を理解することが重要。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | testTypes.ts | `src/vs/workbench/contrib/testing/common/testTypes.ts` | ITestMessage型定義 |

**読解のコツ**: テストメッセージがMarkdown形式を含む可能性があることを確認する。

#### Step 2: エントリーポイントを理解する

通知が発火する起点を特定する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | testingOutputPeek.ts | `src/vs/workbench/contrib/testing/browser/testingOutputPeek.ts` | Markdownプレビュー処理 |

**主要処理フロー**:
1. **Markdownプレビューコマンド実行**: ユーザー操作
2. **プレビュー処理開始**: commandService.executeCommand呼び出し
3. **例外発生時**: catchブロックでnotificationService.warn呼び出し

#### Step 3: 通知サービスの仕組みを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | notification.ts | `src/vs/platform/notification/common/notification.ts` | INotificationServiceのwarnメソッド |

**主要処理フロー**:
- notificationService.warnメソッドが警告通知を表示

### プログラム呼び出し階層図

```
TestingOutputPeek (testingOutputPeek.ts)
    │
    └─ openMarkdownPreview()
           │
           ├─ commandService.executeCommand('markdown.showPreview', ...)
           │
           └─ [catch]
                  └─ notificationService.warn('testing.markdownPeekError', ...)
```

### データフロー図

```
[入力]                    [処理]                         [出力]

Markdownプレビュー   Markdownプレビュー処理        警告通知
操作             ───▶                          ───▶
                              │
                              ▼
                      [コマンド実行]
                      markdown.showPreview
                              │
                              ▼
                         [例外発生]
                              │
                              ▼
                      notificationService.warn
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| testingOutputPeek.ts | `src/vs/workbench/contrib/testing/browser/testingOutputPeek.ts` | ソース | テスト結果プレビュー、通知発火 |
| testTypes.ts | `src/vs/workbench/contrib/testing/common/testTypes.ts` | ソース | テストメッセージ型定義 |
| notification.ts | `src/vs/platform/notification/common/notification.ts` | ソース | 通知サービスインターフェース |
| nls.ts | `src/vs/nls.ts` | ソース | ローカライズ機能 |
