# 通知設計書 27-comments.addCommand.error

## 概要

本ドキュメントは、VSCodeのコメント機能において、コメントを追加しようとした際にカーソルがコメント可能範囲内にない場合に表示されるエラー通知「comments.addCommand.error」の設計仕様を記載したものである。

### 本通知の処理概要

本通知は、ユーザーがエディタ上でコメントを追加しようとした際に、現在のカーソル位置がコメント可能な範囲（commenting range）に含まれていない場合にユーザーに通知するエラーメッセージである。

**業務上の目的・背景**：VSCodeでは、拡張機能（GitHub Pull Requests、GitLens等）を通じてコード上にコメントを追加できる。しかし、全ての行がコメント可能なわけではなく、拡張機能が定義した「コメント可能範囲」にのみコメントを追加できる。ユーザーがコメント可能範囲外でコメントを追加しようとした場合、この通知により操作が無効であることを明確に伝える。

**通知の送信タイミング**：`addCommentAtLine`メソッド内で、`_commentingRangeDecorator.getMatchedCommentAction(range)`が空の配列を返し、かつrangeが指定されている場合に発火する。

**通知の受信者**：VSCodeでコメントを追加しようとしており、カーソルがコメント可能範囲外にあるユーザー。

**通知内容の概要**：「The cursor must be within a commenting range to add a comment.」というエラーメッセージが表示される。

**期待されるアクション**：ユーザーはカーソルをコメント可能な範囲に移動させてから、再度コメント追加操作を行う。

## 通知種別

アプリ内通知（VSCode Notification Service）

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 同期 |
| 優先度 | 高（エラー通知） |
| リトライ | 無し |

### 送信先決定ロジック

コメント追加操作を実行したユーザーのVSCodeインスタンスに直接表示される。

## 通知テンプレート

### アプリ内通知

| 項目 | 内容 |
|-----|------|
| 通知タイプ | Error（notificationService.error） |
| メッセージキー | 'comments.addCommand.error' |
| ローカライズ | Yes（nls.localize使用） |

### 本文テンプレート

```
The cursor must be within a commenting range to add a comment.
```

### 添付ファイル

| ファイル名 | 形式 | 条件 | 説明 |
|----------|------|------|------|
| なし | - | - | 添付ファイルなし |

## テンプレート変数

| 変数名 | 説明 | データ取得元 | 必須 |
|--------|------|-------------|-----|
| なし | - | - | - |

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| ユーザー操作 | コメント追加コマンド実行 | カーソル位置がコメント可能範囲外 | 範囲外でのコメント追加試行 |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| コメント可能範囲内 | カーソルがコメント可能範囲内にある場合は通知しない |
| rangeがundefined | ファイルコメントの場合は別の通知を使用 |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A[コメント追加操作] --> B[addCommentAtLine呼び出し]
    B --> C[getMatchedCommentActionで範囲チェック]
    C --> D{結果判定}
    D -->|範囲内| E[コメント追加ダイアログ表示]
    D -->|範囲外かつrange指定あり| F[notificationService.errorでエラー通知]
    F --> G[エラーメッセージ表示]
    D -->|範囲外かつrangeなし| H[ファイルコメントエラー通知]
```

## データベース参照・更新仕様

### 参照テーブル一覧

| テーブル名 | 用途 | 備考 |
|-----------|------|------|
| なし | - | データベースは使用しない |

### 更新テーブル一覧

| テーブル名 | 操作 | 概要 |
|-----------|------|------|
| なし | - | データベースは使用しない |

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| 範囲外エラー | カーソルがコメント可能範囲外 | カーソルを適切な範囲に移動 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 0（自動リトライなし） |
| リトライ間隔 | - |
| リトライ対象エラー | - |

## 配信設定

### レート制限

| 項目 | 内容 |
|-----|------|
| 1分あたり上限 | 制限なし |
| 1日あたり上限 | 制限なし |

### 配信時間帯

制限なし（操作時即座に通知）

## セキュリティ考慮事項

- カーソル位置やコード内容などの情報をエラーメッセージに含めない
- 汎用的なエラーメッセージで情報漏洩を防止

## 備考

- この通知はCommentControllerクラス内のaddCommentAtLineメソッドで発火する
- 行1193-1194行目に実装されている

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

コメント範囲に関連するデータ構造を理解することが重要。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | commentService.ts | `src/vs/workbench/contrib/comments/browser/commentService.ts` | ICommentInfo、CommentingRangesの定義 |

**読解のコツ**: コメント可能範囲（commenting ranges）がどのように定義されているかを確認する。

#### Step 2: エントリーポイントを理解する

通知が発火する起点を特定する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | commentsController.ts | `src/vs/workbench/contrib/comments/browser/commentsController.ts` | addCommentAtLineメソッド |

**主要処理フロー**:
1. **1188-1237行目**: addCommentAtLineメソッド全体
2. **1189行目**: getMatchedCommentAction呼び出し
3. **1190-1198行目**: newCommentInfosが空の場合の処理
4. **1193-1194行目**: rangeが指定されている場合のエラー通知

#### Step 3: コメント範囲の取得ロジックを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | commentsController.ts | `src/vs/workbench/contrib/comments/browser/commentsController.ts` | CommentingRangeDecoratorクラス |

**主要処理フロー**:
- getMatchedCommentActionメソッドが範囲マッチングを行う

### プログラム呼び出し階層図

```
CommentController (commentsController.ts)
    │
    └─ addCommentAtLine(range, event)
           │
           ├─ _commentingRangeDecorator.getMatchedCommentAction(range)
           │      └─ [結果: 空配列]
           │
           └─ [if range is defined]
                  └─ notificationService.error('comments.addCommand.error', ...)
```

### データフロー図

```
[入力]                    [処理]                         [出力]

コメント追加操作     コメント範囲チェック           エラー通知
                ───▶  getMatchedCommentAction    ───▶
                              │
                              ▼
                      [範囲マッチング]
                              │
                              ▼
                      [空配列 + range指定あり]
                              │
                              ▼
                      notificationService.error
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| commentsController.ts | `src/vs/workbench/contrib/comments/browser/commentsController.ts` | ソース | コメントコントローラー、通知発火 |
| commentService.ts | `src/vs/workbench/contrib/comments/browser/commentService.ts` | ソース | コメントサービス |
| notification.ts | `src/vs/platform/notification/common/notification.ts` | ソース | 通知サービスインターフェース |
| nls.ts | `src/vs/nls.ts` | ソース | ローカライズ機能 |
