# 通知設計書 28-comments.addFileCommentCommand.error

## 概要

本ドキュメントは、VSCodeのコメント機能において、ファイルレベルのコメントを追加しようとした際にファイルコメントが許可されていない場合に表示されるエラー通知「comments.addFileCommentCommand.error」の設計仕様を記載したものである。

### 本通知の処理概要

本通知は、ユーザーがファイル全体に対するコメント（特定の行に紐付かないコメント）を追加しようとした際に、そのファイルがファイルコメントをサポートしていない場合にユーザーに通知するエラーメッセージである。

**業務上の目的・背景**：VSCodeでは、拡張機能（GitHub Pull Requests等）を通じて、特定の行ではなくファイル全体に対するコメント（ファイルコメント）を追加できる機能がある。しかし、全てのファイルや全てのコンテキストでファイルコメントが許可されているわけではない。拡張機能の設定や、レビュー対象外のファイルなどでは、ファイルコメントが制限される場合がある。この通知により、ユーザーはファイルコメントが利用できないことを認識できる。

**通知の送信タイミング**：`addCommentAtLine`メソッド内で、`_commentingRangeDecorator.getMatchedCommentAction(undefined)`が空の配列を返した場合に発火する。

**通知の受信者**：VSCodeでファイルコメントを追加しようとしており、ファイルコメントが許可されていないユーザー。

**通知内容の概要**：「File comments are not allowed on this file.」というエラーメッセージが表示される。

**期待されるアクション**：ユーザーは行レベルのコメントを使用するか、ファイルコメントがサポートされている別のファイルでコメントを行う。

## 通知種別

アプリ内通知（VSCode Notification Service）

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 同期 |
| 優先度 | 高（エラー通知） |
| リトライ | 無し |

### 送信先決定ロジック

ファイルコメント追加操作を実行したユーザーのVSCodeインスタンスに直接表示される。

## 通知テンプレート

### アプリ内通知

| 項目 | 内容 |
|-----|------|
| 通知タイプ | Error（notificationService.error） |
| メッセージキー | 'comments.addFileCommentCommand.error' |
| ローカライズ | Yes（nls.localize使用） |

### 本文テンプレート

```
File comments are not allowed on this file.
```

### 添付ファイル

| ファイル名 | 形式 | 条件 | 説明 |
|----------|------|------|------|
| なし | - | - | 添付ファイルなし |

## テンプレート変数

| 変数名 | 説明 | データ取得元 | 必須 |
|--------|------|-------------|-----|
| なし | - | - | - |

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| ユーザー操作 | ファイルコメント追加コマンド実行 | ファイルコメントが許可されていない | ファイルコメント非対応 |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| ファイルコメント許可 | ファイルコメントがサポートされている場合は通知しない |
| rangeが指定されている | 行コメントの場合は別の通知を使用 |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A[ファイルコメント追加操作] --> B[addCommentAtLine呼び出しwith undefined range]
    B --> C[getMatchedCommentActionでチェック]
    C --> D{結果判定}
    D -->|ファイルコメント許可| E[コメント追加ダイアログ表示]
    D -->|空配列かつrangeがundefined| F[notificationService.errorでエラー通知]
    F --> G[エラーメッセージ表示]
```

## データベース参照・更新仕様

### 参照テーブル一覧

| テーブル名 | 用途 | 備考 |
|-----------|------|------|
| なし | - | データベースは使用しない |

### 更新テーブル一覧

| テーブル名 | 操作 | 概要 |
|-----------|------|------|
| なし | - | データベースは使用しない |

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| ファイルコメント非対応 | ファイルコメントがサポートされていない | 行コメントを使用 |
| 拡張機能の設定 | 拡張機能がファイルコメントを無効化 | 拡張機能の設定を確認 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 0（自動リトライなし） |
| リトライ間隔 | - |
| リトライ対象エラー | - |

## 配信設定

### レート制限

| 項目 | 内容 |
|-----|------|
| 1分あたり上限 | 制限なし |
| 1日あたり上限 | 制限なし |

### 配信時間帯

制限なし（操作時即座に通知）

## セキュリティ考慮事項

- ファイル名やファイルパスなどの情報をエラーメッセージに含めない
- 汎用的なエラーメッセージで情報漏洩を防止

## 備考

- この通知はCommentControllerクラス内のaddCommentAtLineメソッドで発火する
- 行1195-1197行目に実装されている
- rangeがundefinedの場合（ファイルコメント）のみこの通知が使用される

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

コメント範囲とファイルコメントに関連するデータ構造を理解することが重要。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | commentService.ts | `src/vs/workbench/contrib/comments/browser/commentService.ts` | CommentingRangesのfileCommentsプロパティ |

**読解のコツ**: fileCommentsフラグがtrueの場合のみファイルコメントが許可されることを確認する。

#### Step 2: エントリーポイントを理解する

通知が発火する起点を特定する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | commentsController.ts | `src/vs/workbench/contrib/comments/browser/commentsController.ts` | addCommentAtLineメソッド |

**主要処理フロー**:
1. **1188-1237行目**: addCommentAtLineメソッド全体
2. **1189行目**: getMatchedCommentAction(undefined)呼び出し（ファイルコメントの場合）
3. **1190-1198行目**: newCommentInfosが空の場合の処理
4. **1195-1197行目**: rangeがundefinedの場合のエラー通知

#### Step 3: ファイルコメントの判定ロジックを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | commentsController.ts | `src/vs/workbench/contrib/comments/browser/commentsController.ts` | CommentingRangeDecoratorのgetMatchedCommentActionメソッド |

**主要処理フロー**:
- rangeがundefinedの場合、fileCommentsフラグをチェック

### プログラム呼び出し階層図

```
CommentController (commentsController.ts)
    │
    └─ addCommentAtLine(undefined, event)  // ファイルコメント
           │
           ├─ _commentingRangeDecorator.getMatchedCommentAction(undefined)
           │      └─ [結果: 空配列（fileComments=false）]
           │
           └─ [if range is undefined]
                  └─ notificationService.error('comments.addFileCommentCommand.error', ...)
```

### データフロー図

```
[入力]                    [処理]                         [出力]

ファイルコメント      ファイルコメント許可チェック    エラー通知
追加操作         ───▶  getMatchedCommentAction      ───▶
                       (range = undefined)
                              │
                              ▼
                      [fileCommentsチェック]
                              │
                              ▼
                      [空配列 + rangeがundefined]
                              │
                              ▼
                      notificationService.error
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| commentsController.ts | `src/vs/workbench/contrib/comments/browser/commentsController.ts` | ソース | コメントコントローラー、通知発火 |
| commentService.ts | `src/vs/workbench/contrib/comments/browser/commentService.ts` | ソース | コメントサービス、CommentingRanges定義 |
| notification.ts | `src/vs/platform/notification/common/notification.ts` | ソース | 通知サービスインターフェース |
| nls.ts | `src/vs/nls.ts` | ソース | ローカライズ機能 |
