# 通知設計書 29-failedToOpenUri

## 概要

本ドキュメントは、VSCodeの認証機能において、認証URIをブラウザで開こうとした際に失敗した場合に表示されるエラー通知「failedToOpenUri」の設計仕様を記載したものである。

### 本通知の処理概要

本通知は、ユーザーがデバイスコード認証フローを使用している際に、認証サーバーのURIをブラウザで開こうとして失敗した場合にユーザーに通知するエラーメッセージである。

**業務上の目的・背景**：VSCodeでは、OAuth認証を行う際にデバイスコードフローを使用することがある。このフローでは、ユーザーはブラウザで認証サーバーのURLにアクセスし、表示されたデバイスコードを入力して認証を完了する。しかし、ブラウザの起動に失敗したり、URLの開放に問題がある場合など、URIを開けないケースがある。この通知により、ユーザーはURIの自動オープンが失敗したことを認識し、手動でURLにアクセスするなどの代替手段を取ることができる。

**通知の送信タイミング**：`$showDeviceCodeModal`メソッド内で、`openerService.open`が失敗した場合に発火する。

**通知の受信者**：VSCodeで認証を行おうとしており、認証URIのブラウザでの開放に失敗したユーザー。

**通知内容の概要**：「Failed to open {0}」というエラーメッセージが表示され、{0}には開こうとしたURIが挿入される。

**期待されるアクション**：ユーザーは表示されたURIを手動でブラウザにコピー＆ペーストしてアクセスする。

## 通知種別

アプリ内通知（VSCode Notification Service）

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 同期 |
| 優先度 | 高（エラー通知） |
| リトライ | 無し |

### 送信先決定ロジック

認証操作を実行したユーザーのVSCodeインスタンスに直接表示される。

## 通知テンプレート

### アプリ内通知

| 項目 | 内容 |
|-----|------|
| 通知タイプ | Error（notificationService.error） |
| メッセージキー | 'failedToOpenUri' |
| ローカライズ | Yes（nls.localize使用） |

### 本文テンプレート

```
Failed to open {0}
```

### 添付ファイル

| ファイル名 | 形式 | 条件 | 説明 |
|----------|------|------|------|
| なし | - | - | 添付ファイルなし |

## テンプレート変数

| 変数名 | 説明 | データ取得元 | 必須 |
|--------|------|-------------|-----|
| {0} | 開こうとしたURI | verificationUri パラメータ | Yes |

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| 認証処理 | デバイスコード認証時のURI開放 | openerService.openが失敗（例外発生） | ブラウザでのURI開放失敗 |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| 正常オープン時 | URIが正常に開かれた場合は通知しない |
| ユーザーキャンセル | ダイアログでキャンセルした場合は通知しない |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A[デバイスコード認証開始] --> B[デバイスコードモーダル表示]
    B --> C[ユーザーがCopy & Continue選択]
    C --> D[クリップボードにコードコピー]
    D --> E[openerService.openでURI開放試行]
    E --> F{処理結果}
    F -->|成功| G[ブラウザでURI表示]
    F -->|例外発生| H[notificationService.errorでエラー通知]
    H --> I[エラーメッセージ表示]
```

## データベース参照・更新仕様

### 参照テーブル一覧

| テーブル名 | 用途 | 備考 |
|-----------|------|------|
| なし | - | データベースは使用しない |

### 更新テーブル一覧

| テーブル名 | 操作 | 概要 |
|-----------|------|------|
| なし | - | データベースは使用しない |

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| ブラウザ起動失敗 | デフォルトブラウザが設定されていない | ブラウザ設定の確認 |
| URLスキーム未対応 | 特殊なURLスキームがサポートされていない | 手動でURLにアクセス |
| セキュリティブロック | セキュリティソフトによるブロック | セキュリティ設定の確認 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 0（自動リトライなし） |
| リトライ間隔 | - |
| リトライ対象エラー | - |

## 配信設定

### レート制限

| 項目 | 内容 |
|-----|------|
| 1分あたり上限 | 制限なし |
| 1日あたり上限 | 制限なし |

### 配信時間帯

制限なし（認証操作時即座に通知）

## セキュリティ考慮事項

- URIはメッセージに含まれるが、認証情報（トークン等）は含まない
- 認証コード自体はクリップボードにコピーされ、通知には含まれない

## 備考

- この通知はMainThreadAuthenticationクラス内の$showDeviceCodeModalメソッドで発火する
- 行587-589行目に実装されている
- デバイスコード認証フローの一部として使用される

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

デバイスコード認証に関連するデータ構造を理解することが重要。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | mainThreadAuthentication.ts | `src/vs/workbench/api/browser/mainThreadAuthentication.ts` | デバイスコードモーダルのパラメータ |

**読解のコツ**: userCodeとverificationUriの関係を確認する。

#### Step 2: エントリーポイントを理解する

通知が発火する起点を特定する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | mainThreadAuthentication.ts | `src/vs/workbench/api/browser/mainThreadAuthentication.ts` | $showDeviceCodeModalメソッド |

**主要処理フロー**:
1. **568-592行目**: $showDeviceCodeModalメソッド全体
2. **582-590行目**: Copy & Continue選択後の処理
3. **584-585行目**: クリップボードコピーとopenerService.open呼び出し
4. **586-589行目**: catchブロックでのエラー通知

#### Step 3: Openerサービスを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | opener.ts | `src/vs/platform/opener/common/opener.ts` | IOpenerServiceインターフェース |

**主要処理フロー**:
- openメソッドがURIをブラウザで開く

### プログラム呼び出し階層図

```
MainThreadAuthentication (mainThreadAuthentication.ts)
    │
    └─ $showDeviceCodeModal(userCode, verificationUri)
           │
           ├─ dialogService.prompt(...)
           │      └─ [ユーザーがCopy & Continue選択]
           │
           ├─ clipboardService.writeText(userCode)
           │
           ├─ openerService.open(URI.parse(verificationUri))
           │
           └─ [catch]
                  └─ notificationService.error('failedToOpenUri', verificationUri)
```

### データフロー図

```
[入力]                    [処理]                         [出力]

デバイスコード       デバイスコードモーダル          エラー通知
認証開始        ───▶  表示・処理                ───▶
                              │
                              ▼
                      [Copy & Continue]
                              │
                              ▼
                      clipboardService.writeText
                              │
                              ▼
                      openerService.open
                              │
                              ▼
                         [例外発生]
                              │
                              ▼
                      notificationService.error
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| mainThreadAuthentication.ts | `src/vs/workbench/api/browser/mainThreadAuthentication.ts` | ソース | 認証メインスレッド、通知発火 |
| opener.ts | `src/vs/platform/opener/common/opener.ts` | ソース | Openerサービスインターフェース |
| clipboardService.ts | `src/vs/platform/clipboard/common/clipboardService.ts` | ソース | クリップボードサービス |
| notification.ts | `src/vs/platform/notification/common/notification.ts` | ソース | 通知サービスインターフェース |
