# 通知設計書 3-severityPrefix.info

## 概要

本ドキュメントは、VS Codeにおける情報通知の深刻度プレフィックス「Info: {0}」の設計について記述する。この通知は、WCAG 4.1.3（ステータスメッセージ）準拠のアクセシビリティ要件を満たすために実装されている。

### 本通知の処理概要

この通知は、情報レベルの通知メッセージに対して深刻度を示すプレフィックスを付与する機能である。スクリーンリーダーなどの支援技術を使用するユーザーに対して、通知の種類を明確に伝達することを目的としている。

**業務上の目的・背景**：Web Content Accessibility Guidelines (WCAG) 4.1.3では、ステータスメッセージはプログラム的に決定可能であり、フォーカスを移動させることなく支援技術によってユーザーに提示できなければならないと定めている。この通知プレフィックスは、情報メッセージの深刻度をスクリーンリーダーが正しく読み上げられるようにするために必要である。

**通知の送信タイミング**：情報深刻度（Severity.Info）または深刻度が指定されていない通知メッセージが生成される際に、`withSeverityPrefix`関数が呼び出されることでプレフィックスが付与される。

**通知の受信者**：VS Codeを使用するすべてのユーザーが対象となる。特にスクリーンリーダーを使用するユーザーにとって重要な機能である。

**通知内容の概要**：「Info: {元のメッセージ}」という形式でメッセージが整形される。例えば、元のメッセージが「Operation completed」の場合、「Info: Operation completed」となる。

**期待されるアクション**：ユーザーは情報の内容を認識する。情報通知は一般的に対応を必要としないが、現在の状態や完了した操作について知らせる役割を果たす。

## 通知種別

アプリ内通知（VS Code内部のNotificationService経由）

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 同期 |
| 優先度 | 低（情報通知） |
| リトライ | なし |

### 送信先決定ロジック

すべてのVS Codeユーザーに対して表示される。深刻度がInfoまたはその他の深刻度の通知メッセージが生成される際に自動的にプレフィックスが付与される。

## 通知テンプレート

### アプリ内通知の場合

| 項目 | 内容 |
|-----|------|
| 形式 | テキスト |
| プレフィックス | "Info: " |

### 本文テンプレート

```
Info: {0}
```

- `{0}`: 元の通知メッセージ（label引数）

### 添付ファイル

| ファイル名 | 形式 | 条件 | 説明 |
|----------|------|------|------|
| なし | - | - | 添付ファイルなし |

## テンプレート変数

| 変数名 | 説明 | データ取得元 | 必須 |
|--------|------|-------------|-----|
| {0} | 元の通知メッセージ | 呼び出し元からの引数(label) | Yes |

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| 関数呼び出し | withSeverityPrefix関数の呼び出し | severity !== Error && severity !== Warning | 情報深刻度のメッセージに対してプレフィックスを付与（デフォルト動作） |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| なし | 条件が満たされれば常にプレフィックスが付与される |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A[withSeverityPrefix関数呼び出し] --> B{severity の判定}
    B -->|Severity.Error| C[Error: プレフィックス付与]
    B -->|Severity.Warning| D[Warning: プレフィックス付与]
    B -->|その他| E[Info: プレフィックス付与]
    C --> F[整形されたメッセージを返却]
    D --> F
    E --> F
```

## データベース参照・更新仕様

### 参照テーブル一覧

| テーブル名 | 用途 | 備考 |
|-----------|------|------|
| なし | - | データベースアクセスなし |

### 更新テーブル一覧

| テーブル名 | 操作 | 概要 |
|-----------|------|------|
| なし | - | データベースアクセスなし |

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| なし | - | シンプルな文字列処理のためエラーは発生しない |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | なし |
| リトライ間隔 | - |
| リトライ対象エラー | - |

## 配信設定

### レート制限

| 項目 | 内容 |
|-----|------|
| 1分あたり上限 | なし |
| 1日あたり上限 | なし |

### 配信時間帯

制限なし

## セキュリティ考慮事項

- 個人情報は含まれない
- ローカライズ機能（nls.localize）を使用して多言語対応している

## 備考

- この機能はWCAG 4.1.3（ステータスメッセージ）に準拠するために実装されている
- `localize`関数を使用することで、異なる言語環境でも適切なプレフィックスが付与される
- Info は最も低い深刻度を示し、デフォルトの分岐として実装されている

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

通知の深刻度（Severity）と通知サービスのインターフェースを理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | notification.ts | `src/vs/platform/notification/common/notification.ts` | Severity列挙型と通知関連のインターフェースを確認 |

**読解のコツ**: TypeScriptの列挙型（enum）と`re-export`パターン（`export import`）を理解しておくと良い。

#### Step 2: エントリーポイントを理解する

`withSeverityPrefix`関数の実装を確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | notification.ts | `src/vs/platform/notification/common/notification.ts` | withSeverityPrefix関数の実装（477-491行目） |

**主要処理フロー**:
1. **477行目**: `withSeverityPrefix`関数の定義開始
2. **479-480行目**: WCAG 4.1.3準拠のコメント
3. **482-484行目**: Severity.Errorの場合、「Error: {0}」形式で返却
4. **486-488行目**: Severity.Warningの場合、「Warning: {0}」形式で返却
5. **490行目**: その他の場合（デフォルト）、「Info: {0}」形式で返却

### プログラム呼び出し階層図

```
withSeverityPrefix(label, severity)
    │
    ├─ severity === Severity.Error ?
    │      └─ localize('severityPrefix.error', "Error: {0}", label)
    │
    ├─ severity === Severity.Warning ?
    │      └─ localize('severityPrefix.warning', "Warning: {0}", label)
    │
    └─ default (Info含むその他すべて)
           └─ localize('severityPrefix.info', "Info: {0}", label)
```

### データフロー図

```
[入力]                  [処理]                        [出力]

label (string)     ───▶ withSeverityPrefix() ───▶ "Info: {label}"
severity (Severity)     │
                        ├─ localize()
                        └─ (文字列連結)
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| notification.ts | `src/vs/platform/notification/common/notification.ts` | ソース | 通知関連の型定義とwithSeverityPrefix関数の実装 |
| nls.ts | `src/vs/nls.ts` | ソース | ローカライゼーション機能の提供 |
| severity.ts | `src/vs/base/common/severity.ts` | ソース | Severity列挙型の定義（Error, Warning, Info等） |
