# 通知設計書 30-dcrFailedToCopy

## 概要

本ドキュメントは、VSCodeの認証機能において、Dynamic Client Registration（DCR）非対応のサーバーに対してリダイレクトURIをクリップボードにコピーしようとした際に失敗した場合に表示されるエラー通知「dcrFailedToCopy」の設計仕様を記載したものである。

### 本通知の処理概要

本通知は、認証サーバーがDynamic Client Registration（DCR）をサポートしていない場合に表示されるダイアログで、ユーザーがリダイレクトURIをクリップボードにコピーする操作を行った際に、クリップボードへのコピーが失敗した場合にユーザーに通知するエラーメッセージである。

**業務上の目的・背景**：OAuthでは、クライアントアプリケーションを認証サーバーに登録する必要がある。Dynamic Client Registration（DCR）はこの登録を自動化するプロトコルだが、全ての認証サーバーがDCRをサポートしているわけではない。DCR非対応のサーバーの場合、ユーザーは手動でOAuthアプリケーションを登録する必要があり、その際にリダイレクトURIの設定が必要となる。VSCodeはこのリダイレクトURIをクリップボードにコピーする機能を提供するが、クリップボードへのアクセスが制限される環境ではコピーに失敗することがある。

**通知の送信タイミング**：`$promptForClientRegistration`メソッド内で、「Copy URIs & Proceed」ボタンをクリックした際に`clipboardService.writeText`が失敗した場合に発火する。

**通知の受信者**：VSCodeで認証を行おうとしており、DCR非対応のサーバーでクライアント登録を行う必要があるユーザー。

**通知内容の概要**：「Failed to copy redirect URIs to clipboard.」というエラーメッセージが表示される。

**期待されるアクション**：ユーザーは表示されているリダイレクトURIを手動でコピーし、OAuthアプリケーション登録時に使用する。

## 通知種別

アプリ内通知（VSCode Notification Service）

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 同期 |
| 優先度 | 高（エラー通知） |
| リトライ | 無し |

### 送信先決定ロジック

クライアント登録プロンプトでコピー操作を実行したユーザーのVSCodeインスタンスに直接表示される。

## 通知テンプレート

### アプリ内通知

| 項目 | 内容 |
|-----|------|
| 通知タイプ | Error（notificationService.error） |
| メッセージキー | 'dcrFailedToCopy' |
| ローカライズ | Yes（nls.localize使用） |

### 本文テンプレート

```
Failed to copy redirect URIs to clipboard.
```

### 添付ファイル

| ファイル名 | 形式 | 条件 | 説明 |
|----------|------|------|------|
| なし | - | - | 添付ファイルなし |

## テンプレート変数

| 変数名 | 説明 | データ取得元 | 必須 |
|--------|------|-------------|-----|
| なし | - | - | - |

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| ユーザー操作 | Copy URIs & Proceedボタンクリック | clipboardService.writeTextが失敗（例外発生） | クリップボードコピー失敗 |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| 正常コピー時 | クリップボードへのコピーが成功した場合は通知しない |
| キャンセル時 | ダイアログでキャンセルした場合は通知しない |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A[認証サーバー接続試行] --> B{DCRサポート確認}
    B -->|サポートあり| C[自動クライアント登録]
    B -->|サポートなし| D[$promptForClientRegistrationダイアログ表示]
    D --> E[ユーザーがCopy URIs & Proceed選択]
    E --> F[clipboardService.writeText試行]
    F --> G{コピー結果}
    G -->|成功| H[クライアントID入力プロンプト表示]
    G -->|失敗| I[notificationService.errorでエラー通知]
    I --> J[エラーメッセージ表示]
    J --> H
```

## データベース参照・更新仕様

### 参照テーブル一覧

| テーブル名 | 用途 | 備考 |
|-----------|------|------|
| なし | - | データベースは使用しない |

### 更新テーブル一覧

| テーブル名 | 操作 | 概要 |
|-----------|------|------|
| なし | - | データベースは使用しない |

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| クリップボードアクセス拒否 | ブラウザのセキュリティ制限 | 手動でURIをコピー |
| 環境制限 | 特定の環境でクリップボードが利用不可 | 手動でURIをコピー |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 0（自動リトライなし） |
| リトライ間隔 | - |
| リトライ対象エラー | - |

## 配信設定

### レート制限

| 項目 | 内容 |
|-----|------|
| 1分あたり上限 | 制限なし |
| 1日あたり上限 | 制限なし |

### 配信時間帯

制限なし（操作時即座に通知）

## セキュリティ考慮事項

- リダイレクトURIは公開情報であり、セキュリティリスクは低い
- クリップボードの内容（http://127.0.0.1:33418, https://vscode.dev/redirect）は機密情報ではない

## 備考

- この通知はMainThreadAuthenticationクラス内の$promptForClientRegistrationメソッドで発火する
- 行605-612行目に実装されている
- コピー失敗後も処理は続行され、クライアントID入力プロンプトが表示される

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

Dynamic Client Registrationに関連するデータ構造を理解することが重要。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | oauth.ts | `src/vs/base/common/oauth.ts` | OAuthクライアント登録の概念 |

**読解のコツ**: DCRがなぜ必要か、代替手段として手動登録が必要になる理由を理解する。

#### Step 2: エントリーポイントを理解する

通知が発火する起点を特定する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | mainThreadAuthentication.ts | `src/vs/workbench/api/browser/mainThreadAuthentication.ts` | $promptForClientRegistrationメソッド |

**主要処理フロー**:
1. **594-656行目**: $promptForClientRegistrationメソッド全体
2. **597-619行目**: ダイアログ表示とボタン処理
3. **605-612行目**: Copy URIs & Proceedボタンのrun関数
4. **607-610行目**: try-catchブロックでのエラー処理

#### Step 3: クリップボードサービスを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | clipboardService.ts | `src/vs/platform/clipboard/common/clipboardService.ts` | IClipboardServiceインターフェース |

**主要処理フロー**:
- writeTextメソッドがクリップボードに書き込む

### プログラム呼び出し階層図

```
MainThreadAuthentication (mainThreadAuthentication.ts)
    │
    └─ $promptForClientRegistration(authorizationServerUrl)
           │
           ├─ dialogService.prompt(...)
           │      │
           │      └─ Copy URIs & Proceedボタン
           │             │
           │             └─ run()
           │                    │
           │                    ├─ clipboardService.writeText(redirectUrls)
           │                    │
           │                    └─ [catch]
           │                           └─ notificationService.error('dcrFailedToCopy')
           │
           └─ quickInputService.input(...)  // クライアントID入力
```

### データフロー図

```
[入力]                    [処理]                         [出力]

DCR非対応サーバー    クライアント登録プロンプト    エラー通知
での認証試行    ───▶  表示・処理                ───▶
                              │
                              ▼
                      [Copy URIs & Proceed]
                              │
                              ▼
                      clipboardService.writeText
                      (redirectUrls)
                              │
                              ▼
                         [例外発生]
                              │
                              ▼
                      notificationService.error
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| mainThreadAuthentication.ts | `src/vs/workbench/api/browser/mainThreadAuthentication.ts` | ソース | 認証メインスレッド、通知発火 |
| clipboardService.ts | `src/vs/platform/clipboard/common/clipboardService.ts` | ソース | クリップボードサービス |
| oauth.ts | `src/vs/base/common/oauth.ts` | ソース | OAuth関連の定義 |
| notification.ts | `src/vs/platform/notification/common/notification.ts` | ソース | 通知サービスインターフェース |
