# 通知設計書 32-alreadyDebugging

## 概要

本ドキュメントは、VS Code エディタにおけるTextMate文法デバッグ機能の重複起動時に表示されるエラー通知の設計を記載する。TextMateTokenizationFeatureサービスは、文法解析のデバッグログ記録機能を提供し、既にログ記録中に再度デバッグモードを開始しようとした場合にエラーを通知する。

### 本通知の処理概要

alreadyDebugging通知は、TextMate文法のデバッグログ記録機能が既に有効な状態で、ユーザーが再度デバッグモードを開始しようとした際にエラーメッセージを表示する機能である。

**業務上の目的・背景**：VSCodeはTextMate文法によるシンタックスハイライトを実装しており、開発者や拡張機能作成者がトークナイゼーションの動作を調査するためのデバッグ機能を提供している。このデバッグモードはOnigurumaライブラリのトレースログを出力するもので、システムリソースを消費する。重複起動を防止することで、予期しないログの混在やリソースの無駄な消費を防ぐ。

**通知の送信タイミング**：TextMateTokenizationFeature.startDebugMode()メソッドが呼び出された際に、既に_debugModeフラグがtrueの場合にエラー通知が表示される。通常、Developer: Start TextMate Syntax Grammarログ記録コマンドの実行時にトリガーされる。

**通知の受信者**：デバッグモード開始コマンドを実行したユーザー（開発者）本人がNotificationServiceを通じてエラーを受け取る。

**通知内容の概要**：「Already Logging.」というシンプルなメッセージが表示され、既にログ記録が進行中であることをユーザーに伝える。

**期待されるアクション**：ユーザーは現在進行中のデバッグログ記録を完了させるか、既存のログ記録を停止（Stopボタン押下）してから新たにデバッグモードを開始することが期待される。

## 通知種別

アプリ内通知（NotificationService.error）

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 同期 |
| 優先度 | 高（Error） |
| リトライ | なし |

### 送信先決定ロジック

デバッグモード開始コマンドを実行したユーザーに対して、VSCodeのNotificationServiceを通じてウィンドウ内にエラートーストが表示される。

## 通知テンプレート

### アプリ内通知の場合

| 項目 | 内容 |
|-----|------|
| 重要度 | Error（赤色アイコン） |
| 表示位置 | 画面右下の通知エリア |
| 自動消去 | なし（ユーザー操作で消去） |

### 本文テンプレート

```
Already Logging.
```

### 添付ファイル

なし

## テンプレート変数

| 変数名 | 説明 | データ取得元 | 必須 |
|--------|------|-------------|-----|
| なし | 固定メッセージのため変数なし | - | - |

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| コマンド実行 | startDebugMode()呼び出し | _debugMode === true | デバッグモードが既に有効な状態で再度開始しようとした場合 |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| _debugMode === false | デバッグモードが無効な場合は通常通りデバッグモードを開始 |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A[startDebugMode呼び出し] --> B{_debugMode === true?}
    B -->|Yes| C[NotificationService.error]
    C --> D[処理終了 return]
    B -->|No| E[_debugMode = true設定]
    E --> F[ProgressService.withProgress]
    F --> G[Onigurumaデバッグ有効化]
    G --> H[ログ記録開始]
    H --> I{Stopボタン押下?}
    I -->|Yes| J[_debugMode = false]
    J --> K[Onigurumaデバッグ無効化]
    K --> L[onStop callback呼び出し]
```

## データベース参照・更新仕様

### 参照テーブル一覧

VSCodeはデスクトップアプリケーションであり、通常のDBテーブルは使用しない。

| データ構造 | 用途 | 備考 |
|-----------|------|------|
| _debugMode | デバッグモード状態フラグ | boolean型 |
| _debugModePrintFunc | ログ出力関数 | (str: string) => void |

### インメモリデータ構造詳細

#### TextMateTokenizationFeature

| プロパティ | 型 | 説明 |
|-----------|-----|------|
| _debugMode | boolean | デバッグモードの有効/無効状態 |
| _debugModePrintFunc | function | デバッグログ出力先関数 |
| _vscodeOniguruma | Promise | Onigurumaライブラリインスタンス |

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| 重複起動 | _debugMode === true | エラー通知を表示し、処理を中断 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | なし |
| リトライ間隔 | N/A |
| リトライ対象エラー | なし（ユーザーの再操作を待つ） |

## 配信設定

### レート制限

| 項目 | 内容 |
|-----|------|
| 制限 | なし（ユーザー操作起点のため） |

### 配信時間帯

ユーザー操作に応じて即座に表示（時間帯制限なし）

## セキュリティ考慮事項

- デバッグログには文法解析の詳細情報が含まれる可能性があるが、本エラー通知自体には機密情報は含まれない
- デバッグモードはDeveloperコマンドからのみアクセス可能で、一般ユーザーが誤って使用する可能性は低い

## 備考

- デバッグモードは主に拡張機能開発者やVSCodeコントリビューター向けの機能
- ログ出力はvscode-onigurumaのsetDefaultDebugCall APIを使用
- Stopボタン押下でonStopコールバックが呼ばれ、呼び出し元に完了を通知

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

まず、デバッグモードの状態管理を理解することが重要。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | textMateTokenizationFeatureImpl.ts | `src/vs/workbench/services/textMate/browser/textMateTokenizationFeatureImpl.ts` | _debugMode、_debugModePrintFuncプロパティの定義（51-52行目） |

**読解のコツ**: TextMateTokenizationFeatureクラスのコンストラクタで初期化されるプロパティを確認する。

#### Step 2: エントリーポイントを理解する

デバッグモード開始の起点となるメソッドを特定。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | textMateTokenizationFeatureImpl.ts | `src/vs/workbench/services/textMate/browser/textMateTokenizationFeatureImpl.ts` | startDebugMode()メソッド（213-251行目） |

**主要処理フロー**:
1. **213行目**: startDebugMode(printFn, onStop)メソッドのシグネチャ
2. **214-217行目**: 既にデバッグ中の場合のエラー通知と早期リターン
3. **219-220行目**: デバッグモードの有効化
4. **222-250行目**: ProgressServiceによる進捗表示とOnigurumaの設定

#### Step 3: エラー通知を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | textMateTokenizationFeatureImpl.ts | `src/vs/workbench/services/textMate/browser/textMateTokenizationFeatureImpl.ts` | NotificationService.error呼び出し（215行目） |

**主要処理フロー**:
- **215行目**: `this._notificationService.error(nls.localize('alreadyDebugging', "Already Logging."));`

#### Step 4: デバッグモード終了処理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | textMateTokenizationFeatureImpl.ts | `src/vs/workbench/services/textMate/browser/textMateTokenizationFeatureImpl.ts` | Stopボタン押下時のコールバック（241-248行目） |

**主要処理フロー**:
- **243行目**: _debugModePrintFuncの初期化（空関数に戻す）
- **244行目**: _debugMode = false でデバッグモード無効化
- **245行目**: vscodeOniguruma.setDefaultDebugCall(false)でログ出力無効化
- **246行目**: onStop()コールバック呼び出し

### プログラム呼び出し階層図

```
Developer Command: Start TextMate Syntax Grammar Logging
    │
    └─ TextMateTokenizationFeature.startDebugMode(printFn, onStop)
           │
           ├─ [_debugMode === true]
           │      └─ NotificationService.error("Already Logging.")  ← エラー通知
           │
           └─ [_debugMode === false]
                  │
                  ├─ _debugMode = true
                  ├─ _debugModePrintFunc = printFn
                  │
                  └─ ProgressService.withProgress()
                         │
                         ├─ _getVSCodeOniguruma()
                         │      └─ vscodeOniguruma.setDefaultDebugCall(true)
                         │
                         └─ [Stop button] choice callback
                                │
                                ├─ _debugMode = false
                                ├─ vscodeOniguruma.setDefaultDebugCall(false)
                                └─ onStop()
```

### データフロー図

```
[入力]                    [処理]                         [出力]

Developer Command ──▶ startDebugMode()
      │                    │
      │                    ▼
      │            _debugMode チェック
      │                    │
      │          ┌─────────┴─────────┐
      │          │                   │
      │          ▼                   ▼
      │    [true]               [false]
      │          │                   │
      │          ▼                   ▼
      │   NotificationService   ProgressService
      │     .error()             .withProgress()
      │          │                   │
      │          ▼                   ▼
      └──▶ "Already Logging."   ログ記録開始
                                     │
                                     ▼
                              Oniguruma Debug Output
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| textMateTokenizationFeatureImpl.ts | `src/vs/workbench/services/textMate/browser/textMateTokenizationFeatureImpl.ts` | サービス実装 | TextMate文法トークナイゼーションとデバッグ機能の実装 |
| textMateTokenizationFeature.ts | `src/vs/workbench/services/textMate/browser/textMateTokenizationFeature.ts` | インターフェース | ITextMateTokenizationServiceの定義 |
| notification.ts | `src/vs/platform/notification/common/notification.ts` | インターフェース | INotificationServiceの定義 |
| progress.ts | `src/vs/platform/progress/common/progress.ts` | インターフェース | IProgressServiceの定義 |
| nls.ts | `src/vs/nls.ts` | ユーティリティ | ローカライズ関数の提供 |
