# 通知設計書 33-GPU描画に関する警告

## 概要

本ドキュメントは、VS Code エディタにおけるWebGPU/GPU描画機能に関する警告通知の設計を記載する。GPULifecycleモジュールは、WebGPUが利用できない環境やGPUアダプターの取得に失敗した場合にフォールバック処理を行い、呼び出し元に警告メッセージを提供する。

### 本通知の処理概要

GPU描画に関する警告通知は、VSCodeのGPU accelerated rendering機能がWebGPUを使用しようとした際に、ブラウザがWebGPUをサポートしていない場合や、GPUアダプターが取得できない場合にエラーメッセージを通知する機能である。

**業務上の目的・背景**：VSCodeはエディタのパフォーマンス向上のためにWebGPUを使用したGPUレンダリングをサポートしている。しかし、すべての環境でWebGPUが利用できるわけではなく、古いブラウザや特定のGPUドライバでは非対応となる場合がある。この警告通知により、ユーザーにGPU描画が利用できない理由を伝え、代替手段（CPUレンダリング）へのフォールバックを適切に行う。

**通知の送信タイミング**：GPULifecycle.requestDevice()メソッドが呼び出された際に、navigator.gpuが存在しない場合、またはrequestAdapter()でnullが返された場合にコールバックを通じて警告が通知される。

**通知の受信者**：GPU描画機能を初期化しようとしたコンポーネント（ViewLinesGpuなど）がフォールバックコールバックを通じてエラーメッセージを受け取る。最終的にはユーザーに通知される場合がある。

**通知内容の概要**：WebGPUがサポートされていない場合は「This browser does not support WebGPU」、GPUアダプターが取得できない場合は「This browser supports WebGPU but it appears to be disabled」というメッセージが生成される。

**期待されるアクション**：システムはCPUベースのレンダリングにフォールバックし、ユーザーは通常通りエディタを使用できる。パフォーマンスが重要な場合は、ブラウザのGPU設定を確認するか、WebGPU対応ブラウザに切り替えることを検討する。

## 通知種別

コールバック関数を通じた内部通知（フォールバック処理）

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 同期（コールバック） |
| 優先度 | 中 |
| リトライ | なし（即座にフォールバック） |

### 送信先決定ロジック

GPULifecycle.requestDevice()の呼び出し元コンポーネントに対して、fallbackコールバック引数を通じてエラーメッセージが渡される。

## 通知テンプレート

### エラーメッセージパターン

| 条件 | メッセージ |
|------|---------|
| WebGPU非対応 | "This browser does not support WebGPU" |
| GPUアダプター取得失敗 | "This browser supports WebGPU but it appears to be disabled" |

### 本文テンプレート

```
{エラーメッセージ}
```

### 添付ファイル

なし

## テンプレート変数

| 変数名 | 説明 | データ取得元 | 必須 |
|--------|------|-------------|-----|
| message | エラーメッセージ | Error.message | Yes |

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| 初期化 | requestDevice()呼び出し | navigator.gpu === undefined | WebGPU APIがブラウザでサポートされていない |
| 初期化 | requestDevice()呼び出し | adapter === null | GPUアダプターの取得に失敗 |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| WebGPU有効 | navigator.gpuが存在しアダプターが正常に取得できた場合 |
| fallback未指定 | フォールバックコールバックが渡されていない場合（例外がスローされる） |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A[requestDevice呼び出し] --> B{navigator.gpu存在?}
    B -->|No| C[Error: WebGPU非対応]
    C --> D{fallback指定あり?}
    D -->|Yes| E[fallback callback実行]
    D -->|No| F[throw Error]
    B -->|Yes| G[requestAdapter呼び出し]
    G --> H{adapter取得成功?}
    H -->|No| I[Error: GPUアダプター取得失敗]
    I --> D
    H -->|Yes| J[requestDevice呼び出し]
    J --> K[GPUDevice取得成功]
    K --> L[IReference<GPUDevice>返却]
    E --> M[フォールバック処理]
    F --> N[例外処理]
```

## データベース参照・更新仕様

### 参照テーブル一覧

VSCodeはデスクトップアプリケーションであり、通常のDBテーブルは使用しない。

| データ構造 | 用途 | 備考 |
|-----------|------|------|
| navigator.gpu | WebGPU API | ブラウザ提供のグローバルオブジェクト |
| GPUAdapter | GPUアダプター | requestAdapter()で取得 |
| GPUDevice | GPUデバイス | requestDevice()で取得 |

### API呼び出し詳細

#### WebGPU API

| メソッド | 説明 | 戻り値 |
|---------|------|-------|
| navigator.gpu.requestAdapter() | GPUアダプターの取得 | Promise<GPUAdapter | null> |
| adapter.requestDevice() | GPUデバイスの取得 | Promise<GPUDevice> |

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| WebGPU非対応 | navigator.gpuがundefined | フォールバック処理またはthrow |
| アダプター取得失敗 | requestAdapter()がnullを返す | フォールバック処理またはthrow |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | なし |
| リトライ間隔 | N/A |
| リトライ対象エラー | なし（環境依存のため再試行しても結果は変わらない） |

## 配信設定

### レート制限

| 項目 | 内容 |
|-----|------|
| 制限 | なし（初期化時のみ発生） |

### 配信時間帯

アプリケーション起動時の初期化処理で発生（時間帯制限なし）

## セキュリティ考慮事項

- GPU情報の取得はブラウザのセキュリティポリシーに従う
- WebGPU APIの利用は安全なコンテキスト（HTTPS）でのみ利用可能
- GPUのフィンガープリントに関するプライバシー考慮はブラウザ側で対応

## 備考

- GPULifecycleはIReference<GPUDevice>を返し、dispose時にGPUDeviceを破棄する
- フォールバックが発生した場合、呼び出し元は代替のCPUレンダリングを使用する
- WebGPUは比較的新しいAPIであり、すべてのブラウザでサポートされているわけではない

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

まず、GPUリソースの管理構造を理解することが重要。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | gpuDisposable.ts | `src/vs/editor/browser/gpu/gpuDisposable.ts` | GPULifecycle名前空間とIReference型の使用 |

**読解のコツ**: IReference<T>はdispose可能な参照型で、objectプロパティで実際の値にアクセスする。

#### Step 2: エントリーポイントを理解する

GPU描画初期化の起点となる関数を特定。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | gpuDisposable.ts | `src/vs/editor/browser/gpu/gpuDisposable.ts` | GPULifecycle.requestDevice()関数（10-26行目） |

**主要処理フロー**:
1. **10行目**: requestDevice(fallback?)関数のシグネチャ
2. **12-14行目**: navigator.gpuの存在チェックとエラー生成
3. **15-18行目**: requestAdapter()呼び出しとnullチェック
4. **19行目**: requestDevice()呼び出し
5. **20-24行目**: 例外発生時のフォールバック処理

#### Step 3: エラーメッセージの生成を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | gpuDisposable.ts | `src/vs/editor/browser/gpu/gpuDisposable.ts` | Errorオブジェクトの生成（13行目、17行目） |

**主要処理フロー**:
- **13行目**: `throw new Error('This browser does not support WebGPU');`
- **17行目**: `throw new Error('This browser supports WebGPU but it appears to be disabled');`

#### Step 4: フォールバック処理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | gpuDisposable.ts | `src/vs/editor/browser/gpu/gpuDisposable.ts` | catch節でのフォールバック呼び出し（20-24行目） |

**主要処理フロー**:
- **21-23行目**: fallbackコールバックが存在する場合、e.messageを引数として呼び出し
- **24行目**: フォールバック後もエラーを再スロー

### プログラム呼び出し階層図

```
ViewLinesGpu（または他のGPUコンポーネント）
    │
    └─ GPULifecycle.requestDevice(fallback)
           │
           ├─ [navigator.gpu存在チェック]
           │      └─ [失敗] Error("This browser does not support WebGPU")
           │
           ├─ navigator.gpu.requestAdapter()
           │      └─ [null] Error("This browser supports WebGPU but it appears to be disabled")
           │
           ├─ adapter.requestDevice()
           │      └─ wrapDestroyableInDisposable(device)
           │
           └─ [例外発生時]
                  ├─ fallback(e.message)  ← 警告メッセージ配信
                  └─ throw e
```

### データフロー図

```
[入力]                    [処理]                         [出力]

GPUコンポーネント初期化 ──▶ GPULifecycle.requestDevice()
      │                         │
      │                         ▼
      │                  WebGPU API呼び出し
      │                         │
      │          ┌──────────────┴──────────────┐
      │          │                             │
      │          ▼                             ▼
      │     [成功]                         [失敗]
      │          │                             │
      │          ▼                             ▼
      │   IReference<GPUDevice>        fallback(message)
      │          │                             │
      │          ▼                             ▼
      └──▶ GPU描画有効             CPUレンダリングへフォールバック
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| gpuDisposable.ts | `src/vs/editor/browser/gpu/gpuDisposable.ts` | ユーティリティ | GPUリソースのライフサイクル管理 |
| viewLinesGpu.ts | `src/vs/editor/browser/viewParts/viewLinesGpu/viewLinesGpu.ts` | 描画コンポーネント | GPUを使用したテキスト行のレンダリング |
| lifecycle.ts | `src/vs/base/common/lifecycle.ts` | ユーティリティ | IReference型の定義 |
