# 通知設計書 34-keybindingsEditor.error

## 概要

本ドキュメントは、VS Code エディタにおけるキーボードショートカット編集時のエラー通知機能の設計を記載する。KeybindingsEditorは、keybindings.jsonファイルの編集中にエラーが発生した場合にユーザーにエラーメッセージを通知する。

### 本通知の処理概要

keybindingsEditor.error通知は、キーボードショートカットエディタでキーバインディングの追加、変更、削除、リセット操作中にエラーが発生した場合に、エラーメッセージをユーザーに通知する機能である。

**業務上の目的・背景**：VSCodeのキーボードショートカットエディタは、ユーザーがGUIからキーバインディングをカスタマイズできる機能を提供している。内部的にはkeybindings.jsonファイルを編集するが、ファイルの書き込みエラーや不正なJSON形式などの問題が発生する可能性がある。このエラー通知により、ユーザーに問題の原因を伝え、手動での修正を促す。

**通知の送信タイミング**：以下の操作中にエラーが発生した場合に通知される：(1) キーバインディングの定義（defineKeybinding）、(2) キーバインディングの削除（removeKeybinding）、(3) キーバインディングのリセット（resetKeybinding）。

**通知の受信者**：キーボードショートカットエディタで操作を行ったユーザー本人がNotificationServiceを通じてエラーを受け取る。

**通知内容の概要**：エラーメッセージには、発生したエラーの内容と「keybindings.json ファイルを開いてエラーを確認してください」という指示が含まれる。

**期待されるアクション**：ユーザーはkeybindings.jsonファイルを直接開き、JSON構文エラーや無効な設定を確認・修正することが期待される。

## 通知種別

アプリ内通知（NotificationService.error）

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 同期 |
| 優先度 | 高（Error） |
| リトライ | なし |

### 送信先決定ロジック

キーバインディング編集操作を実行したユーザーに対して、VSCodeのNotificationServiceを通じてウィンドウ内にエラートーストが表示される。

## 通知テンプレート

### アプリ内通知の場合

| 項目 | 内容 |
|-----|------|
| 重要度 | Error（赤色アイコン） |
| 表示位置 | 画面右下の通知エリア |
| 自動消去 | なし（ユーザー操作で消去） |

### 本文テンプレート

```
Error '{エラーメッセージ}' while editing the keybinding. Please open 'keybindings.json' file and check for errors.
```

または（エラーがstring型の場合）：

```
{エラーメッセージ}
```

### 添付ファイル

なし

## テンプレート変数

| 変数名 | 説明 | データ取得元 | 必須 |
|--------|------|-------------|-----|
| error | エラーオブジェクトまたはメッセージ | catch節のerror引数 | Yes |

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| 画面操作 | defineKeybinding() | try-catch例外発生 | キーバインディング定義中のエラー |
| 画面操作 | removeKeybinding() | try-catch例外発生 | キーバインディング削除中のエラー |
| 画面操作 | resetKeybinding() | try-catch例外発生 | キーバインディングリセット中のエラー |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| 操作成功 | keybindingEditingServiceの操作が正常に完了した場合 |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A[キーバインディング操作開始] --> B{操作種別}
    B -->|定義| C[defineKeybinding]
    B -->|削除| D[removeKeybinding]
    B -->|リセット| E[resetKeybinding]
    C --> F[keybindingEditingService呼び出し]
    D --> F
    E --> F
    F --> G{例外発生?}
    G -->|Yes| H[onKeybindingEditingError]
    G -->|No| I[正常完了]
    H --> J[NotificationService.error]
    J --> K[エントリを再選択]
    I --> L[終了]
    K --> L
```

## データベース参照・更新仕様

### 参照テーブル一覧

VSCodeはデスクトップアプリケーションであり、通常のDBテーブルは使用しない。

| データ構造 | 用途 | 備考 |
|-----------|------|------|
| keybindings.json | ユーザーキーバインディング設定 | JSONファイル |
| IKeybindingItemEntry | 編集対象のキーバインディングエントリ | メモリ内データ構造 |

### ファイル参照詳細

#### keybindings.json

| 項目 | 説明 | 備考 |
|-----|------|------|
| パス | {userDataPath}/keybindings.json | ユーザー設定ディレクトリ |
| 形式 | JSON with Comments (JSONC) | コメント付きJSON |
| 内容 | キーバインディング定義の配列 | key, command, when等 |

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| ファイル書き込みエラー | keybindings.jsonへの書き込み失敗 | エラー通知を表示、手動修正を促す |
| JSON解析エラー | 不正なJSON形式 | エラー通知を表示、手動修正を促す |
| 権限エラー | ファイルへのアクセス権限がない | エラー通知を表示、権限確認を促す |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | なし |
| リトライ間隔 | N/A |
| リトライ対象エラー | なし（ユーザーによる手動修正が必要） |

## 配信設定

### レート制限

| 項目 | 内容 |
|-----|------|
| 制限 | なし（ユーザー操作起点のため） |

### 配信時間帯

ユーザー操作に応じて即座に表示（時間帯制限なし）

## セキュリティ考慮事項

- エラーメッセージにはファイルパスが含まれる可能性があるが、ローカルアプリ内での表示のため問題なし
- keybindings.jsonの内容はユーザーデータであり、適切に保護される

## 備考

- エラー発生後も対象のキーバインディングエントリは選択状態を維持する
- ユーザーはkeybindings.jsonを直接開いて編集することも可能
- エラーメッセージは英語でハードコードされており、nlsによるローカライズが適用される

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

まず、キーバインディングエントリの構造を理解することが重要。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | preferences.ts | `src/vs/workbench/services/preferences/common/preferences.ts` | IKeybindingItemEntry型の定義 |

**読解のコツ**: KeybindingsEditorModelが生成するエントリ構造を理解する。

#### Step 2: エントリーポイントを理解する

エラーが発生する操作の起点を特定。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | keybindingsEditor.ts | `src/vs/workbench/contrib/preferences/browser/keybindingsEditor.ts` | defineKeybinding()（220-234行目） |
| 2-2 | keybindingsEditor.ts | `src/vs/workbench/contrib/preferences/browser/keybindingsEditor.ts` | removeKeybinding()（265-276行目） |
| 2-3 | keybindingsEditor.ts | `src/vs/workbench/contrib/preferences/browser/keybindingsEditor.ts` | resetKeybinding()（278-290行目） |

**主要処理フロー**:
1. **228-229行目**: defineKeybindingでのtry-catch
2. **268-273行目**: removeKeybindingでのtry-catch
3. **286-288行目**: resetKeybindingでのtry-catch

#### Step 3: エラー通知処理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | keybindingsEditor.ts | `src/vs/workbench/contrib/preferences/browser/keybindingsEditor.ts` | onKeybindingEditingError()（829-831行目） |

**主要処理フロー**:
- **830行目**: `this.notificationService.error(typeof error === 'string' ? error : localize('error', "Error '{0}' while editing the keybinding. Please open 'keybindings.json' file and check for errors.", `${error}`));`

#### Step 4: keybindingEditingServiceを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | keybindingEditing.ts | `src/vs/workbench/services/keybinding/common/keybindingEditing.ts` | IKeybindingEditingServiceインターフェース |

**主要処理フロー**:
- editKeybinding(): キーバインディングの編集
- addKeybinding(): キーバインディングの追加
- removeKeybinding(): キーバインディングの削除
- resetKeybinding(): キーバインディングのリセット

### プログラム呼び出し階層図

```
KeybindingsEditor
    │
    ├─ defineKeybinding(keybindingEntry, add)
    │      │
    │      ├─ defineKeybindingWidget.define()
    │      │
    │      └─ updateKeybinding(keybindingEntry, key, when, add)
    │             │
    │             └─ keybindingEditingService.editKeybinding() / addKeybinding()
    │                    │
    │                    └─ [エラー発生] → catch → onKeybindingEditingError()
    │                                                     │
    │                                                     └─ notificationService.error()  ← エラー通知
    │
    ├─ removeKeybinding(keybindingEntry)
    │      │
    │      └─ keybindingEditingService.removeKeybinding()
    │             │
    │             └─ [エラー発生] → catch → onKeybindingEditingError()
    │
    └─ resetKeybinding(keybindingEntry)
           │
           └─ keybindingEditingService.resetKeybinding()
                  │
                  └─ [エラー発生] → catch → onKeybindingEditingError()
```

### データフロー図

```
[入力]                    [処理]                         [出力]

ユーザー操作 ──────▶ KeybindingsEditor
(ショートカット編集)        │
      │                    ▼
      │            keybindingEditingService
      │                    │
      │          ┌─────────┴─────────┐
      │          │                   │
      │          ▼                   ▼
      │     [成功]               [エラー]
      │          │                   │
      │          ▼                   ▼
      │   keybindings.json更新  onKeybindingEditingError
      │          │                   │
      │          ▼                   ▼
      └──▶ UIリフレッシュ      NotificationService.error()
                                     │
                                     ▼
                               エラートースト表示
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| keybindingsEditor.ts | `src/vs/workbench/contrib/preferences/browser/keybindingsEditor.ts` | エディタ実装 | キーボードショートカットエディタのUI |
| keybindingEditing.ts | `src/vs/workbench/services/keybinding/common/keybindingEditing.ts` | サービス | キーバインディング編集のロジック |
| keybindingsEditorModel.ts | `src/vs/workbench/services/preferences/browser/keybindingsEditorModel.ts` | モデル | キーバインディングエントリの管理 |
| notification.ts | `src/vs/platform/notification/common/notification.ts` | インターフェース | INotificationServiceの定義 |
| nls.ts | `src/vs/nls.ts` | ユーティリティ | ローカライズ関数の提供 |
