# 通知設計書 35-integrityService.prompt

## 概要

本ドキュメントは、VS Code エディタにおけるインストール整合性チェック機能の警告通知の設計を記載する。IntegrityServiceは、VSCodeのインストールファイルのチェックサムを検証し、ファイルが改ざんされている場合に警告を表示する。

### 本通知の処理概要

integrityService.prompt通知は、VSCodeのコアファイルのチェックサムを検証し、ファイルが変更されている（純粋でない）場合にユーザーに再インストールを促す警告通知を表示する機能である。

**業務上の目的・背景**：VSCodeのインストールファイルが破損または改ざんされている場合、アプリケーションが正常に動作しない可能性がある。この整合性チェック機能により、ユーザーにインストールの問題を早期に通知し、再インストールによる問題解決を促す。また、セキュリティ上の観点からも、意図しないファイル変更を検出することが重要である。

**通知の送信タイミング**：VSCodeの起動時（LifecyclePhase.Eventuallyフェーズ以降）に自動的にチェックサム検証が実行され、検証に失敗した場合に通知が表示される。ただし、ユーザーが「Don't Show Again」を選択した場合、同じコミットバージョンでは再表示されない。

**通知の受信者**：VSCodeを起動したユーザー本人がNotificationServiceを通じて警告を受け取る。

**通知内容の概要**：「Your {製品名} installation appears to be corrupt. Please reinstall.」というメッセージが表示され、「More Information」と「Don't Show Again」のアクションボタンが提供される。

**期待されるアクション**：ユーザーは「More Information」をクリックして詳細情報を確認するか、VSCodeを再インストールすることが期待される。問題がないと判断した場合は「Don't Show Again」で警告を非表示にできる。

## 通知種別

アプリ内通知（NotificationService.prompt / NotificationService.notify）

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 非同期（起動後の遅延実行） |
| 優先度 | 緊急（NotificationPriority.URGENT） |
| リトライ | なし |

### 送信先決定ロジック

VSCodeを起動したユーザーに対して、NotificationServiceを通じてウィンドウ内に警告が表示される。

## 通知テンプレート

### アプリ内通知の場合

| 項目 | 内容 |
|-----|------|
| 重要度 | Warning（黄色アイコン） |
| 表示位置 | 画面右下の通知エリア |
| 自動消去 | なし（sticky: true） |

### 本文テンプレート

```
Your {製品名} installation appears to be corrupt. Please reinstall.
```

### アクションボタン

| ボタン | 説明 | 動作 |
|--------|------|------|
| More Information | 詳細情報のリンクを開く | checksumFailMoreInfoUrlを外部ブラウザで開く |
| Don't Show Again | 今後表示しない | StorageServiceに非表示フラグを保存 |

### 添付ファイル

なし

## テンプレート変数

| 変数名 | 説明 | データ取得元 | 必須 |
|--------|------|-------------|-----|
| productService.nameShort | 製品名（短縮形） | IProductService | Yes |
| checksumFailMoreInfoUrl | 詳細情報URL | IProductService | No |

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| 起動 | LifecyclePhase.Eventually | isPure === false | チェックサム検証に失敗した場合 |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| isPure === true | すべてのファイルのチェックサムが一致した場合 |
| dontShowPrompt === true | 「Don't Show Again」が選択済みで、同じコミットバージョンの場合 |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A[VSCode起動] --> B[LifecyclePhase.Eventually待機]
    B --> C[_isPure検証実行]
    C --> D{全ファイル検証}
    D -->|チェックサム一致| E[isPure = true]
    D -->|チェックサム不一致| F[isPure = false]
    E --> G[終了 - 通知なし]
    F --> H[ログ出力: Installation has been modified]
    H --> I{StorageData確認}
    I -->|dontShowPrompt && 同じcommit| J[終了 - 通知抑止]
    I -->|それ以外| K[_showNotification]
    K --> L{checksumFailMoreInfoUrl存在?}
    L -->|Yes| M[notificationService.prompt]
    L -->|No| N[notificationService.notify]
    M --> O[アクションボタン付き通知表示]
    N --> P[シンプル通知表示]
```

## データベース参照・更新仕様

### 参照テーブル一覧

VSCodeはデスクトップアプリケーションであり、通常のDBテーブルは使用しない。

| データ構造 | 用途 | 備考 |
|-----------|------|------|
| productService.checksums | 期待されるチェックサム値 | 製品メタデータ |
| IntegrityStorage | 非表示設定の永続化 | StorageService経由 |

### StorageService詳細

#### IntegrityStorage

| キー | スコープ | 型 | 説明 |
|-----|---------|-----|------|
| integrityService | StorageScope.APPLICATION | IStorageData | dontShowPromptとcommitを保持 |

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| チェックサム不一致 | ファイルが変更されている | 警告通知を表示 |
| ファイル読み取りエラー | ファイルにアクセスできない | 空のチェックサムとして不一致扱い |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | なし |
| リトライ間隔 | N/A |
| リトライ対象エラー | なし（起動時の1回のみ） |

## 配信設定

### レート制限

| 項目 | 内容 |
|-----|------|
| 制限 | 起動時に1回のみ |

### 配信時間帯

VSCode起動時（時間帯制限なし）

## セキュリティ考慮事項

- チェックサム検証によりファイル改ざんを検出できる
- 警告メッセージに機密情報は含まれない
- 「Don't Show Again」選択後もcommitが変わると再度警告される

## 備考

- checksumFailMoreInfoUrlが設定されていない場合はアクションボタンなしのシンプルな通知になる
- ログには「Installation has been modified on disk」が警告レベルで記録される
- Electron版（デスクトップ版）でのみ有効

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

まず、整合性チェックに使用されるデータ構造を理解することが重要。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | integrity.ts | `src/vs/workbench/services/integrity/common/integrity.ts` | IIntegrityService、IntegrityTestResult、ChecksumPairの定義 |
| 1-2 | integrityService.ts | `src/vs/workbench/services/integrity/electron-browser/integrityService.ts` | IStorageData、IntegrityStorageクラス（20-56行目） |

**読解のコツ**: ChecksumPairがファイルごとの検証結果を保持し、IntegrityTestResultが全体の結果を集約する。

#### Step 2: エントリーポイントを理解する

整合性チェックの起点を特定。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | integrityService.ts | `src/vs/workbench/services/integrity/electron-browser/integrityService.ts` | コンストラクタで_compute()を呼び出し（79行目） |
| 2-2 | integrityService.ts | `src/vs/workbench/services/integrity/electron-browser/integrityService.ts` | _compute()メソッド（82-102行目） |

**主要処理フロー**:
1. **83行目**: isPure()の結果を待機
2. **84-86行目**: isPureがtrueなら早期終了
3. **88-94行目**: ログに警告メッセージを出力
4. **96-99行目**: StorageDataをチェックし、抑止条件を確認
5. **101行目**: _showNotification()を呼び出し

#### Step 3: チェックサム検証を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | integrityService.ts | `src/vs/workbench/services/integrity/electron-browser/integrityService.ts` | _isPure()メソッド（104-123行目） |
| 3-2 | integrityService.ts | `src/vs/workbench/services/integrity/electron-browser/integrityService.ts` | _resolve()メソッド（125-135行目） |

**主要処理フロー**:
- **105行目**: productService.checksumsから期待値を取得
- **107行目**: LifecyclePhase.Eventuallyを待機
- **109行目**: 全ファイルを並列で検証
- **129行目**: checksumServiceでファイルのチェックサムを計算

#### Step 4: 通知表示を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | integrityService.ts | `src/vs/workbench/services/integrity/electron-browser/integrityService.ts` | _showNotification()メソッド（146-177行目） |

**主要処理フロー**:
- **147行目**: checksumFailMoreInfoUrlの取得
- **148行目**: メッセージの生成（localize使用）
- **149-168行目**: URLがある場合はpromptでアクションボタン付き通知
- **170-176行目**: URLがない場合はシンプルな通知

### プログラム呼び出し階層図

```
IntegrityService (constructor)
    │
    └─ _compute()
           │
           ├─ isPure() → _isPure()
           │      │
           │      ├─ lifecycleService.when(LifecyclePhase.Eventually)
           │      │
           │      └─ _resolve() for each file
           │             │
           │             └─ checksumService.checksum(fileUri)
           │
           ├─ [isPure = true] → 終了
           │
           ├─ [isPure = false]
           │      │
           │      ├─ logService.warn("Installation has been modified on disk")
           │      │
           │      ├─ storage.get() → dontShowPrompt チェック
           │      │
           │      └─ _showNotification()
           │             │
           │             ├─ [checksumFailMoreInfoUrl存在]
           │             │      └─ notificationService.prompt()  ← 警告通知
           │             │
           │             └─ [checksumFailMoreInfoUrl なし]
           │                    └─ notificationService.notify()  ← 警告通知
```

### データフロー図

```
[入力]                    [処理]                         [出力]

VSCode起動 ─────────▶ IntegrityService
      │                    │
      │                    ▼
      │            LifecyclePhase.Eventually待機
      │                    │
      │                    ▼
      │            productService.checksums
      │                    │
      │                    ▼
      │            各ファイルのチェックサム計算
      │            (checksumService)
      │                    │
      │          ┌─────────┴─────────┐
      │          │                   │
      │          ▼                   ▼
      │     [一致]              [不一致]
      │          │                   │
      │          ▼                   ▼
      │     正常終了          Storage確認
      │                            │
      │                  ┌─────────┴─────────┐
      │                  │                   │
      │                  ▼                   ▼
      │          [抑止済み]            [未抑止]
      │                  │                   │
      │                  ▼                   ▼
      └──────────▶ 終了          NotificationService
                                      │
                                      ▼
                               警告トースト表示
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| integrityService.ts | `src/vs/workbench/services/integrity/electron-browser/integrityService.ts` | サービス実装 | 整合性チェックの実装 |
| integrity.ts | `src/vs/workbench/services/integrity/common/integrity.ts` | インターフェース | IIntegrityServiceの定義 |
| checksumService.ts | `src/vs/platform/checksum/common/checksumService.ts` | サービス | ファイルのチェックサム計算 |
| productService.ts | `src/vs/platform/product/common/productService.ts` | サービス | 製品メタデータ（checksums含む） |
| notification.ts | `src/vs/platform/notification/common/notification.ts` | インターフェース | INotificationServiceの定義 |
| nls.ts | `src/vs/nls.ts` | ユーティリティ | ローカライズ関数の提供 |
