# 通知設計書 37-runningAsRoot

## 概要

本ドキュメントは、VS Code エディタにおける管理者（Administrator/root）としての実行時に表示される警告通知の設計を記載する。UpdateContributionは、ユーザースコープインストールのVSCodeが管理者権限で実行されている場合に、更新機能が無効化されることを警告する。

### 本通知の処理概要

runningAsRoot通知は、Windows環境でユーザースコープ（user-scope）インストールのVSCodeが管理者（Administrator）として実行された場合に、自動更新機能が無効化されることをユーザーに通知する機能である。

**業務上の目的・背景**：VSCodeには「ユーザースコープ」と「システムスコープ」の2種類のインストール方式がある。ユーザースコープインストールは特定のユーザーディレクトリにインストールされ、管理者権限なしで更新できるように設計されている。しかし、このインストールを管理者権限で実行すると、ファイル権限の問題から自動更新が正常に機能しなくなる場合がある。この通知により、ユーザーに問題の原因を説明し、適切な実行方法への案内を提供する。

**通知の送信タイミング**：UpdateServiceの状態がDisabled（無効）かつその理由がRunningAsAdminの場合に、VSCode起動時の状態変更イベントで通知が表示される。

**通知の受信者**：VSCodeを管理者として実行しているユーザー本人がNotificationServiceを通じて情報通知を受け取る。

**通知内容の概要**：「Updates are disabled because you are running the user-scope installation of {製品名} as Administrator.」というメッセージと、詳細情報へのリンクが表示される。

**期待されるアクション**：ユーザーは「Learn More」をクリックして詳細情報を確認し、通常のユーザー権限でVSCodeを再起動するか、必要に応じてシステムスコープインストールに切り替えることが期待される。

## 通知種別

アプリ内通知（NotificationService.notify）

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 同期 |
| 優先度 | 情報（Info） |
| リトライ | なし |

### 送信先決定ロジック

管理者としてVSCodeを実行しているユーザーに対して、NotificationServiceを通じてウィンドウ内に情報通知が表示される。

## 通知テンプレート

### アプリ内通知の場合

| 項目 | 内容 |
|-----|------|
| 重要度 | Info（青色アイコン） |
| 表示位置 | 画面右下の通知エリア |
| 自動消去 | あり（デフォルト動作） |

### 本文テンプレート

```
Updates are disabled because you are running the user-scope installation of {製品名} as Administrator.
```

### アクションボタン

| ボタン | 説明 | 動作 |
|--------|------|------|
| Learn More | 詳細情報ページを開く | https://aka.ms/vscode-windows-setup を外部ブラウザで開く |

### neverShowAgain設定

| 項目 | 内容 |
|-----|------|
| ID | no-updates-running-as-admin |
| スコープ | アプリケーション全体 |

## テンプレート変数

| 変数名 | 説明 | データ取得元 | 必須 |
|--------|------|-------------|-----|
| productService.nameLong | 製品名（長形式） | IProductService | Yes |

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| 状態変更 | onStateChange(Disabled) | reason === DisablementReason.RunningAsAdmin | 更新が管理者実行により無効化された場合 |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| neverShowAgain選択済み | 「今後表示しない」が選択されている場合 |
| 非Windows環境 | Windows以外のプラットフォームでは発生しない |
| システムスコープインストール | システムスコープインストールでは問題が発生しない |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A[UpdateService状態変更] --> B{state.type === Disabled?}
    B -->|No| C[他の状態処理]
    B -->|Yes| D{reason === RunningAsAdmin?}
    D -->|No| E[終了]
    D -->|Yes| F[notificationService.notify]
    F --> G[情報通知表示]
    G --> H{ユーザーアクション}
    H -->|Learn More| I[外部URLを開く]
    H -->|Don't Show Again| J[neverShowAgainを保存]
    H -->|Dismiss| K[終了]
```

## データベース参照・更新仕様

### 参照テーブル一覧

| データ構造 | 用途 | 備考 |
|-----------|------|------|
| updateService.state | 更新サービスの状態 | UpdateState型 |
| productService.nameLong | 製品名 | 文字列 |
| productService.target | インストールタイプ | 'user' または 'system' |

### StorageService詳細

| キー | スコープ | 型 | 説明 |
|-----|---------|-----|------|
| no-updates-running-as-admin | neverShowAgain用 | boolean | 通知の非表示設定 |

## エラー処理

### エラーケース一覧

本通知は情報通知であり、エラーは発生しない。

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | なし |
| リトライ間隔 | N/A |
| リトライ対象エラー | N/A |

## 配信設定

### レート制限

| 項目 | 内容 |
|-----|------|
| 制限 | セッションごとに1回（状態変更時） |

### 配信時間帯

VSCode起動時の状態変更イベント発生時（時間帯制限なし）

## セキュリティ考慮事項

- 管理者権限での実行は推奨されないため、ユーザーに警告を表示する
- 通知自体には機密情報は含まれない

## 備考

- Windows環境でのみ発生する通知
- ユーザースコープインストール（`productService.target === 'user'`）でのみ関連
- この問題は公式ドキュメント（https://aka.ms/vscode-windows-setup）で詳細に説明されている

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

まず、更新サービスの状態管理を理解することが重要。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | update.ts | `src/vs/platform/update/common/update.ts` | UpdateState、StateType、DisablementReasonの定義 |

**読解のコツ**: StateType.Disabledとその理由（DisablementReason）の関係を理解する。

#### Step 2: エントリーポイントを理解する

通知が発生する起点を特定。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | update.ts | `src/vs/workbench/contrib/update/browser/update.ts` | UpdateContributionクラスのコンストラクタ（167-206行目） |
| 2-2 | update.ts | `src/vs/workbench/contrib/update/browser/update.ts` | onUpdateStateChangeメソッド（208-278行目） |

**主要処理フロー**:
1. **185行目**: updateService.onStateChangeイベントの登録
2. **211-229行目**: StateType.Disabledの場合の処理

#### Step 3: 通知表示を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | update.ts | `src/vs/workbench/contrib/update/browser/update.ts` | Disabled状態の通知処理（212-228行目） |

**主要処理フロー**:
- **213行目**: state.reason === DisablementReason.RunningAsAdminの判定
- **214-227行目**: notificationService.notifyの呼び出し
- **218-223行目**: Learn Moreアクションの定義
- **226行目**: neverShowAgain設定の定義

### プログラム呼び出し階層図

```
UpdateContribution (constructor)
    │
    └─ updateService.onStateChange
           │
           └─ onUpdateStateChange(state)
                  │
                  ├─ [StateType.Disabled]
                  │      │
                  │      └─ [RunningAsAdmin]
                  │             │
                  │             └─ notificationService.notify()  ← 情報通知
                  │                    │
                  │                    ├─ "Learn More" → openerService.open()
                  │                    └─ neverShowAgain設定
                  │
                  └─ [他の状態] → 対応する処理
```

### データフロー図

```
[入力]                    [処理]                         [出力]

VSCode起動 ─────────▶ UpdateService初期化
      │                    │
      │                    ▼
      │            状態チェック
      │            (管理者実行判定)
      │                    │
      │          ┌─────────┴─────────┐
      │          │                   │
      │          ▼                   ▼
      │     [通常実行]          [管理者実行]
      │          │                   │
      │          ▼                   ▼
      │     通常の更新         state = Disabled
      │     チェック           reason = RunningAsAdmin
      │                              │
      │                              ▼
      └──────────────────▶ NotificationService.notify()
                                     │
                                     ▼
                               情報トースト表示
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| update.ts | `src/vs/workbench/contrib/update/browser/update.ts` | コントリビューション | 更新通知機能の実装 |
| update.ts | `src/vs/platform/update/common/update.ts` | インターフェース | IUpdateService、UpdateState、DisablementReasonの定義 |
| notification.ts | `src/vs/platform/notification/common/notification.ts` | インターフェース | INotificationServiceの定義 |
| nls.ts | `src/vs/nls.ts` | ユーティリティ | ローカライズ関数の提供 |
