# 通知設計書 38-walkThrough.gitNotFound

## 概要

本ドキュメントは、VS Code エディタにおけるウォークスルー（Welcome/Interactive Playground）機能でGitが見つからない場合に表示される情報通知の設計を記載する。WalkThroughPartは、git.cloneコマンドのリンクがクリックされた際にGitがインストールされていないことを検出し、ユーザーに情報を通知する。

### 本通知の処理概要

walkThrough.gitNotFound通知は、ウォークスルーページ（Welcome、Getting Startedなど）でgit.cloneコマンドへのリンクがクリックされた際に、Gitがシステムにインストールされていない場合に情報メッセージを表示する機能である。

**業務上の目的・背景**：VSCodeのウォークスルーページにはGitリポジトリのクローン操作を開始するリンクが含まれている場合がある。しかし、初めてVSCodeを使用するユーザーや、Gitをまだインストールしていない環境では、このリンクをクリックしてもエラーになる。この通知により、ユーザーにGitがインストールされていないことを明確に伝え、混乱を防ぐ。

**通知の送信タイミング**：ウォークスルーページ内のリンクがクリックされ、そのリンクがgit.cloneコマンドを実行しようとした際に、git.cloneコマンドがCommandsRegistryに登録されていない場合に通知が表示される。

**通知の受信者**：ウォークスルーページでgit.cloneリンクをクリックしたユーザー本人がNotificationServiceを通じて情報通知を受け取る。

**通知内容の概要**：「It looks like Git is not installed on your system.」というシンプルなメッセージが表示される。

**期待されるアクション**：ユーザーはGitをシステムにインストールし、VSCodeを再起動してから再度操作を試みることが期待される。

## 通知種別

アプリ内通知（NotificationService.info）

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 同期 |
| 優先度 | 情報（Info） |
| リトライ | なし |

### 送信先決定ロジック

git.cloneリンクをクリックしたユーザーに対して、NotificationServiceを通じてウィンドウ内に情報トーストが表示される。

## 通知テンプレート

### アプリ内通知の場合

| 項目 | 内容 |
|-----|------|
| 重要度 | Info（青色アイコン） |
| 表示位置 | 画面右下の通知エリア |
| 自動消去 | あり（デフォルト動作） |

### 本文テンプレート

```
It looks like Git is not installed on your system.
```

### 添付ファイル

なし

## テンプレート変数

| 変数名 | 説明 | データ取得元 | 必須 |
|--------|------|-------------|-----|
| なし | 固定メッセージのため変数なし | - | - |

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| 画面操作 | リンククリック | uri.path === 'git.clone' && !CommandsRegistry.getCommand('git.clone') | git.cloneコマンドが登録されていない場合 |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| git.cloneコマンド存在 | Git拡張機能が正常に読み込まれ、コマンドが登録されている場合 |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A[リンククリック] --> B{uri.scheme === 'command'?}
    B -->|No| C[openerService.open]
    B -->|Yes| D{uri.path === 'git.clone'?}
    D -->|No| E[openerService.open]
    D -->|Yes| F{CommandsRegistry.getCommand存在?}
    F -->|Yes| E
    F -->|No| G[notificationService.info]
    G --> H[処理終了 return]
```

## データベース参照・更新仕様

### 参照テーブル一覧

| データ構造 | 用途 | 備考 |
|-----------|------|------|
| CommandsRegistry | コマンドの登録状態確認 | Git拡張機能が登録するコマンド |

### API呼び出し詳細

#### CommandsRegistry.getCommand

| メソッド | 説明 | 戻り値 |
|---------|------|-------|
| getCommand(id) | 指定IDのコマンド取得 | ICommand | undefined |

## エラー処理

### エラーケース一覧

本通知は情報通知であり、エラー処理は発生しない。Gitが見つからない状態を正常なフローとして処理している。

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | なし |
| リトライ間隔 | N/A |
| リトライ対象エラー | N/A |

## 配信設定

### レート制限

| 項目 | 内容 |
|-----|------|
| 制限 | なし（ユーザー操作起点のため） |

### 配信時間帯

ユーザー操作に応じて即座に表示（時間帯制限なし）

## セキュリティ考慮事項

- 通知にはシステム情報は含まれない
- Gitのインストール状態のみを間接的に検出

## 備考

- Git拡張機能がインストールされていても、読み込みに時間がかかる場合はこの通知が表示される可能性がある
- git.clone以外のGitコマンドについては同様のチェックは行われていない

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: エントリーポイントを理解する

ウォークスルーでのリンク処理を確認。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | walkThroughPart.ts | `src/vs/workbench/contrib/welcomeWalkthrough/browser/walkThroughPart.ts` | registerClickHandler()（157-188行目） |
| 1-2 | walkThroughPart.ts | `src/vs/workbench/contrib/welcomeWalkthrough/browser/walkThroughPart.ts` | open()メソッド（190-196行目） |

**主要処理フロー**:
1. **158行目**: content.addEventListener('click', ...)でクリックイベント登録
2. **173行目**: URIを解析してopen()メソッドに渡す
3. **191-194行目**: git.cloneコマンドの特別処理

#### Step 2: 通知表示を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | walkThroughPart.ts | `src/vs/workbench/contrib/welcomeWalkthrough/browser/walkThroughPart.ts` | git.clone判定と通知（191-194行目） |

**主要処理フロー**:
- **191行目**: `uri.scheme === 'command' && uri.path === 'git.clone'`の判定
- **191行目**: `!CommandsRegistry.getCommand('git.clone')`でGit拡張機能の存在確認
- **192行目**: `this.notificationService.info(localize('walkThrough.gitNotFound', "It looks like Git is not installed on your system."))`

### プログラム呼び出し階層図

```
WalkThroughPart
    │
    ├─ registerClickHandler()
    │      │
    │      └─ content.addEventListener('click', ...)
    │             │
    │             └─ [リンククリック]
    │                    │
    │                    └─ open(uri)
    │                           │
    │                           ├─ [uri.path === 'git.clone']
    │                           │      │
    │                           │      └─ [!CommandsRegistry.getCommand]
    │                           │             │
    │                           │             └─ notificationService.info()  ← 情報通知
    │                           │
    │                           └─ [その他] → openerService.open()
```

### データフロー図

```
[入力]                    [処理]                         [出力]

リンククリック ─────────▶ WalkThroughPart.open()
      │                         │
      │                         ▼
      │                  URIスキーム判定
      │                  (command?)
      │                         │
      │                         ▼
      │                  コマンドパス判定
      │                  (git.clone?)
      │                         │
      │          ┌──────────────┴──────────────┐
      │          │                             │
      │          ▼                             ▼
      │   [コマンド登録済み]           [コマンド未登録]
      │          │                             │
      │          ▼                             ▼
      │   openerService.open()      notificationService.info()
      │          │                             │
      │          ▼                             ▼
      └──▶ git.clone実行          "Git not installed" 表示
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| walkThroughPart.ts | `src/vs/workbench/contrib/welcomeWalkthrough/browser/walkThroughPart.ts` | エディタ | ウォークスルー画面の実装 |
| walkThroughInput.ts | `src/vs/workbench/contrib/welcomeWalkthrough/browser/walkThroughInput.ts` | 入力 | ウォークスルーの入力モデル |
| commands.ts | `src/vs/platform/commands/common/commands.ts` | レジストリ | CommandsRegistryの定義 |
| notification.ts | `src/vs/platform/notification/common/notification.ts` | インターフェース | INotificationServiceの定義 |
| nls.ts | `src/vs/nls.ts` | ユーティリティ | ローカライズ関数の提供 |
