# 通知設計書 39-update.notification

## 概要

本ドキュメントは、VS Code エディタにおけるアプリケーション更新に関する通知機能の設計を記載する。UpdateContributionは、VSCodeの更新状態に応じて様々な通知をユーザーに表示し、更新のダウンロード、インストール、再起動を促す。

### 本通知の処理概要

update.notification通知は、VSCodeの自動更新システムに関連する複数の通知を統合的に管理する機能である。更新が利用可能になった場合、ダウンロード完了時、インストール準備完了時に適切な通知をユーザーに表示する。

**業務上の目的・背景**：VSCodeは継続的に新機能やバグ修正がリリースされており、ユーザーに最新版を使用してもらうことが重要である。この通知機能により、更新の存在をユーザーに伝え、ダウンロードや再起動のタイミングをユーザーがコントロールできるようにする。

**通知の送信タイミング**：以下の更新状態変化時に通知が表示される：(1) AvailableForDownload（Linux）、(2) Downloaded（Windows）、(3) Ready（Windows/Mac）、(4) エラー発生時。

**通知の受信者**：VSCodeを使用しているユーザー本人がNotificationServiceを通じて通知を受け取る。

**通知内容の概要**：更新状態に応じた適切なメッセージとアクションボタン（ダウンロード、インストール、再起動、リリースノート、後で）が表示される。

**期待されるアクション**：ユーザーはアクションボタンをクリックして更新をダウンロード/インストール/再起動するか、「Later」で延期できる。

## 通知種別

アプリ内通知（NotificationService.prompt）

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 非同期（状態変更イベント） |
| 優先度 | オプション（NotificationPriority.OPTIONAL） |
| リトライ | なし |

### 送信先決定ロジック

VSCodeを使用しているユーザーに対して、更新状態の変化時にNotificationServiceを通じてウィンドウ内に通知が表示される。

## 通知テンプレート

### 通知パターン一覧

| 状態 | 重要度 | メッセージ | sticky |
|------|--------|---------|--------|
| AvailableForDownload | Info | "There is an available update." | false |
| Downloaded | Info | "There's an update available: {製品名} {バージョン}" | false |
| Ready | Info | "Restart {製品名} to apply the latest update." | true |
| Error | Error | {エラーメッセージ} | false |

### アクションボタン

#### AvailableForDownload（Linux）

| ボタン | 説明 |
|--------|------|
| Download Update | 更新をダウンロード |
| Later | 後で |
| Release Notes | リリースノートを表示 |

#### Downloaded（Windows）

| ボタン | 説明 |
|--------|------|
| Install Update | 更新をインストール |
| Later | 後で |
| Release Notes | リリースノートを表示 |

#### Ready（Windows/Mac）

| ボタン | 説明 |
|--------|------|
| Update Now | 今すぐ再起動して更新 |
| Later | 後で |
| Release Notes | リリースノートを表示 |

## テンプレート変数

| 変数名 | 説明 | データ取得元 | 必須 |
|--------|------|-------------|-----|
| productService.nameLong | 製品名（長形式） | IProductService | Yes |
| productService.nameShort | 製品名（短形式） | IProductService | Yes |
| update.productVersion | 更新バージョン | IUpdate | No |

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| 状態変更 | StateType.AvailableForDownload | shouldShowNotification() | 更新がダウンロード可能（Linux） |
| 状態変更 | StateType.Downloaded | shouldShowNotification() && !Mac && !backgroundUpdates | 更新がダウンロード完了（Windows） |
| 状態変更 | StateType.Ready | shouldShowNotification() または system-scope | 更新がインストール準備完了 |
| 状態変更 | StateType.Idle + error | エラーが発生 | 更新チェックエラー |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| shouldShowNotification() === false | 最後の通知から5日以内 |
| productVersion なし | 更新のバージョン情報がない場合 |
| Mac (Downloaded) | Macでは Downloaded 状態の通知は抑止 |
| backgroundUpdates有効 (Downloaded) | バックグラウンド更新が有効な場合は Downloaded 通知を抑止 |

### shouldShowNotification ロジック

```
currentVersion !== lastKnownVersion の場合、バージョンと日時を保存
5日以上経過している場合のみ true を返す
```

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A[updateService.onStateChange] --> B{state.type?}
    B -->|AvailableForDownload| C{shouldShowNotification?}
    C -->|Yes| D[onUpdateAvailable]
    D --> E[notificationService.prompt]
    B -->|Downloaded| F{!Mac && !backgroundUpdates?}
    F -->|Yes| G{shouldShowNotification?}
    G -->|Yes| H[onUpdateDownloaded]
    H --> E
    B -->|Ready| I{shouldShowNotification または system?}
    I -->|Yes| J[onUpdateReady]
    J --> E
    B -->|Idle + error| K[onError]
    K --> L[notificationService.notify]
```

## データベース参照・更新仕様

### 参照テーブル一覧

| データ構造 | 用途 | 備考 |
|-----------|------|------|
| update/lastKnownVersion | 最後に確認したバージョン | StorageService |
| update/updateNotificationTime | 最後の通知時刻 | StorageService |

### StorageService詳細

| キー | スコープ | 型 | 説明 |
|-----|---------|-----|------|
| update/lastKnownVersion | StorageScope.APPLICATION | string | コミットハッシュ |
| update/updateNotificationTime | StorageScope.APPLICATION | number | ミリ秒タイムスタンプ |

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| ネットワークエラー | タイムアウト/接続断 | 無視（通知しない） |
| Squirrel問題 | macOSの検疫 | メッセージを書き換えて通知 |
| その他エラー | 一般的なエラー | エラーメッセージを通知 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | なし |
| リトライ間隔 | N/A |
| リトライ対象エラー | なし |

## 配信設定

### レート制限

| 項目 | 内容 |
|-----|------|
| 制限 | 5日間隔（shouldShowNotification） |

### 配信時間帯

イベント発生時に即座に表示（時間帯制限なし）

## セキュリティ考慮事項

- 更新はMicrosoft公式サーバーからダウンロードされる
- 通知に機密情報は含まれない

## 備考

- ActivityServiceを通じてステータスバーにバッジが表示される
- CheckingForUpdates、Downloading、Updating状態ではProgressBadgeが表示される
- メジャー/マイナーアップデートの場合、リリースノート表示コマンドが利用可能になる

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

まず、更新状態の管理を理解することが重要。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | update.ts | `src/vs/platform/update/common/update.ts` | UpdateState、StateType、IUpdateの定義 |
| 1-2 | update.ts | `src/vs/workbench/contrib/update/browser/update.ts` | UpdateContributionクラス（160-520行目） |

**読解のコツ**: StateTypeの各状態（Idle、CheckingForUpdates、AvailableForDownload、Downloaded、Ready等）の遷移を理解する。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | update.ts | `src/vs/workbench/contrib/update/browser/update.ts` | onUpdateStateChange（208-278行目） |

**主要処理フロー**:
1. **211行目**: state.typeによるswitch分岐
2. **239-241行目**: AvailableForDownloadの処理
3. **243-245行目**: Downloadedの処理
4. **247-256行目**: Readyの処理

#### Step 3: 各通知メソッドを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | update.ts | `src/vs/workbench/contrib/update/browser/update.ts` | onUpdateAvailable（298-326行目） |
| 3-2 | update.ts | `src/vs/workbench/contrib/update/browser/update.ts` | onUpdateDownloaded（328-363行目） |
| 3-3 | update.ts | `src/vs/workbench/contrib/update/browser/update.ts` | onUpdateReady（365-399行目） |

**主要処理フロー**:
- **309-325行目**: ダウンロード可能通知（Download Update, Later, Release Notes）
- **346-362行目**: ダウンロード完了通知（Install Update, Later, Release Notes）
- **390-398行目**: インストール準備完了通知（Update Now, Later, Release Notes）

#### Step 4: 通知抑制ロジックを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | update.ts | `src/vs/workbench/contrib/update/browser/update.ts` | shouldShowNotification（401-416行目） |

**主要処理フロー**:
- **402-410行目**: バージョン変更時の日時保存
- **412-415行目**: 5日間隔のチェック

### プログラム呼び出し階層図

```
UpdateContribution (constructor)
    │
    └─ updateService.onStateChange
           │
           └─ onUpdateStateChange(state)
                  │
                  ├─ [StateType.AvailableForDownload]
                  │      └─ onUpdateAvailable()
                  │             └─ notificationService.prompt()  ← 更新通知
                  │
                  ├─ [StateType.Downloaded]
                  │      └─ onUpdateDownloaded()
                  │             └─ notificationService.prompt()  ← 更新通知
                  │
                  ├─ [StateType.Ready]
                  │      └─ onUpdateReady()
                  │             └─ notificationService.prompt()  ← 更新通知
                  │
                  └─ [StateType.Idle + error]
                         └─ onError()
                                └─ notificationService.notify()  ← エラー通知
```

### データフロー図

```
[入力]                    [処理]                         [出力]

UpdateService ──────────▶ UpdateContribution
      │                         │
      │                         ▼
      │                  onUpdateStateChange()
      │                         │
      │          ┌──────────────┼──────────────┐
      │          │              │              │
      │          ▼              ▼              ▼
      │    Available       Downloaded        Ready
      │          │              │              │
      │          ▼              ▼              ▼
      │   shouldShow?      shouldShow?    shouldShow?
      │          │              │              │
      │          ▼              ▼              ▼
      └──▶ notificationService.prompt()
                  │
                  ▼
           更新通知表示
           (Download/Install/Update Now)
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| update.ts | `src/vs/workbench/contrib/update/browser/update.ts` | コントリビューション | 更新通知機能の実装 |
| update.ts | `src/vs/platform/update/common/update.ts` | インターフェース | IUpdateService、UpdateStateの定義 |
| releaseNotesEditor.ts | `src/vs/workbench/contrib/update/browser/releaseNotesEditor.ts` | エディタ | リリースノート表示機能 |
| activity.ts | `src/vs/workbench/services/activity/common/activity.ts` | サービス | バッジ表示機能 |
| notification.ts | `src/vs/platform/notification/common/notification.ts` | インターフェース | INotificationServiceの定義 |
| nls.ts | `src/vs/nls.ts` | ユーティリティ | ローカライズ関数の提供 |
