# 通知設計書 4-too.large.for.replaceall

## 概要

本ドキュメントは、VS Codeのエディタで全置換操作を実行しようとした際に、対象ファイルのサイズが大きすぎて処理できない場合に表示される警告通知の設計について記述する。

### 本通知の処理概要

この通知は、エディタの検索・置換機能において「すべて置換（Replace All）」操作を実行しようとした際に、対象ファイルがヒープ操作には大きすぎる場合に警告メッセージを表示する機能である。

**業務上の目的・背景**：大規模なファイルに対する全置換操作は、メモリ不足やブラウザ/アプリケーションのフリーズを引き起こす可能性がある。この通知は、ユーザーに対してその操作が実行できない理由を明確に伝え、代替手段を検討するよう促すことを目的としている。

**通知の送信タイミング**：ユーザーが検索・置換ウィジェットで「すべて置換」ボタンをクリックした際、または対応するキーボードショートカット（Ctrl+Alt+Enter）を押した際に、モデルが`isTooLargeForHeapOperation()`を満たす場合に通知が送信される。

**通知の受信者**：全置換操作を試みたVS Codeユーザーが対象となる。

**通知内容の概要**：「The file is too large to perform a replace all operation.」という固定メッセージが表示される。

**期待されるアクション**：ユーザーは以下のいずれかの対応を取ることが期待される：
- 個別に置換操作を行う
- ファイルを分割して編集する
- 外部ツールを使用して置換する

## 通知種別

アプリ内通知（VS Code内部のNotificationService経由、警告レベル）

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 同期 |
| 優先度 | 中（警告通知） |
| リトライ | なし |

### 送信先決定ロジック

全置換操作を実行しようとしたユーザーに対して表示される。

## 通知テンプレート

### アプリ内通知の場合

| 項目 | 内容 |
|-----|------|
| 深刻度 | Warning（警告） |
| 形式 | テキスト |

### 本文テンプレート

```
The file is too large to perform a replace all operation.
```

### 添付ファイル

| ファイル名 | 形式 | 条件 | 説明 |
|----------|------|------|------|
| なし | - | - | 添付ファイルなし |

## テンプレート変数

| 変数名 | 説明 | データ取得元 | 必須 |
|--------|------|-------------|-----|
| なし | - | 固定メッセージのため変数なし | - |

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| 画面操作 | 「すべて置換」ボタンクリック | model.isTooLargeForHeapOperation() === true | ファイルがヒープ操作に大きすぎる場合 |
| キーボード | Ctrl+Alt+Enter | model.isTooLargeForHeapOperation() === true | 全置換のショートカットキー操作時 |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| ファイルサイズが適正 | `isTooLargeForHeapOperation()`がfalseを返す場合は通知せず、正常に置換処理を実行 |
| モデルなし | エディタにモデルがない場合は処理自体がスキップされる |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A[replaceAll関数呼び出し] --> B{モデルが存在するか}
    B -->|No| C[処理終了 return false]
    B -->|Yes| D{isTooLargeForHeapOperation?}
    D -->|Yes| E[警告通知を表示]
    E --> F[return false]
    D -->|No| G[全置換処理実行]
    G --> H[return true]
```

## データベース参照・更新仕様

### 参照テーブル一覧

| テーブル名 | 用途 | 備考 |
|-----------|------|------|
| なし | - | データベースアクセスなし |

### 更新テーブル一覧

| テーブル名 | 操作 | 概要 |
|-----------|------|------|
| なし | - | データベースアクセスなし |

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| ファイルサイズ超過 | ヒープ操作に大きすぎるファイル | 警告通知を表示して処理を中止 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | なし |
| リトライ間隔 | - |
| リトライ対象エラー | - |

## 配信設定

### レート制限

| 項目 | 内容 |
|-----|------|
| 1分あたり上限 | なし（ユーザー操作に応じて発生） |
| 1日あたり上限 | なし |

### 配信時間帯

制限なし（ユーザー操作に応じて随時発生）

## セキュリティ考慮事項

- 個人情報は含まれない
- ファイル内容に関する情報は表示されない
- ローカライズ機能（nls.localize）を使用して多言語対応している

## 備考

- この通知は、VS Codeのメモリ管理とパフォーマンスを保護するための安全機構の一部
- `isTooLargeForHeapOperation()`メソッドは、内部的にファイルサイズの閾値を管理している
- 個別の置換（Replace）操作はファイルサイズに関係なく実行可能

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

検索・置換機能の状態管理とモデルの構造を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | findModel.ts | `src/vs/editor/contrib/find/browser/findModel.ts` | FindModelBoundToEditorModelクラスと検索・置換の状態管理 |
| 1-2 | textModel.ts | `src/vs/editor/common/model/textModel.ts` | TextModelのisTooLargeForHeapOperation()メソッドの定義 |

**読解のコツ**: VS Codeのエディタモデルは、テキストデータの保持とサイズ判定ロジックを持つ。

#### Step 2: エントリーポイントを理解する

`replaceAll`関数の実装を確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | findController.ts | `src/vs/editor/contrib/find/browser/findController.ts` | CommonFindControllerクラスのreplaceAll()メソッド（401-411行目） |

**主要処理フロー**:
1. **401行目**: `replaceAll()`メソッドの定義開始
2. **402行目**: `_model`が存在するかチェック
3. **403行目**: `_editor.getModel()?.isTooLargeForHeapOperation()`で大きすぎるかチェック
4. **404行目**: 大きすぎる場合、`_notificationService.warn()`で警告通知を表示
5. **405行目**: `return false`で処理終了
6. **407行目**: サイズが適正な場合、`_model.replaceAll()`で実際の置換処理を実行
7. **408行目**: `return true`で成功を返却

#### Step 3: 通知サービスを理解する

NotificationServiceの警告メソッドの仕組みを確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | notification.ts | `src/vs/platform/notification/common/notification.ts` | INotificationServiceインターフェースのwarn()メソッド |

### プログラム呼び出し階層図

```
ユーザー操作（すべて置換ボタンクリック）
    │
    └─ CommonFindController.replaceAll()
           │
           ├─ this._model チェック
           │      └─ null → return false
           │
           ├─ this._editor.getModel()?.isTooLargeForHeapOperation()
           │      │
           │      └─ true → this._notificationService.warn()
           │               └─ nls.localize('too.large.for.replaceall', ...)
           │               └─ return false
           │
           └─ this._model.replaceAll()
                  └─ return true
```

### データフロー図

```
[入力]                    [処理]                              [出力]

ユーザー操作        ───▶ replaceAll()                  ───▶ 置換実行
(すべて置換)               │                                 または
                          ├─ モデルサイズ判定               警告通知
                          │   └─ isTooLargeForHeapOperation()
                          │
                          └─ 通知サービス
                              └─ notificationService.warn()
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| findController.ts | `src/vs/editor/contrib/find/browser/findController.ts` | ソース | 検索・置換コントローラー、replaceAll()メソッドの実装 |
| findModel.ts | `src/vs/editor/contrib/find/browser/findModel.ts` | ソース | 検索・置換のモデル（FindModelBoundToEditorModel） |
| notification.ts | `src/vs/platform/notification/common/notification.ts` | ソース | 通知サービスのインターフェース定義 |
| nls.ts | `src/vs/nls.ts` | ソース | ローカライゼーション機能の提供 |
| textModel.ts | `src/vs/editor/common/model/textModel.ts` | ソース | TextModelクラス、isTooLargeForHeapOperation()の実装 |
