# 通知設計書 40-mcpMigration.prompt

## 概要

本ドキュメントは、VS Code エディタにおけるMCP（Model Context Protocol）設定の移行に関する通知機能の設計を記載する。McpConfigMigrationContributionは、旧形式のMCP設定（settings.json内）を検出し、新形式の専用設定ファイルへの移行を促す。

### 本通知の処理概要

mcpMigration.prompt通知は、VSCodeのMCP機能において、settings.json内の旧形式のMCPサーバー設定を検出した場合に、ユーザーに設定の移行を促すエラー通知を表示する機能である。

**業務上の目的・背景**：MCP（Model Context Protocol）はVSCodeの新しい機能であり、設定形式が更新された。以前はsettings.json内にMCPサーバー設定を記述していたが、現在は専用の設定ファイルを使用する方式に変更された。この通知により、ユーザーに設定形式の変更を伝え、スムーズな移行を支援する。

**通知の送信タイミング**：VSCode起動時に自動的に旧形式の設定を検出して移行を試みる。また、settings.jsonファイルの変更を監視し、旧形式のMCP設定が追加された場合にも通知を表示する。

**通知の受信者**：旧形式のMCP設定を持つユーザー本人がNotificationServiceを通じてエラー通知を受け取る。

**通知内容の概要**：「MCP servers should no longer be configured in user settings. Use the dedicated MCP configuration instead.」というメッセージが表示され、「Update Now」と「Open MCP Configuration」のアクションボタンが提供される。

**期待されるアクション**：ユーザーは「Update Now」をクリックして自動移行を実行するか、「Open MCP Configuration」で新しい設定ファイルを開いて手動で設定を移行することが期待される。

## 通知種別

アプリ内通知（NotificationService.prompt）

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 非同期（ファイル監視イベント） |
| 優先度 | エラー（Severity.Error） |
| リトライ | なし |

### 送信先決定ロジック

旧形式のMCP設定を持つユーザーに対して、NotificationServiceを通じてウィンドウ内にエラー通知が表示される。

## 通知テンプレート

### アプリ内通知の場合

| 項目 | 内容 |
|-----|------|
| 重要度 | Error（赤色アイコン） |
| 表示位置 | 画面右下の通知エリア |
| 自動消去 | なし（デフォルト動作） |

### 本文テンプレート

#### ローカル設定の場合

```
MCP servers should no longer be configured in user settings. Use the dedicated MCP configuration instead.
```

#### リモート設定の場合

```
MCP servers should no longer be configured in remote user settings. Use the dedicated MCP configuration instead.
```

### アクションボタン

| ボタン | 説明 | 動作 |
|--------|------|------|
| Update Now | 自動移行を実行 | migrateMcpConfig()を呼び出し、移行後にMCP設定を開く |
| Open User/Remote MCP Configuration | MCP設定ファイルを開く | McpCommandIds.OpenUserMcp または OpenRemoteUserMcp コマンドを実行 |

## テンプレート変数

| 変数名 | 説明 | データ取得元 | 必須 |
|--------|------|-------------|-----|
| isRemote | リモート設定かどうか | remoteAgentService | Yes |

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| ファイル変更 | settings.jsonの変更 | MCP設定が存在 && サーバー数 > 0 | ファイル監視で旧形式設定を検出 |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| MCP設定なし | settings.jsonにMCP設定が存在しない |
| サーバー数 = 0 | MCP設定はあるがサーバーが定義されていない |
| 起動時の自動移行成功 | 起動時に自動移行が完了した場合 |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A[VSCode起動] --> B[migrateMcpConfig]
    B --> C{settings.jsonにMCP設定?}
    C -->|No| D[監視開始]
    C -->|Yes| E[自動移行実行]
    E --> F[旧設定を削除]
    F --> D
    D --> G[settings.json変更監視]
    G --> H{MCP設定追加?}
    H -->|No| G
    H -->|Yes| I[showMcpConfigErrorNotification]
    I --> J[notificationService.prompt]
    J --> K{ユーザーアクション}
    K -->|Update Now| L[migrateMcpConfig + Open Config]
    K -->|Open Config| M[Open MCP Configuration]
```

## データベース参照・更新仕様

### 参照ファイル一覧

| ファイル | 用途 | 備考 |
|---------|------|------|
| settings.json | ユーザー設定（旧形式） | userDataProfileService.currentProfile.settingsResource |
| remote settings.json | リモートユーザー設定 | remoteEnvironment.settingsPath |

### 設定構造

#### 旧形式（settings.json内）

```json
{
  "mcp": {
    "inputs": [...],
    "servers": {
      "server-name": {
        "type": "local",
        "command": "...",
        ...
      }
    }
  }
}
```

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| 設定ファイル読み取り失敗 | ファイルアクセスエラー | ログに警告を記録、処理を継続 |
| JSON解析失敗 | 不正なJSON形式 | エラーを無視（ファイルが不完全な可能性） |
| 移行失敗 | 設定の削除/書き込み失敗 | ログにエラーを記録 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | なし |
| リトライ間隔 | N/A |
| リトライ対象エラー | なし |

## 配信設定

### レート制限

| 項目 | 内容 |
|-----|------|
| 制限 | なし（ファイル変更イベントごと） |

### 配信時間帯

イベント発生時に即座に表示（時間帯制限なし）

## セキュリティ考慮事項

- MCP設定にはサーバー接続情報が含まれる可能性があるため、適切に保護される
- 設定ファイルへのアクセスはVSCodeのファイルシステムサービスを通じて行われる

## 備考

- 起動時に旧形式設定が検出された場合は自動的に移行が試みられる
- リモート環境の設定も同様に監視・移行される
- 移行後、旧形式の設定はsettings.jsonから削除される

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

まず、MCP設定の構造を理解することが重要。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | mcpMigration.ts | `src/vs/workbench/contrib/mcp/browser/mcpMigration.ts` | IMcpConfigurationインターフェース（26-29行目） |

**読解のコツ**: IMcpConfigurationにはinputsとserversが含まれ、serversはサーバー名をキーとする辞書型。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | mcpMigration.ts | `src/vs/workbench/contrib/mcp/browser/mcpMigration.ts` | コンストラクタ（35-47行目） |
| 2-2 | mcpMigration.ts | `src/vs/workbench/contrib/mcp/browser/mcpMigration.ts` | migrateMcpConfig（49-75行目） |

**主要処理フロー**:
1. **46行目**: migrateMcpConfig()の呼び出し
2. **51行目**: settings.jsonからMCP設定を解析
3. **52-55行目**: サーバーが存在する場合は移行処理

#### Step 3: ファイル監視を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | mcpMigration.ts | `src/vs/workbench/contrib/mcp/browser/mcpMigration.ts` | watchForMcpConfiguration（77-84行目） |
| 3-2 | mcpMigration.ts | `src/vs/workbench/contrib/mcp/browser/mcpMigration.ts` | checkForMcpConfigInFile（86-95行目） |

**主要処理フロー**:
- **78行目**: fileService.watch()でファイル監視開始
- **79-83行目**: onDidFilesChangeでファイル変更を検出
- **89-90行目**: 旧形式設定が存在する場合にshowMcpConfigErrorNotificationを呼び出し

#### Step 4: 通知表示を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | mcpMigration.ts | `src/vs/workbench/contrib/mcp/browser/mcpMigration.ts` | showMcpConfigErrorNotification（97-123行目） |

**主要処理フロー**:
- **98-100行目**: isRemoteに応じたメッセージ選択
- **102-104行目**: isRemoteに応じたボタンラベル選択
- **108-122行目**: notificationService.promptの呼び出し

### プログラム呼び出し階層図

```
McpConfigMigrationContribution (constructor)
    │
    ├─ migrateMcpConfig()
    │      │
    │      ├─ parseMcpConfig(settingsResource)
    │      │      └─ fileService.readFile() → parse()
    │      │
    │      ├─ [サーバー存在] mcpManagementService.install()
    │      │
    │      └─ removeMcpConfig()
    │             └─ jsonEditingService.write()
    │
    ├─ watchForMcpConfiguration(settingsResource, isRemote)
    │      │
    │      └─ fileService.onDidFilesChange
    │             │
    │             └─ checkForMcpConfigInFile()
    │                    │
    │                    └─ [MCP設定存在]
    │                           │
    │                           └─ showMcpConfigErrorNotification()
    │                                  │
    │                                  └─ notificationService.prompt()  ← エラー通知
```

### データフロー図

```
[入力]                    [処理]                         [出力]

VSCode起動 ─────────▶ McpConfigMigrationContribution
      │                         │
      │                         ▼
      │                  parseMcpConfig()
      │                  (settings.json読込)
      │                         │
      │          ┌──────────────┴──────────────┐
      │          │                             │
      │          ▼                             ▼
      │   [MCP設定あり]                   [MCP設定なし]
      │          │                             │
      │          ▼                             ▼
      │   自動移行実行                    監視開始
      │          │                             │
      │          ▼                             ▼
      │   設定削除                    ファイル変更検出
      │                                       │
      │                                       ▼
      └──────────────────────────▶ showMcpConfigErrorNotification()
                                              │
                                              ▼
                                       エラートースト表示
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| mcpMigration.ts | `src/vs/workbench/contrib/mcp/browser/mcpMigration.ts` | コントリビューション | MCP設定移行機能の実装 |
| mcpWorkbenchManagementService.ts | `src/vs/workbench/services/mcp/common/mcpWorkbenchManagementService.ts` | サービス | MCPサーバー管理サービス |
| mcpPlatformTypes.ts | `src/vs/platform/mcp/common/mcpPlatformTypes.ts` | 型定義 | MCPサーバー設定の型定義 |
| mcpCommandIds.ts | `src/vs/workbench/contrib/mcp/common/mcpCommandIds.ts` | 定数 | MCPコマンドIDの定義 |
| notification.ts | `src/vs/platform/notification/common/notification.ts` | インターフェース | INotificationServiceの定義 |
| nls.ts | `src/vs/nls.ts` | ユーティリティ | ローカライズ関数の提供 |
