# 通知設計書 41-noConflictMessage

## 概要

本ドキュメントは、VS Codeのマージエディタにおいて、フォーカスされた競合がない状態でトグル操作を行った際に表示されるエラー通知「noConflictMessage」の設計仕様を定義します。

### 本通知の処理概要

マージエディタで競合のトグル操作を試みた際に、現在フォーカスされている競合が存在しない場合にユーザーに対してエラー通知を表示する機能です。

**業務上の目的・背景**：Git等のバージョン管理システムを使用したマージ作業において、ユーザーが競合解決のためにマージエディタを使用する際、競合箇所を選択せずにトグル操作（Input 1/Input 2の選択切り替え）を行おうとした場合があります。このような状況でユーザーに適切なフィードバックを提供し、正しい操作方法を案内することで、スムーズな競合解決作業を支援します。

**通知の送信タイミング**：ユーザーがマージエディタ内で`toggleActiveConflict`メソッドを呼び出した際に、`activeModifiedBaseRange`がundefined（フォーカスされた競合がない状態）の場合に即座に通知が送信されます。

**通知の受信者**：マージエディタを操作している現在のユーザーが通知の受信者となります。画面上のアプリ内通知として表示されます。

**通知内容の概要**：「There is currently no conflict focused that can be toggled.」（現在トグル可能なフォーカスされた競合がありません）というエラーメッセージが表示されます。

**期待されるアクション**：ユーザーはマージエディタ内で競合箇所にカーソルを移動させるか、競合箇所をクリックしてフォーカスを当ててから、再度トグル操作を行うことが期待されます。

## 通知種別

アプリ内通知（エラー通知）

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 同期 |
| 優先度 | 中 |
| リトライ | 無 |

### 送信先決定ロジック

現在マージエディタを操作しているユーザーに対して、INotificationServiceのerrorメソッドを通じてアプリ内通知として表示されます。特定のユーザー選択ロジックは存在せず、操作を行ったユーザーに対して即座に表示されます。

## 通知テンプレート

### アプリ内通知

| 項目 | 内容 |
|-----|------|
| 通知レベル | Error |
| メッセージキー | noConflictMessage |
| 形式 | テキスト |

### 本文テンプレート

```
There is currently no conflict focused that can be toggled.
```

### 添付ファイル

なし

## テンプレート変数

| 変数名 | 説明 | データ取得元 | 必須 |
|--------|------|-------------|-----|
| なし | 固定メッセージのため変数なし | - | - |

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| 画面操作 | toggleActiveConflict呼び出し | activeModifiedBaseRangeがundefined | マージエディタでInput 1/Input 2のトグル操作実行時 |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| activeModifiedBaseRangeが存在 | フォーカスされた競合が存在する場合は通常のトグル処理が実行され、エラー通知は表示されない |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A[toggleActiveConflict呼び出し] --> B{activeModifiedBaseRange取得}
    B -->|undefined| C[エラー通知表示]
    B -->|存在| D[トグル処理実行]
    C --> E[notificationService.error呼び出し]
    E --> F[ユーザーにエラー表示]
    F --> G[終了]
    D --> H[setState実行]
    H --> G
```

## データベース参照・更新仕様

### 参照テーブル一覧

本通知処理においてデータベース参照は発生しません。マージエディタのビューモデル内部状態のみを参照します。

### 更新テーブル一覧

本通知処理においてデータベース更新は発生しません。

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| フォーカス競合なし | activeModifiedBaseRangeがundefined | エラー通知を表示してユーザーに通知 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | なし |
| リトライ間隔 | - |
| リトライ対象エラー | - |

## 配信設定

### レート制限

| 項目 | 内容 |
|-----|------|
| 1分あたり上限 | 制限なし |
| 1日あたり上限 | 制限なし |

### 配信時間帯

制限なし（ユーザー操作に応じて即座に表示）

## セキュリティ考慮事項

本通知は固定メッセージであり、個人情報や機密情報を含まないため、特別なセキュリティ対策は不要です。

## 備考

- 本通知はローカライズ対応しており、`localize`関数を通じて多言語対応が行われています
- メッセージキー：`noConflictMessage`
- 関連コマンド：Accept Input 1、Accept Input 2などのマージエディタ操作コマンド

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

マージエディタで扱う競合範囲（ModifiedBaseRange）の構造を理解することが重要です。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | modifiedBaseRange.ts | `src/vs/workbench/contrib/mergeEditor/browser/model/modifiedBaseRange.ts` | ModifiedBaseRangeクラスの構造、InputNumber型の定義 |
| 1-2 | mergeEditorModel.ts | `src/vs/workbench/contrib/mergeEditor/browser/model/mergeEditorModel.ts` | マージエディタのモデル層の構造 |

**読解のコツ**: TypeScriptのobservable pattern（`IObservable`）が多用されています。derived関数やobservableValue関数の使い方を理解すると読みやすくなります。

#### Step 2: エントリーポイントを理解する

通知が発生するトリガーポイントを特定します。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | viewModel.ts | `src/vs/workbench/contrib/mergeEditor/browser/view/viewModel.ts` | MergeEditorViewModelクラス、toggleActiveConflictメソッド |

**主要処理フロー**:
1. **294行目**: `toggleActiveConflict`メソッドの開始
2. **295行目**: `activeModifiedBaseRange.get()`で現在フォーカスされた競合を取得
3. **296-298行目**: undefinedの場合、`notificationService.error`でエラー通知を表示
4. **300-308行目**: 競合が存在する場合はsetStateでトグル処理を実行

#### Step 3: 通知サービスを理解する

VS Codeの通知システムの仕組みを理解します。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | notification.ts | `src/vs/platform/notification/common/notification.ts` | INotificationServiceインターフェース、Severity enum |
| 3-2 | notificationsToasts.ts | `src/vs/workbench/browser/parts/notifications/notificationsToasts.ts` | 通知のトースト表示実装 |

**主要処理フロー**:
- **14行目**: INotificationServiceの定義
- **430行目**: errorメソッドの定義

### プログラム呼び出し階層図

```
toggleActiveConflict (viewModel.ts:294)
    │
    ├─ activeModifiedBaseRange.get() (viewModel.ts:295)
    │      └─ derived observable evaluation
    │
    └─ [if undefined]
           └─ notificationService.error() (viewModel.ts:297)
                   └─ localize('noConflictMessage', "...")
```

### データフロー図

```
[入力]               [処理]                    [出力]

ユーザー操作     ───▶ toggleActiveConflict    ───▶ 通知サービス
(トグルコマンド)       │                            │
                       ▼                            ▼
                  activeModifiedBaseRange      INotificationHandle
                  チェック                     (エラー通知表示)
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| viewModel.ts | `src/vs/workbench/contrib/mergeEditor/browser/view/viewModel.ts` | ソース | マージエディタのビューモデル、通知発生元 |
| notification.ts | `src/vs/platform/notification/common/notification.ts` | ソース | 通知サービスのインターフェース定義 |
| modifiedBaseRange.ts | `src/vs/workbench/contrib/mergeEditor/browser/model/modifiedBaseRange.ts` | ソース | 競合範囲のモデル定義 |
| mergeEditorModel.ts | `src/vs/workbench/contrib/mergeEditor/browser/model/mergeEditorModel.ts` | ソース | マージエディタのモデル |
| mergeEditor.contribution.ts | `src/vs/workbench/contrib/mergeEditor/browser/mergeEditor.contribution.ts` | ソース | マージエディタの機能登録 |
| notificationsToasts.ts | `src/vs/workbench/browser/parts/notifications/notificationsToasts.ts` | ソース | 通知トースト表示の実装 |
