# 通知設計書 42-remoteTunnel.notification

## 概要

本ドキュメントは、VS Codeのリモートトンネル機能に関連する各種通知の設計仕様を定義します。リモートトンネル機能は、VS Codeインスタンスをリモートからアクセス可能にするための機能であり、接続状態、エラー、拡張機能の推奨など複数の通知パターンが存在します。

### 本通知の処理概要

リモートトンネル機能の状態変化やユーザーアクションに応じて、適切な情報・警告・エラー通知をユーザーに提供する機能です。

**業務上の目的・背景**：リモートワークやマルチデバイス作業が増加する中、VS Codeのリモートトンネル機能を使用することで、ユーザーは任意の場所から自分の開発環境にアクセスできます。この機能の状態をユーザーに適切に通知することで、トンネル接続の成功・失敗・設定変更などの重要な情報を伝え、スムーズなリモート作業を支援します。

**通知の送信タイミング**：以下のイベント時に通知が送信されます：
- トンネル接続成功時
- トンネル接続失敗時
- サービスインストール失敗時（フォールバック動作時）
- リモート拡張機能の推奨時
- プレビュー機能の確認時

**通知の受信者**：リモートトンネル機能を使用しているユーザー、または使用を開始しようとしているユーザーが通知の受信者となります。

**通知内容の概要**：トンネル名、接続URL、設定方法、拡張機能推奨など、リモートトンネル機能に関連する情報が通知されます。

**期待されるアクション**：通知の種類に応じて、クリップボードへのURLコピー、拡張機能のインストール、設定の変更、ログの確認などのアクションが期待されます。

## 通知種別

アプリ内通知（情報通知 / 警告通知 / エラー通知）

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 同期 |
| 優先度 | 通知種別により異なる（情報: OPTIONAL、警告: DEFAULT） |
| リトライ | 無（接続リトライは別途あり） |

### 送信先決定ロジック

現在のVS Codeウィンドウを操作しているユーザーに対して、INotificationServiceを通じてアプリ内通知として表示されます。

## 通知テンプレート

### 通知パターン1: トンネル接続成功

| 項目 | 内容 |
|-----|------|
| 通知レベル | Info |
| メッセージキー | progress.turnOn.final |
| 形式 | Markdown |

#### 本文テンプレート

```
You can now access this machine anywhere via the secure tunnel [{tunnelName}](command:{configureCommand}). To connect via a different machine, use the generated [{domain}]({linkUrl}) link or use the [{extensionName}]({extensionDocUrl}) extension in the desktop or web. You can [configure](command:{configureCommand}) or [turn off](command:{turnOffCommand}) this access via the VS Code Accounts menu.
```

### 通知パターン2: サービスインストール失敗

| 項目 | 内容 |
|-----|------|
| 通知レベル | Warning |
| メッセージキー | remoteTunnel.serviceInstallFailed |
| 形式 | Markdown |

#### 本文テンプレート

```
Installation as a service failed, and we fell back to running the tunnel for this session. See the [error log](command:{showLogCommand}) for details.
```

### 通知パターン3: トンネル接続失敗

| 項目 | 内容 |
|-----|------|
| 通知レベル | Info |
| メッセージキー | progress.turnOn.failed |
| 形式 | テキスト |

#### 本文テンプレート

```
Unable to turn on the remote tunnel access. Check the Remote Tunnel Service log for details.
```

### 通知パターン4: 拡張機能推奨

| 項目 | 内容 |
|-----|------|
| 通知レベル | Info |
| 優先度 | OPTIONAL |
| メッセージキー | recommend.remoteExtension |
| 形式 | テキスト |

#### 本文テンプレート

```
Tunnel '{tunnelName}' is avaiable for remote access. The {extensionName} extension can be used to connect to it.
```

### 添付ファイル

なし

## テンプレート変数

| 変数名 | 説明 | データ取得元 | 必須 |
|--------|------|-------------|-----|
| tunnelName | トンネル名 | connectionInfo.tunnelName | Yes |
| domain | トンネルドメイン | connectionInfo.domain | Yes |
| linkUrl | 接続用URL | connectionInfo.link | Yes |
| extensionName | リモート拡張機能名 | serverConfiguration.extension.friendlyName | Yes |
| extensionDocUrl | 拡張機能ドキュメントURL | ハードコード（https://code.visualstudio.com/docs/remote/tunnels） | Yes |
| configureCommand | 設定コマンドID | RemoteTunnelCommandIds.configure | Yes |
| turnOffCommand | オフコマンドID | RemoteTunnelCommandIds.turnOff | Yes |
| showLogCommand | ログ表示コマンドID | RemoteTunnelCommandIds.showLog | Yes |

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| 画面操作 | Turn on Remote Tunnel Access実行 | 認証成功かつ接続成功 | トンネル接続成功通知 |
| 画面操作 | Turn on Remote Tunnel Access実行 | サービスインストール失敗 | フォールバック警告通知 |
| 画面操作 | Turn on Remote Tunnel Access実行 | 接続失敗 | 接続失敗通知 |
| ストレージ変更 | REMOTE_TUNNEL_USED_STORAGE_KEY変更 | 別マシンでトンネル使用検出 | 拡張機能推奨通知 |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| 拡張機能推奨済み | REMOTE_TUNNEL_EXTENSION_RECOMMENDED_KEYがtrueの場合、拡張機能推奨通知は抑止 |
| 拡張機能インストール済み | リモート拡張機能がすでにインストールされている場合は推奨通知を抑止 |
| 同一トンネル名 | 現在のトンネル名と使用記録のトンネル名が同じ場合は推奨通知を抑止 |
| タイムアウト | 4分以上経過した使用記録は無視 |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A[Turn on Remote Tunnel Access] --> B[認証セッション取得]
    B --> C{認証成功?}
    C -->|No| D[終了]
    C -->|Yes| E[トンネル開始処理]
    E --> F{接続結果}
    F -->|成功| G{サービスインストール失敗?}
    G -->|Yes| H[警告通知表示]
    G -->|No| I[成功通知表示]
    F -->|失敗| J[失敗通知表示]
    H --> K[ストレージに使用記録保存]
    I --> K
    J --> L[ログ表示]
    K --> M[終了]
    L --> M
```

## データベース参照・更新仕様

### 参照テーブル一覧

| ストレージキー | 用途 | 備考 |
|--------------|------|------|
| REMOTE_TUNNEL_USED_STORAGE_KEY | トンネル使用記録 | ApplicationスコープのStorage |
| REMOTE_TUNNEL_EXTENSION_RECOMMENDED_KEY | 拡張機能推奨済みフラグ | ApplicationスコープのStorage |
| REMOTE_TUNNEL_PROMPTED_PREVIEW_STORAGE_KEY | プレビュー通知済みフラグ | ApplicationスコープのStorage |
| REMOTE_TUNNEL_HAS_USED_BEFORE | 過去使用フラグ | ApplicationスコープのStorage |

### 更新テーブル一覧

| ストレージキー | 操作 | 概要 |
|--------------|------|------|
| REMOTE_TUNNEL_USED_STORAGE_KEY | UPDATE | トンネル使用時にホスト名とタイムスタンプを記録 |
| REMOTE_TUNNEL_EXTENSION_RECOMMENDED_KEY | UPDATE | 拡張機能推奨後にtrueを設定 |
| REMOTE_TUNNEL_PROMPTED_PREVIEW_STORAGE_KEY | UPDATE | プレビュー確認後にtrueを設定 |
| REMOTE_TUNNEL_HAS_USED_BEFORE | UPDATE | 初回使用時にtrueを設定 |

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| 認証失敗 | 認証セッション取得失敗 | ログ出力、処理終了 |
| トークン無効 | 認証トークンの期限切れ | セッションを期限切れリストに追加、再認証を促す |
| 接続失敗 | ネットワークエラー等 | 失敗通知表示、ログ確認を促す |
| サービスインストール失敗 | システム権限不足等 | 警告通知表示、セッションモードでフォールバック |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 2回（INVALID_TOKEN_RETRIES） |
| リトライ間隔 | 即時 |
| リトライ対象エラー | トークン無効エラーのみ |

## 配信設定

### レート制限

| 項目 | 内容 |
|-----|------|
| 1分あたり上限 | 制限なし |
| 1日あたり上限 | 制限なし |

### 配信時間帯

制限なし

## セキュリティ考慮事項

- 認証情報（トークン）はメモリ内でのみ保持し、ログに出力しない
- 接続URLはユーザーの明示的なアクションによってのみクリップボードにコピーされる
- トンネル名にはユーザー識別情報が含まれる可能性があるため、ログ出力時は注意が必要

## 備考

- リモートトンネル機能は現在プレビュー段階であり、初回使用時に確認ダイアログが表示される
- 設定キー：`remote.tunnels.access.hostNameOverride`（トンネル名のカスタマイズ）
- 設定キー：`remote.tunnels.access.preventSleep`（スリープ防止）

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

リモートトンネルの状態とセッション情報の構造を理解することが重要です。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | remoteTunnel.ts | `src/vs/platform/remoteTunnel/common/remoteTunnel.ts` | TunnelStatus, TunnelMode, ConnectionInfo型の定義 |
| 1-2 | remoteTunnel.ts | `src/vs/platform/remoteTunnel/common/remoteTunnel.ts` | IRemoteTunnelServiceインターフェース |

**読解のコツ**: TunnelStates namespaceで定義されている各状態（Uninitialized, Connecting, Connected, Disconnected）の遷移を理解することが重要です。

#### Step 2: エントリーポイントを理解する

WorkbenchContributionとして登録されるメインクラスを理解します。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | remoteTunnel.contribution.ts | `src/vs/workbench/contrib/remoteTunnel/electron-browser/remoteTunnel.contribution.ts` | RemoteTunnelWorkbenchContributionクラス |

**主要処理フロー**:
1. **94-131行目**: コンストラクタでの初期化、イベントリスナー登録
2. **133-146行目**: handleTunnelStatusUpdateでの状態変化処理
3. **288-367行目**: startTunnelメソッドでのトンネル開始処理
4. **510-591行目**: turnOnアクションの実装（通知表示を含む）

#### Step 3: 通知パターンを理解する

各通知パターンの実装箇所を確認します。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | remoteTunnel.contribution.ts | `src/vs/workbench/contrib/remoteTunnel/electron-browser/remoteTunnel.contribution.ts` | 558-579行目：接続成功通知 |
| 3-2 | remoteTunnel.contribution.ts | `src/vs/workbench/contrib/remoteTunnel/electron-browser/remoteTunnel.contribution.ts` | 325-336行目：サービスインストール失敗警告 |
| 3-3 | remoteTunnel.contribution.ts | `src/vs/workbench/contrib/remoteTunnel/electron-browser/remoteTunnel.contribution.ts` | 583-588行目：接続失敗通知 |
| 3-4 | remoteTunnel.contribution.ts | `src/vs/workbench/contrib/remoteTunnel/electron-browser/remoteTunnel.contribution.ts` | 189-216行目：拡張機能推奨通知 |

### プログラム呼び出し階層図

```
RemoteTunnelWorkbenchContribution
    │
    ├─ constructor
    │      ├─ remoteTunnelService.onDidChangeTunnelStatus → handleTunnelStatusUpdate
    │      ├─ registerCommands
    │      └─ recommendRemoteExtensionIfNeeded
    │
    ├─ turnOn Action
    │      ├─ getAuthenticationSession
    │      ├─ startTunnel
    │      │      ├─ progressService.withProgress
    │      │      └─ remoteTunnelService.startTunnel
    │      └─ notificationService.notify (成功/失敗)
    │
    └─ recommendRemoteExtensionIfNeeded
           └─ notificationService.notify (拡張機能推奨)
```

### データフロー図

```
[入力]               [処理]                    [出力]

ユーザー操作     ───▶ turnOn Action          ───▶ 認証フロー
(Turn on)              │                            │
                       ▼                            ▼
               getAuthenticationSession      quickPick表示
                       │
                       ▼
               startTunnel
                       │
                       ▼
               remoteTunnelService        ───▶ TunnelStatus
                       │
                       ▼
               progressService            ───▶ 進捗表示
                       │
                       ▼
               notificationService        ───▶ 結果通知
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| remoteTunnel.contribution.ts | `src/vs/workbench/contrib/remoteTunnel/electron-browser/remoteTunnel.contribution.ts` | ソース | メインの通知実装 |
| remoteTunnel.ts | `src/vs/platform/remoteTunnel/common/remoteTunnel.ts` | ソース | インターフェース定義 |
| remoteTunnelService.ts | `src/vs/platform/remoteTunnel/electron-browser/remoteTunnelService.ts` | ソース | サービス実装（ブラウザ） |
| remoteTunnelService.ts | `src/vs/platform/remoteTunnel/node/remoteTunnelService.ts` | ソース | サービス実装（Node） |
| notification.ts | `src/vs/platform/notification/common/notification.ts` | ソース | 通知サービスインターフェース |
| sharedProcessMain.ts | `src/vs/code/electron-utility/sharedProcess/sharedProcessMain.ts` | ソース | 共有プロセスでのサービス登録 |
