# 通知設計書 43-searchView.error

## 概要

本ドキュメントは、VS Codeの検索ビューで発生するエラー通知の設計仕様を定義します。検索操作中に発生した各種エラーをユーザーに通知し、適切な対応を促します。

### 本通知の処理概要

検索ビュー（Search View）での検索実行中に発生するエラーをユーザーに通知する機能です。ファイル検索、テキスト検索、置換操作などで問題が発生した際に、エラーの内容と原因をユーザーに伝えます。

**業務上の目的・背景**：開発作業において検索機能は頻繁に使用される重要な機能です。検索が正常に完了しなかった場合、ユーザーは検索結果が不完全である可能性を認識し、原因を特定して対処する必要があります。このエラー通知により、検索処理の問題を迅速に把握し、適切な対応が可能になります。

**通知の送信タイミング**：検索処理中にエラーが発生した時点で即座に通知が送信されます。具体的には、ファイルシステムエラー、正規表現の構文エラー、メモリ不足、タイムアウトなどが発生した場合です。

**通知の受信者**：検索操作を実行したユーザーが通知の受信者となります。

**通知内容の概要**：エラーの種類と詳細メッセージが表示されます。場合によっては、問題の解決方法やヘルプへのリンクが含まれます。

**期待されるアクション**：エラー内容に応じて、検索クエリの修正、ファイルシステムの確認、設定の変更などのアクションが期待されます。

## 通知種別

アプリ内通知（エラー通知）

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 同期 |
| 優先度 | 中 |
| リトライ | 無 |

### 送信先決定ロジック

検索を実行したユーザーに対して、INotificationServiceを通じてアプリ内通知として表示されます。

## 通知テンプレート

### 検索キャンセル通知

| 項目 | 内容 |
|-----|------|
| 通知レベル | Info |
| メッセージ | Search was canceled before any results could be found |
| 形式 | テキスト |

### 本文テンプレート

```
Search was canceled before any results could be found - {additionalInfo}
```

### 添付ファイル

なし

## テンプレート変数

| 変数名 | 説明 | データ取得元 | 必須 |
|--------|------|-------------|-----|
| additionalInfo | エラーの追加情報 | 検索エンジンからのエラーメッセージ | No |

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| 画面操作 | 検索実行 | 検索がキャンセルされた | 結果が見つかる前にキャンセルされた場合 |
| 画面操作 | 検索実行 | ファイルシステムエラー | ファイルアクセスに問題がある場合 |
| 画面操作 | 検索実行 | 正規表現エラー | 無効な正規表現パターンの場合 |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| 検索キャンセル（ユーザー起因） | ユーザーが明示的にキャンセルした場合はエラーとして扱わない |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A[検索実行] --> B[検索エンジン処理]
    B --> C{処理結果}
    C -->|成功| D[結果表示]
    C -->|エラー| E[エラー情報取得]
    C -->|キャンセル| F{キャンセル理由}
    E --> G[エラー通知表示]
    F -->|ユーザー起因| H[キャンセルメッセージ表示]
    F -->|システム起因| G
    G --> I[終了]
    D --> I
    H --> I
```

## データベース参照・更新仕様

### 参照テーブル一覧

本通知処理においてデータベース参照は発生しません。

### 更新テーブル一覧

本通知処理においてデータベース更新は発生しません。

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| キャンセル | 検索がキャンセルされた | キャンセルメッセージを表示 |
| ファイルシステムエラー | ファイルアクセス失敗 | エラー詳細を通知 |
| 正規表現エラー | 無効なパターン | 入力ボックスにエラー表示 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | なし |
| リトライ間隔 | - |
| リトライ対象エラー | - |

## 配信設定

### レート制限

| 項目 | 内容 |
|-----|------|
| 1分あたり上限 | 制限なし |
| 1日あたり上限 | 制限なし |

### 配信時間帯

制限なし

## セキュリティ考慮事項

- 検索クエリにはセンシティブな情報が含まれる可能性があるため、エラーログへの出力は最小限に抑える
- ファイルパス情報はユーザーに表示されるが、外部に送信されることはない

## 備考

- SEARCH_CANCELLED_MESSAGEとして定数定義されている
- 検索ビューのメッセージエリアにも表示される場合がある

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

検索結果とエラー情報の構造を理解します。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | search.ts | `src/vs/workbench/services/search/common/search.ts` | ISearchComplete, SearchCompletionExitCodeの定義 |

**読解のコツ**: SearchCompletionExitCodeの各値（Normal, NewSearchStarted, Error等）が検索完了状態を表します。

#### Step 2: エントリーポイントを理解する

検索ビューの実装を確認します。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | searchView.ts | `src/vs/workbench/contrib/search/browser/searchView.ts` | SearchViewクラス |

**主要処理フロー**:
1. **125行目**: SEARCH_CANCELLED_MESSAGEの定義
2. **214行目**: notificationServiceの依存性注入
3. 検索実行時のエラーハンドリング

### プログラム呼び出し階層図

```
SearchView
    │
    ├─ onSearchResultsChanged
    │      └─ renderSearchMessage
    │
    └─ handleSearchError
           └─ notificationService.error
```

### データフロー図

```
[入力]               [処理]                    [出力]

検索クエリ       ───▶ 検索エンジン           ───▶ 検索結果
                       │                            │
                       ▼                            ▼
                  エラー発生              ───▶ 通知サービス
                       │
                       ▼
                  renderSearchMessage    ───▶ メッセージエリア
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| searchView.ts | `src/vs/workbench/contrib/search/browser/searchView.ts` | ソース | 検索ビューの実装 |
| searchMessage.ts | `src/vs/workbench/contrib/search/browser/searchMessage.ts` | ソース | 検索メッセージの表示 |
| search.ts | `src/vs/workbench/services/search/common/search.ts` | ソース | 検索サービスのインターフェース |
| notification.ts | `src/vs/platform/notification/common/notification.ts` | ソース | 通知サービス |
