# 通知設計書 44-noViewRegistered

## 概要

本ドキュメントは、VS Codeの拡張機能APIにおいて、存在しないビューIDに対してデータプロバイダーを登録しようとした際に表示されるエラー通知「noViewRegistered」の設計仕様を定義します。

### 本通知の処理概要

拡張機能がTreeViewのデータプロバイダーを登録する際に、指定されたビューIDがシステムに登録されていない場合にエラー通知を表示する機能です。

**業務上の目的・背景**：VS Codeの拡張機能開発において、TreeView APIを使用してカスタムビューを作成することは一般的です。しかし、package.jsonでビューを宣言せずにデータプロバイダーを登録しようとした場合や、ビューIDのタイプミスがあった場合、開発者はなぜビューが表示されないか原因を特定しにくいことがあります。このエラー通知により、開発者は問題を迅速に特定し、修正することができます。

**通知の送信タイミング**：拡張機能が`$registerTreeViewDataProvider`を呼び出した際に、指定されたtreeViewIdに対応するビューがviewsRegistryに登録されていない場合に通知が送信されます。

**通知の受信者**：拡張機能を開発またはデバッグしているユーザー（開発者）が通知の受信者となります。

**通知内容の概要**：「No view is registered with id: {treeViewId}」というエラーメッセージが表示されます。

**期待されるアクション**：開発者はpackage.jsonでビューを正しく宣言しているか確認し、ビューIDが正しいかを検証することが期待されます。

## 通知種別

アプリ内通知（エラー通知）

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 同期 |
| 優先度 | 中 |
| リトライ | 無 |

### 送信先決定ロジック

拡張機能のデータプロバイダー登録を行ったユーザーに対して、INotificationServiceのerrorメソッドを通じてアプリ内通知として表示されます。

## 通知テンプレート

### アプリ内通知

| 項目 | 内容 |
|-----|------|
| 通知レベル | Error |
| メッセージ | 固定文字列 + ビューID |
| 形式 | テキスト |

### 本文テンプレート

```
No view is registered with id: {treeViewId}
```

### 添付ファイル

なし

## テンプレート変数

| 変数名 | 説明 | データ取得元 | 必須 |
|--------|------|-------------|-----|
| treeViewId | 登録しようとしたビューのID | $registerTreeViewDataProviderの引数 | Yes |

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| 拡張機能API呼び出し | $registerTreeViewDataProvider | getTreeView(treeViewId)がundefined | ビューIDが未登録の場合 |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| ビューが登録済み | 指定されたIDのビューが正常に登録されている場合 |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A[$registerTreeViewDataProvider呼び出し] --> B[extensionService.whenInstalledExtensionsRegistered]
    B --> C[getTreeView呼び出し]
    C --> D{viewerが存在?}
    D -->|Yes| E[データプロバイダー設定]
    D -->|No| F[notificationService.error呼び出し]
    E --> G[リスナー登録]
    F --> H[エラー通知表示]
    G --> I[終了]
    H --> I
```

## データベース参照・更新仕様

### 参照テーブル一覧

| レジストリ | 用途 | 備考 |
|----------|------|------|
| IViewsRegistry | ビュー登録情報の参照 | Extensions.viewsRegistryを使用 |

### 更新テーブル一覧

本通知処理においてデータベース更新は発生しません。

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| ビュー未登録 | treeViewIdに対応するビューが存在しない | エラー通知を表示 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | なし |
| リトライ間隔 | - |
| リトライ対象エラー | - |

## 配信設定

### レート制限

| 項目 | 内容 |
|-----|------|
| 1分あたり上限 | 制限なし |
| 1日あたり上限 | 制限なし |

### 配信時間帯

制限なし

## セキュリティ考慮事項

- ビューIDは拡張機能から提供されるため、悪意のある文字列が含まれる可能性がある
- 通知メッセージに直接IDを埋め込んでいるが、HTMLエスケープ等のサニタイズが必要
- 本通知は開発者向けであり、エンドユーザーに表示されることは稀

## 備考

- この通知は主に拡張機能開発時のデバッグ目的で使用される
- package.jsonでのビュー宣言が正しく行われていれば、通常のユーザーがこの通知を見ることはない
- 関連するAPIドキュメント：Tree View API

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

ビュー登録とTreeViewの構造を理解します。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | views.ts | `src/vs/workbench/common/views.ts` | ITreeView, IViewsRegistryインターフェース |
| 1-2 | extHost.protocol.ts | `src/vs/workbench/api/common/extHost.protocol.ts` | MainThreadTreeViewsShapeの定義 |

**読解のコツ**: ITreeViewDescriptorがビューの宣言的な定義を、ITreeViewが実行時のビューインスタンスを表します。

#### Step 2: エントリーポイントを理解する

MainThreadTreeViewsの実装を確認します。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | mainThreadTreeViews.ts | `src/vs/workbench/api/browser/mainThreadTreeViews.ts` | MainThreadTreeViewsクラス |

**主要処理フロー**:
1. **42行目**: `$registerTreeViewDataProvider`メソッドの開始
2. **45行目**: `extensionService.whenInstalledExtensionsRegistered()`で拡張機能登録完了を待機
3. **51行目**: `getTreeView(treeViewId)`でビューを取得
4. **66行目**: ビューが存在しない場合に`notificationService.error`を呼び出し

#### Step 3: ビュー取得メソッドを理解する

getTreeViewメソッドの実装を確認します。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | mainThreadTreeViews.ts | `src/vs/workbench/api/browser/mainThreadTreeViews.ts` | getTreeViewメソッドの実装（ファイル末尾付近） |

### プログラム呼び出し階層図

```
Extension (extHostTreeViews)
    │
    └─ $registerTreeViewDataProvider (mainThreadTreeViews.ts:42)
           │
           ├─ extensionService.whenInstalledExtensionsRegistered()
           │
           ├─ TreeViewDataProvider作成
           │
           ├─ getTreeView(treeViewId)
           │      └─ viewsService.getViewDescriptor() / viewsRegistry
           │
           └─ [if viewer === undefined]
                  └─ notificationService.error('No view is registered with id: ' + treeViewId)
```

### データフロー図

```
[入力]               [処理]                    [出力]

拡張機能API      ───▶ MainThreadTreeViews    ───▶ ビュー登録
(registerTreeView)     │                            │
                       ▼                            ▼
               getTreeView              ───▶ ITreeView or undefined
                       │
                       ▼
               [if undefined]           ───▶ notificationService.error
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| mainThreadTreeViews.ts | `src/vs/workbench/api/browser/mainThreadTreeViews.ts` | ソース | メインスレッド側のTreeView実装、通知発生元 |
| extHostTreeViews.ts | `src/vs/workbench/api/common/extHostTreeViews.ts` | ソース | 拡張機能ホスト側のTreeView実装 |
| views.ts | `src/vs/workbench/common/views.ts` | ソース | ビュー関連のインターフェース定義 |
| extHost.protocol.ts | `src/vs/workbench/api/common/extHost.protocol.ts` | ソース | 拡張機能ホストとメインスレッド間のプロトコル |
| notification.ts | `src/vs/platform/notification/common/notification.ts` | ソース | 通知サービスインターフェース |
