# 通知設計書 45-clipboardService.prompt

## 概要

本ドキュメントは、VS Codeのクリップボード操作に関連するプロンプト通知の設計仕様を定義します。特にブラウザ環境やセキュリティ制約がある環境でのクリップボードアクセス許可要求に関する通知を扱います。

### 本通知の処理概要

クリップボードへの読み取りまたは書き込みアクセスが必要な際に、ユーザーに対して許可を求めるプロンプトを表示する機能です。

**業務上の目的・背景**：VS Codeはデスクトップアプリケーションとしてだけでなく、Web版（vscode.dev）としても提供されています。Webブラウザ環境ではセキュリティ上の理由からクリップボードアクセスには明示的なユーザー許可が必要な場合があります。この通知により、ユーザーはクリップボード操作が必要な理由を理解し、適切な判断を下すことができます。

**通知の送信タイミング**：クリップボードAPIがユーザーの明示的な許可を必要とする場合に通知が送信されます。具体的には、ブラウザのPermissions APIによってクリップボードアクセスが「prompt」状態の場合です。

**通知の受信者**：VS Codeを使用しているユーザーが通知の受信者となります。

**通知内容の概要**：クリップボードへのアクセス許可を求めるメッセージと、許可/拒否のアクションが表示されます。

**期待されるアクション**：ユーザーはクリップボードアクセスを許可するか拒否するかを選択することが期待されます。

## 通知種別

アプリ内プロンプト / ブラウザネイティブの権限ダイアログ

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 同期 |
| 優先度 | 高（ユーザーアクションをブロック） |
| リトライ | 無 |

### 送信先決定ロジック

クリップボード操作を実行しようとしているユーザーに対して表示されます。

## 通知テンプレート

### クリップボードアクセスプロンプト

| 項目 | 内容 |
|-----|------|
| 通知レベル | Info |
| 形式 | プロンプト |

### 本文テンプレート

ブラウザ環境では、ブラウザネイティブの権限ダイアログが表示されます。

```
このサイトがクリップボードへのアクセスを求めています。
```

### 添付ファイル

なし

## テンプレート変数

| 変数名 | 説明 | データ取得元 | 必須 |
|--------|------|-------------|-----|
| なし | ブラウザネイティブダイアログのため変数なし | - | - |

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| 画面操作 | コピー操作（Ctrl+C） | ブラウザで権限が未許可 | クリップボードへの書き込み時 |
| 画面操作 | ペースト操作（Ctrl+V） | ブラウザで権限が未許可 | クリップボードからの読み取り時 |
| 画面操作 | コンテキストメニューからコピー | ブラウザで権限が未許可 | 右クリックメニューからの操作時 |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| デスクトップ環境 | Electronアプリでは権限確認不要 |
| 権限許可済み | すでにユーザーが許可している場合 |
| 権限拒否済み | ユーザーが明示的に拒否した場合（エラーとして処理） |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A[クリップボード操作要求] --> B{プラットフォーム判定}
    B -->|デスクトップ| C[直接操作実行]
    B -->|Web| D[Permissions API確認]
    D --> E{権限状態}
    E -->|granted| C
    E -->|prompt| F[ブラウザ権限ダイアログ表示]
    E -->|denied| G[エラー処理]
    F --> H{ユーザー選択}
    H -->|許可| C
    H -->|拒否| G
    C --> I[操作完了]
    G --> J[エラー通知]
    I --> K[終了]
    J --> K
```

## データベース参照・更新仕様

### 参照テーブル一覧

本通知処理においてデータベース参照は発生しません。

### 更新テーブル一覧

本通知処理においてデータベース更新は発生しません。ブラウザの権限状態はブラウザ自体が管理します。

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| 権限拒否 | ユーザーがアクセスを拒否 | 操作失敗を通知、手動でのコピー/ペーストを案内 |
| API非対応 | 古いブラウザでClipboard APIが使用不可 | フォールバック処理（document.execCommand） |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | なし |
| リトライ間隔 | - |
| リトライ対象エラー | - |

## 配信設定

### レート制限

| 項目 | 内容 |
|-----|------|
| 1分あたり上限 | ブラウザにより制御 |
| 1日あたり上限 | ブラウザにより制御 |

### 配信時間帯

制限なし

## セキュリティ考慮事項

- クリップボードにはパスワードや機密情報が含まれる可能性があるため、アクセス許可は慎重に扱う
- ユーザーの明示的な同意なしにクリップボードを読み取ることはセキュリティリスクとなる
- HTTPS接続が必要（Clipboard APIはセキュアコンテキストでのみ利用可能）

## 備考

- デスクトップ版VS CodeではElectronのAPIを使用するため、この権限プロンプトは通常表示されない
- vscode.dev（Web版）でのみ関連する通知
- findControllerなどのコンポーネントでクリップボードアクセスが使用される

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

クリップボードサービスのインターフェースを理解します。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | clipboardService.ts | `src/vs/platform/clipboard/common/clipboardService.ts` | IClipboardServiceインターフェース |

**読解のコツ**: readText, writeText, readResourcesなどの基本メソッドの定義を確認します。

#### Step 2: ブラウザ実装を理解する

Web版での実装を確認します。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | clipboardService.ts | `src/vs/platform/clipboard/browser/clipboardService.ts` | BrowserClipboardServiceクラス |

**主要処理フロー**:
- navigator.clipboard APIの使用
- Permissions APIによる権限確認
- フォールバック処理

#### Step 3: 関連コンポーネントを理解する

クリップボードを使用するコンポーネントを確認します。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | findController.ts | `src/vs/editor/contrib/find/browser/findController.ts` | 検索ダイアログでのクリップボード使用 |
| 3-2 | notificationsActions.ts | `src/vs/workbench/browser/parts/notifications/notificationsActions.ts` | 通知アクションでのクリップボード使用 |

### プログラム呼び出し階層図

```
User Action (Copy/Paste)
    │
    └─ IClipboardService
           │
           ├─ [Desktop] ElectronClipboardService
           │      └─ electron.clipboard
           │
           └─ [Web] BrowserClipboardService
                  │
                  ├─ navigator.clipboard.writeText()
                  │      └─ Permissions API (prompt)
                  │
                  └─ navigator.clipboard.readText()
                         └─ Permissions API (prompt)
```

### データフロー図

```
[入力]               [処理]                    [出力]

ユーザー操作     ───▶ ClipboardService       ───▶ 権限確認
(Ctrl+C/V)             │                            │
                       ▼                            ▼
               Permissions API           ───▶ ブラウザダイアログ
                       │
                       ▼
               [if granted]              ───▶ クリップボード操作
                       │
                       ▼
               [if denied]               ───▶ エラー通知
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| clipboardService.ts | `src/vs/platform/clipboard/common/clipboardService.ts` | ソース | サービスインターフェース定義 |
| clipboardService.ts | `src/vs/platform/clipboard/browser/clipboardService.ts` | ソース | ブラウザ版実装 |
| clipboardService.ts | `src/vs/platform/clipboard/electron-sandbox/clipboardService.ts` | ソース | Electron版実装 |
| findController.ts | `src/vs/editor/contrib/find/browser/findController.ts` | ソース | クリップボード使用例 |
| notificationsActions.ts | `src/vs/workbench/browser/parts/notifications/notificationsActions.ts` | ソース | 通知アクションでのクリップボード使用 |
