# 通知設計書 46-editorResolver.warning

## 概要

本ドキュメントは、VS Codeのエディタ解決サービスで表示される警告通知の設計仕様を定義します。複数のエディタが同一ファイルタイプに対して登録されている場合や、デフォルトエディタの競合が検出された場合に警告を表示します。

### 本通知の処理概要

特定のファイルタイプに対して複数のエディタが利用可能な場合に、ユーザーにデフォルトエディタの設定を促す通知を表示する機能です。

**業務上の目的・背景**：VS Codeは拡張機能によって様々なカスタムエディタを追加できます。同じファイルタイプに対して複数のエディタが登録されると、どのエディタを使用するかが不明確になります。この通知により、ユーザーは自分の作業スタイルに合わせたデフォルトエディタを設定し、一貫したファイル編集体験を得ることができます。

**通知の送信タイミング**：ファイルを開く際に、複数のエディタが利用可能で、かつデフォルトエディタの設定に競合がある場合に通知が送信されます。

**通知の受信者**：ファイルを開こうとしているユーザーが通知の受信者となります。

**通知内容の概要**：利用可能なエディタの一覧と、デフォルトエディタを設定するためのアクションが表示されます。

**期待されるアクション**：ユーザーは通知のアクションボタンを使用して、デフォルトエディタを設定することが期待されます。

## 通知種別

アプリ内プロンプト

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 同期 |
| 優先度 | 中 |
| リトライ | 無 |

### 送信先決定ロジック

ファイルを開こうとしているユーザーに対して、INotificationServiceのpromptメソッドを通じて表示されます。

## 通知テンプレート

### デフォルトエディタ競合警告

| 項目 | 内容 |
|-----|------|
| 通知レベル | Warning |
| メッセージキー | conflictingDefaults |
| 形式 | テキスト |

### 本文テンプレート

```
There are multiple editors available for '{fileName}'. Would you like to set a default editor for this file type?
```

### アクションボタン

| ボタン | 説明 |
|-------|------|
| Configure Default | デフォルトエディタ設定を開く |
| Don't Ask Again | このファイルタイプについて今後尋ねない |

### 添付ファイル

なし

## テンプレート変数

| 変数名 | 説明 | データ取得元 | 必須 |
|--------|------|-------------|-----|
| fileName | 開こうとしているファイル名 | EditorResourceAccessor.getCanonicalUri | Yes |
| editorLabel | 現在選択されているエディタのラベル | selectedEditor.editorInfo.label | Yes |

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| 画面操作 | ファイルを開く | conflictingDefaultがtrue | 複数のデフォルトエディタが競合 |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| 単一エディタのみ | 利用可能なエディタが1つしかない場合 |
| 明示的なオーバーライド | ユーザーが明示的にエディタを指定した場合 |
| 「今後尋ねない」選択済み | ユーザーが以前に設定を行った場合 |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A[ファイルを開く] --> B[エディタ解決処理]
    B --> C[getEditor呼び出し]
    C --> D{conflictingDefault?}
    D -->|No| E[エディタで開く]
    D -->|Yes| F[doHandleConflictingDefaults呼び出し]
    F --> G[プロンプト表示]
    G --> H{ユーザー選択}
    H -->|Configure| I[設定ダイアログ表示]
    H -->|Don't Ask| J[ストレージに記録]
    H -->|閉じる| E
    I --> E
    J --> E
    E --> K[終了]
```

## データベース参照・更新仕様

### 参照テーブル一覧

| ストレージキー | 用途 | 備考 |
|--------------|------|------|
| editorOverrideService.conflictingDefaults | 競合通知の抑止記録 | ProfileスコープのStorage |
| editorOverrideService.cache | エディタキャッシュ | ProfileスコープのStorage |

### 更新テーブル一覧

| ストレージキー | 操作 | 概要 |
|--------------|------|------|
| editorOverrideService.conflictingDefaults | UPDATE | 「今後尋ねない」選択時に更新 |

### 設定更新

| 設定キー | 用途 |
|---------|------|
| workbench.editorAssociations | ファイルパターンとエディタIDのマッピング |

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| エディタ解決失敗 | 対応するエディタが見つからない | デフォルトエディタで開く |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | なし |
| リトライ間隔 | - |
| リトライ対象エラー | - |

## 配信設定

### レート制限

| 項目 | 内容 |
|-----|------|
| 1分あたり上限 | 制限なし |
| 1日あたり上限 | 制限なし |

### 配信時間帯

制限なし

## セキュリティ考慮事項

- エディタの選択はユーザーのローカル設定に保存され、外部に送信されない
- 拡張機能から登録されたカスタムエディタの安全性はユーザーの責任で判断する必要がある

## 備考

- 設定ファイル: settings.json
- 設定キー: `workbench.editorAssociations`
- 例: `"*.md": "vscode.markdown.preview.editor"`

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

エディタ解決サービスのインターフェースと登録エディタの構造を理解します。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | editorResolverService.ts | `src/vs/workbench/services/editor/common/editorResolverService.ts` | IEditorResolverServiceインターフェース、RegisteredEditorInfo |
| 1-2 | editor.ts | `src/vs/workbench/common/editor.ts` | EditorAssociation、EditorAssociations型 |

**読解のコツ**: RegisteredEditorPriority（builtin, default, option, exclusive）の優先度の意味を理解することが重要です。

#### Step 2: エントリーポイントを理解する

エディタ解決サービスの実装を確認します。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | editorResolverService.ts | `src/vs/workbench/services/editor/browser/editorResolverService.ts` | EditorResolverServiceクラス |

**主要処理フロー**:
1. **97-202行目**: resolveEditorメソッド - エディタ解決のメインロジック
2. **150行目**: getEditorの呼び出しでconflictingDefaultフラグを取得
3. **190-193行目**: conflictingDefaultがtrueの場合、doHandleConflictingDefaultsを呼び出し
4. **398行目以降**: getEditorメソッドで競合検出

#### Step 3: 競合処理を理解する

doHandleConflictingDefaultsメソッドの実装を確認します。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | editorResolverService.ts | `src/vs/workbench/services/editor/browser/editorResolverService.ts` | doHandleConflictingDefaultsメソッド |

### プログラム呼び出し階層図

```
IEditorService.openEditor
    │
    └─ EditorResolverService.resolveEditor (97行目)
           │
           ├─ resolveUntypedInputAndGroup
           │
           ├─ getEditor (398行目)
           │      └─ findMatchingEditor
           │             └─ 優先度比較、競合検出
           │
           └─ [if conflictingDefault]
                  └─ doHandleConflictingDefaults
                         │
                         ├─ notificationService.prompt
                         │
                         └─ updateUserAssociations (設定更新)
```

### データフロー図

```
[入力]               [処理]                    [出力]

ファイルURI      ───▶ resolveEditor          ───▶ エディタ入力
                       │                            │
                       ▼                            ▼
               getEditor                     ───▶ RegisteredEditor
                       │                            + conflictingDefault
                       ▼
               [if conflictingDefault]       ───▶ プロンプト表示
                       │
                       ▼
               updateUserAssociations        ───▶ settings.json更新
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| editorResolverService.ts | `src/vs/workbench/services/editor/browser/editorResolverService.ts` | ソース | エディタ解決サービスの実装 |
| editorResolverService.ts | `src/vs/workbench/services/editor/common/editorResolverService.ts` | ソース | インターフェース定義 |
| editor.ts | `src/vs/workbench/common/editor.ts` | ソース | エディタ関連の共通型定義 |
| notification.ts | `src/vs/platform/notification/common/notification.ts` | ソース | 通知サービスインターフェース |
| editorService.ts | `src/vs/workbench/services/editor/browser/editorService.ts` | ソース | エディタサービスの実装 |
