# 通知設計書 47-secretStorage.error

## 概要

本ドキュメントは、VS Codeのシークレットストレージサービスで発生するエラー通知の設計仕様を定義します。OSのキーチェーン/キーリングへのアクセス問題が発生した際にユーザーに通知します。

### 本通知の処理概要

シークレット（認証トークン、APIキーなど）の保存・取得時にOSのセキュアストレージ（キーチェーン/キーリング）へのアクセスに問題が発生した場合に、エラーを通知し、トラブルシューティングガイドや代替手段を提示する機能です。

**業務上の目的・背景**：VS Codeは認証情報やAPIキーなどの機密情報をOSのセキュアストレージに保存します。Linux環境では特に、gnome-keyringやkwalletなどのキーリングサービスが正しく設定されていない場合にアクセス問題が発生することがあります。この通知により、ユーザーは問題を認識し、セキュリティを維持しながら解決策を見つけることができます。

**通知の送信タイミング**：シークレットの保存（set）操作を行った際に、OSのキーリングが利用できない状態が検出された場合に通知が送信されます。

**通知の受信者**：VS Codeを使用し、シークレットストレージを利用する操作（認証、拡張機能の設定など）を行ったユーザーが通知の受信者となります。

**通知内容の概要**：キーリングが利用できない旨のエラーメッセージと、トラブルシューティングガイドへのリンク、代替手段（弱い暗号化）のオプションが表示されます。

**期待されるアクション**：ユーザーはトラブルシューティングガイドを参照してキーリングを設定するか、または弱い暗号化を使用する代替手段を選択することが期待されます。

## 通知種別

アプリ内通知（エラー通知 / プロンプト）

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 同期 |
| 優先度 | 高 |
| リトライ | 無 |

### 送信先決定ロジック

シークレット保存操作を行ったユーザーに対して、INotificationServiceまたはIDialogServiceを通じて通知されます。

## 通知テンプレート

### 通知パターン1: キーリング利用不可（非Linux）

| 項目 | 内容 |
|-----|------|
| 通知レベル | Error |
| メッセージキー | encryptionNotAvailableJustTroubleshootingGuide |
| 形式 | テキスト |

#### 本文テンプレート

```
An OS keyring couldn't be identified for storing the encryption related data in your current desktop environment.
```

### 通知パターン2: キーリング利用不可（Linux - basic text）

| 項目 | 内容 |
|-----|------|
| 通知レベル | Error |
| 形式 | ダイアログ |

#### 本文テンプレート

```
An OS keyring couldn't be identified for storing the encryption related data in your current desktop environment.

Open the troubleshooting guide to address this or you can use weaker encryption that doesn't use the OS keyring.
```

### 通知パターン3: GNOME環境での警告

| 項目 | 内容 |
|-----|------|
| 通知レベル | Error |
| メッセージキー | isGnome |
| 形式 | プロンプト |

#### 本文テンプレート

```
You're running in a GNOME environment but the OS keyring is not available for encryption. Ensure you have gnome-keyring or another libsecret compatible implementation installed and running.
```

### 通知パターン4: KDE環境での警告

| 項目 | 内容 |
|-----|------|
| 通知レベル | Error |
| メッセージキー | isKwallet |
| 形式 | プロンプト |

#### 本文テンプレート

```
You're running in a KDE environment but the OS keyring is not available for encryption. Ensure you have kwallet running.
```

### アクションボタン

| ボタン | 説明 |
|-------|------|
| Open troubleshooting guide | トラブルシューティングガイドを開く |
| Use weaker encryption | 弱い暗号化を使用（Linux basicテキストモードの場合のみ） |

### 添付ファイル

なし

## テンプレート変数

| 変数名 | 説明 | データ取得元 | 必須 |
|--------|------|-------------|-----|
| なし | 環境に応じた固定メッセージ | - | - |

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| API呼び出し | secretStorageService.set | type !== 'persisted' && !useInMemorySecretStorage | キーリングが利用不可の場合 |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| インメモリモード | --use-inmemory-secretstorageフラグが設定されている場合 |
| 永続化成功 | type === 'persisted'の場合（キーリングが正常に動作） |
| 一度通知済み | createSingleCallFunctionにより一度のみ通知 |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A[secretStorage.set呼び出し] --> B[resolvedStorageService待機]
    B --> C{type === 'persisted'?}
    C -->|Yes| D[通常の保存処理]
    C -->|No| E{useInMemorySecretStorage?}
    E -->|Yes| D
    E -->|No| F[notifyOfNoEncryptionOnce呼び出し]
    F --> G{isLinux?}
    G -->|No| H[基本エラー通知表示]
    G -->|Yes| I[getKeyStorageProvider呼び出し]
    I --> J{provider種別}
    J -->|basicText| K[ダイアログ表示（弱い暗号化オプション付き）]
    J -->|gnome| L[GNOME警告通知]
    J -->|kwallet| M[KDE警告通知]
    K --> N{ユーザー選択}
    N -->|Use weaker encryption| O[setUsePlainTextEncryption]
    N -->|Troubleshooting guide| P[URLを開く]
    O --> Q[設定ファイル更新]
    Q --> R[reinitialize]
    H --> S[終了]
    L --> S
    M --> S
    P --> S
    R --> S
    D --> S
```

## データベース参照・更新仕様

### 参照テーブル一覧

| サービス | 用途 | 備考 |
|---------|------|------|
| IEncryptionService | キーリングプロバイダーの取得 | getKeyStorageProvider() |
| IStorageService | シークレットの保存先 | フォールバック用 |

### 更新テーブル一覧

| ファイル | 操作 | 概要 |
|---------|------|------|
| argv.json | UPDATE | password-store設定の更新 |

### 設定更新

| 設定パス | 値 | 用途 |
|---------|-----|------|
| password-store | basic | 弱い暗号化を使用する設定 |

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| キーリング利用不可 | OSのキーリングサービスが動作していない | トラブルシューティングガイド案内、または弱い暗号化の使用 |
| 設定更新失敗 | argv.jsonの書き込み失敗 | エラーログ出力 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | なし |
| リトライ間隔 | - |
| リトライ対象エラー | - |

## 配信設定

### レート制限

| 項目 | 内容 |
|-----|------|
| 1分あたり上限 | 1回（createSingleCallFunctionにより制御） |
| 1日あたり上限 | 1回（セッションごとに1回のみ） |

### 配信時間帯

制限なし

## セキュリティ考慮事項

- シークレットは可能な限りOSのセキュアストレージに保存すべき
- 弱い暗号化（basic text）を選択した場合、シークレットは通常のストレージに保存され、セキュリティリスクが高まる
- トラブルシューティングガイドのURLは公式ドキュメント（go.microsoft.com）を使用

## 備考

- トラブルシューティングガイドURL: https://go.microsoft.com/fwlink/?linkid=2239490
- Linux環境で特に発生しやすい問題
- gnome-keyringまたはkwalletの設定が必要
- コマンドラインオプション: --password-store=basic で弱い暗号化を強制

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

シークレットストレージサービスのインターフェースを理解します。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | secrets.ts | `src/vs/platform/secrets/common/secrets.ts` | ISecretStorageService, BaseSecretStorageService |
| 1-2 | encryptionService.ts | `src/vs/platform/encryption/common/encryptionService.ts` | IEncryptionService, KnownStorageProvider |

**読解のコツ**: typeプロパティ（'persisted' | 'in-memory' | 'unknown'）がストレージの状態を表します。

#### Step 2: エントリーポイントを理解する

Electron版のシークレットストレージ実装を確認します。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | secretStorageService.ts | `src/vs/workbench/services/secrets/electron-browser/secretStorageService.ts` | NativeSecretStorageServiceクラス |

**主要処理フロー**:
1. **41-53行目**: setメソッドのオーバーライド、キーリング利用不可の検出
2. **55行目**: notifyOfNoEncryptionOnce - シングルコールパターン
3. **56-102行目**: notifyOfNoEncryption - 実際の通知ロジック

#### Step 3: 環境検出を理解する

プラットフォーム固有の検出ロジックを確認します。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | encryptionService.ts | `src/vs/platform/encryption/common/encryptionService.ts` | isGnome, isKwallet関数 |

### プログラム呼び出し階層図

```
Extension / Auth Service
    │
    └─ ISecretStorageService.set
           │
           └─ NativeSecretStorageService.set (41行目)
                  │
                  ├─ this._sequencer.queue
                  │      └─ resolvedStorageService待機
                  │
                  └─ [if type !== 'persisted']
                         └─ notifyOfNoEncryptionOnce (55行目)
                                │
                                └─ notifyOfNoEncryption (56行目)
                                       │
                                       ├─ [!isLinux] notificationService.prompt
                                       │
                                       └─ [isLinux]
                                              ├─ getKeyStorageProvider
                                              │
                                              ├─ [basicText] dialogService.prompt
                                              │      └─ setUsePlainTextEncryption
                                              │
                                              └─ [gnome/kwallet] notificationService.prompt
```

### データフロー図

```
[入力]               [処理]                    [出力]

シークレット保存  ───▶ NativeSecretStorageService ───▶ キーリング
要求                   │                                 │
                       ▼                                 ▼
               type確認                        [if failed]
                       │
                       ▼
               notifyOfNoEncryption      ───▶ エラー通知
                       │
                       ▼
               [if Use weaker encryption]
                       │
                       ▼
               argv.json更新             ───▶ 設定変更
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| secretStorageService.ts | `src/vs/workbench/services/secrets/electron-browser/secretStorageService.ts` | ソース | Electron版シークレットストレージ実装 |
| secretStorageService.ts | `src/vs/workbench/services/secrets/browser/secretStorageService.ts` | ソース | ブラウザ版シークレットストレージ実装 |
| secrets.ts | `src/vs/platform/secrets/common/secrets.ts` | ソース | 共通インターフェース定義 |
| encryptionService.ts | `src/vs/platform/encryption/common/encryptionService.ts` | ソース | 暗号化サービス |
| notification.ts | `src/vs/platform/notification/common/notification.ts` | ソース | 通知サービスインターフェース |
| dialogs.ts | `src/vs/platform/dialogs/common/dialogs.ts` | ソース | ダイアログサービスインターフェース |
