# 通知設計書 48-configurationEditing.error

## 概要

本ドキュメントは、VS Codeの構成編集サービスで発生するエラー通知の設計仕様を定義します。設定ファイル（settings.json、tasks.json、launch.json等）への書き込み時に発生する各種エラーをユーザーに通知します。

### 本通知の処理概要

VS Codeの設定やタスク、デバッグ構成などをファイルに保存する際に発生するエラーを、ユーザーに適切に通知し、問題の解決方法を提示する機能です。

**業務上の目的・背景**：VS Codeでは設定がJSONファイル（settings.json）に保存されます。このファイルが破損している場合、書き込み権限がない場合、または設定キーが無効な場合など、様々な理由で設定の保存が失敗することがあります。この通知により、ユーザーは問題を認識し、設定ファイルを修正することで正常な状態に復旧できます。

**通知の送信タイミング**：構成編集サービス（ConfigurationEditing）のwriteConfigurationメソッドでエラーが発生した際に通知が送信されます。

**通知の受信者**：設定変更を行おうとしたユーザーが通知の受信者となります。

**通知内容の概要**：エラーの種類に応じたメッセージと、設定ファイルを開くためのアクションボタンが表示されます。

**期待されるアクション**：ユーザーは設定ファイルを開いてエラーを修正するか、設定を保存してリトライすることが期待されます。

## 通知種別

アプリ内通知（エラープロンプト）

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 同期 |
| 優先度 | 高 |
| リトライ | 一部エラーでリトライ可能 |

### 送信先決定ロジック

設定変更を行ったユーザーに対して、INotificationServiceのpromptメソッドを通じて通知されます。

## 通知テンプレート

### 通知パターン1: 無効な構成ファイル

| 項目 | 内容 |
|-----|------|
| 通知レベル | Error |
| メッセージキー | errorInvalidConfiguration |
| 形式 | プロンプト |

#### 本文テンプレート（ターゲット別）

**ユーザー設定**:
```
Unable to write into user settings. Please open the user settings to correct errors/warnings in it and try again.
```

**リモートユーザー設定**:
```
Unable to write into remote user settings. Please open the remote user settings to correct errors/warnings in it and try again.
```

**ワークスペース設定**:
```
Unable to write into workspace settings. Please open the workspace settings to correct errors/warnings in the file and try again.
```

**フォルダ設定**:
```
Unable to write to Folder Settings because of errors/warnings in the file. Please open the file ('{folderName}') to correct errors/warnings in the file and try again.
```

### 通知パターン2: 設定ファイルがダーティ状態

| 項目 | 内容 |
|-----|------|
| 通知レベル | Error |
| メッセージキー | errorConfigurationFileDirty |
| 形式 | プロンプト |

#### アクションボタン

| ボタン | 説明 |
|-------|------|
| Save and Retry | ファイルを保存してリトライ |
| Open Settings | 設定を開く |
| Open Tasks Configuration | タスク設定を開く（タスク設定の場合） |
| Open Launch Configuration | 起動設定を開く（launch.jsonの場合） |

### 通知パターン3: 未知のキー

| 項目 | 内容 |
|-----|------|
| 通知レベル | Error |
| メッセージキー | errorUnknownKey |
| 形式 | テキスト |

#### 本文テンプレート

```
Unable to write to {target} because {key} is not a registered configuration.
```

### 通知パターン4: 無効なスコープ

| 項目 | 内容 |
|-----|------|
| 通知レベル | Error |
| 形式 | テキスト |

#### 本文テンプレート（例）

**アプリケーションスコープ**:
```
Unable to write {key} to Workspace Settings. This setting can be written only into User settings.
```

**マシンスコープ**:
```
Unable to write {key} to Workspace Settings. This setting can be written only into User settings.
```

### 通知パターン5: ワークスペースが開かれていない

| 項目 | 内容 |
|-----|------|
| 通知レベル | Error |
| メッセージキー | errorNoWorkspaceOpened |
| 形式 | テキスト |

#### 本文テンプレート

```
Unable to write to {target} because no workspace is opened. Please open a workspace first and try again.
```

### 添付ファイル

なし

## テンプレート変数

| 変数名 | 説明 | データ取得元 | 必須 |
|--------|------|-------------|-----|
| target | 設定ターゲット名（User Settings/Workspace Settings等） | stringifyTarget() | Yes |
| key | 設定キー | operation.key | Yes |
| folderName | フォルダ名 | workspaceFolder.name | No |

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| 設定変更 | writeConfiguration | JSONパースエラー | 構成ファイルに構文エラー |
| 設定変更 | writeConfiguration | ファイルがダーティ | 未保存の変更がある |
| 設定変更 | writeConfiguration | ファイルが更新済み | ディスク上のファイルが変更された |
| 設定変更 | writeConfiguration | 未知のキー | 登録されていない設定キー |
| 設定変更 | writeConfiguration | 無効なスコープ | 設定のスコープが不適切 |
| 設定変更 | writeConfiguration | ポリシー設定 | ポリシーで管理されている設定 |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| donotNotifyError: true | オプションでエラー通知を抑制 |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A[writeConfiguration呼び出し] --> B[queue処理]
    B --> C[doWriteConfiguration]
    C --> D[validate]
    D --> E{バリデーション結果}
    E -->|成功| F[updateConfiguration]
    E -->|失敗| G[ConfigurationEditingError]
    F --> H{更新結果}
    H -->|成功| I[save]
    H -->|失敗| G
    I --> J{保存結果}
    J -->|成功| K[終了]
    J -->|失敗| G
    G --> L{donotNotifyError?}
    L -->|true| M[エラーをスロー]
    L -->|false| N[onError]
    N --> O[エラー種別判定]
    O -->|INVALID_CONFIGURATION| P[onInvalidConfigurationError]
    O -->|FILE_DIRTY| Q[onConfigurationFileDirtyError]
    O -->|FILE_MODIFIED_SINCE| R[リトライ]
    O -->|その他| S[notificationService.error]
    P --> T[プロンプト表示]
    Q --> T
    R --> C
    S --> K
    T --> K
```

## データベース参照・更新仕様

### 参照テーブル一覧

| レジストリ/サービス | 用途 | 備考 |
|-------------------|------|------|
| IConfigurationRegistry | 設定キーの登録確認 | ConfigurationExtensions |
| ITextFileService | ファイルのダーティ状態確認 | isDirty() |
| ITextModelService | テキストモデルの取得 | resolveModelReference() |

### 更新テーブル一覧

| ファイル | 操作 | 概要 |
|---------|------|------|
| settings.json | UPDATE | ユーザー/ワークスペース設定の更新 |
| tasks.json | UPDATE | タスク設定の更新 |
| launch.json | UPDATE | デバッグ設定の更新 |
| mcp.json | UPDATE | MCP設定の更新 |

## エラー処理

### エラーケース一覧

| エラーコード | 発生条件 | 対処方法 |
|------------|---------|---------|
| ERROR_UNKNOWN_KEY | 未登録の設定キー | エラーメッセージを表示 |
| ERROR_INVALID_WORKSPACE_CONFIGURATION_APPLICATION | アプリケーションスコープ設定をワークスペースに書き込み | エラーメッセージを表示 |
| ERROR_INVALID_WORKSPACE_CONFIGURATION_MACHINE | マシンスコープ設定をワークスペースに書き込み | エラーメッセージを表示 |
| ERROR_INVALID_FOLDER_CONFIGURATION | フォルダスコープ外の設定をフォルダに書き込み | エラーメッセージを表示 |
| ERROR_INVALID_USER_TARGET | グローバルスコープ外の設定をユーザー設定に書き込み | エラーメッセージを表示 |
| ERROR_INVALID_WORKSPACE_TARGET | ワークスペーススコープ外の設定をワークスペースに書き込み | エラーメッセージを表示 |
| ERROR_INVALID_FOLDER_TARGET | フォルダ設定でリソースが指定されていない | エラーメッセージを表示 |
| ERROR_INVALID_RESOURCE_LANGUAGE_CONFIGURATION | リソース言語設定の不正使用 | エラーメッセージを表示 |
| ERROR_NO_WORKSPACE_OPENED | ワークスペースが開かれていない | エラーメッセージを表示 |
| ERROR_CONFIGURATION_FILE_DIRTY | ファイルがダーティ状態 | 保存してリトライを提案 |
| ERROR_CONFIGURATION_FILE_MODIFIED_SINCE | ディスク上のファイルが変更された | 自動でリトライ |
| ERROR_INVALID_CONFIGURATION | JSON構文エラー | 設定ファイルを開くことを提案 |
| ERROR_POLICY_CONFIGURATION | ポリシーで管理されている | エラーメッセージを表示 |
| ERROR_INTERNAL | 内部エラー | エラーメッセージを表示 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 1回（FILE_MODIFIED_SINCEの場合） |
| リトライ間隔 | 即時 |
| リトライ対象エラー | ERROR_CONFIGURATION_FILE_MODIFIED_SINCE |

## 配信設定

### レート制限

| 項目 | 内容 |
|-----|------|
| 1分あたり上限 | 制限なし |
| 1日あたり上限 | 制限なし |

### 配信時間帯

制限なし

## セキュリティ考慮事項

- 設定ファイルのパスがエラーメッセージに含まれる可能性がある
- ポリシー設定はシステム管理者によって制御されており、ユーザーは変更できない

## 備考

- Queue（非同期キュー）を使用して設定の書き込みを順序制御
- JSON編集にはjsonEdit.tsのsetPropertyを使用
- エラーコードはConfigurationEditingErrorCodeで定義

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

構成編集のエラーコードと操作構造を理解します。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | configurationEditing.ts | `src/vs/workbench/services/configuration/common/configurationEditing.ts` | ConfigurationEditingErrorCode enum |
| 1-2 | configurationEditing.ts | `src/vs/workbench/services/configuration/common/configurationEditing.ts` | IConfigurationEditOperation interface |

**読解のコツ**: ConfigurationEditingErrorCodeの各値と、それぞれが発生する条件を理解することが重要です。

#### Step 2: エントリーポイントを理解する

ConfigurationEditingクラスの実装を確認します。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | configurationEditing.ts | `src/vs/workbench/services/configuration/common/configurationEditing.ts` | ConfigurationEditingクラス |

**主要処理フロー**:
1. **163-176行目**: writeConfigurationメソッド - キュー処理、エラーハンドリング
2. **178-188行目**: doWriteConfiguration - 実際の書き込み処理
3. **264-277行目**: onError - エラーハンドリングの分岐
4. **279-298行目**: onInvalidConfigurationError - JSON構文エラーの処理
5. **301-331行目**: onConfigurationFileDirtyError - ダーティファイルの処理
6. **365-411行目**: toErrorMessage - エラーメッセージの生成

#### Step 3: エラーメッセージを理解する

各エラーコードに対応するメッセージを確認します。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | configurationEditing.ts | `src/vs/workbench/services/configuration/common/configurationEditing.ts` | toErrorMessageメソッド |

### プログラム呼び出し階層図

```
IConfigurationService.updateValue (間接的)
    │
    └─ ConfigurationEditing.writeConfiguration (163行目)
           │
           ├─ queue.queue (非同期キュー)
           │
           └─ doWriteConfiguration (178行目)
                  │
                  ├─ validate (バリデーション)
                  │
                  ├─ resolveModelReference
                  │
                  ├─ updateConfiguration
                  │
                  └─ save
                         │
                         └─ [on error] onError (264行目)
                                │
                                ├─ onInvalidConfigurationError
                                │      └─ notificationService.prompt
                                │
                                ├─ onConfigurationFileDirtyError
                                │      └─ notificationService.prompt
                                │
                                └─ notificationService.error
```

### データフロー図

```
[入力]               [処理]                    [出力]

設定変更要求     ───▶ writeConfiguration      ───▶ キュー追加
                       │                            │
                       ▼                            ▼
               validate                      ───▶ バリデーション結果
                       │
                       ▼
               resolveModelReference         ───▶ テキストモデル
                       │
                       ▼
               updateConfiguration           ───▶ 編集操作
                       │
                       ▼
               save                          ───▶ ファイル保存
                       │
                       ▼
               [on error] onError            ───▶ エラー通知
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| configurationEditing.ts | `src/vs/workbench/services/configuration/common/configurationEditing.ts` | ソース | 構成編集サービスの実装 |
| configuration.ts | `src/vs/workbench/services/configuration/common/configuration.ts` | ソース | 構成サービスの定数・インターフェース |
| configurationRegistry.ts | `src/vs/platform/configuration/common/configurationRegistry.ts` | ソース | 設定レジストリ |
| notification.ts | `src/vs/platform/notification/common/notification.ts` | ソース | 通知サービスインターフェース |
| textfiles.ts | `src/vs/workbench/services/textfile/common/textfiles.ts` | ソース | テキストファイルサービス |
| jsonEdit.ts | `src/vs/base/common/jsonEdit.ts` | ソース | JSON編集ユーティリティ |
