# 通知設計書 49-workspace.error

## 概要

本ドキュメントは、VS Codeのワークスペース編集サービスで発生するエラー通知の設計仕様を定義します。ワークスペースフォルダの追加・削除、ワークスペースファイルの保存時に発生するエラーをユーザーに通知します。

### 本通知の処理概要

ワークスペースの操作（フォルダの追加/削除、ワークスペースの保存）で発生するエラーを、ユーザーに適切に通知し、問題の解決方法を提示する機能です。

**業務上の目的・背景**：VS Codeではマルチルートワークスペース機能により、複数のフォルダを1つのワークスペースとして管理できます。ワークスペースファイル（.code-workspace）の編集中にエラーが発生した場合、ユーザーはワークスペースの状態を正しく維持するためにエラーを認識し対処する必要があります。

**通知の送信タイミング**：ワークスペース編集サービス（AbstractWorkspaceEditingService）でフォルダの追加/削除、ワークスペースの保存時にエラーが発生した際に通知が送信されます。

**通知の受信者**：ワークスペース操作を行ったユーザーが通知の受信者となります。

**通知内容の概要**：エラーの内容と、ワークスペース設定ファイルを開くためのアクションボタンが表示されます。

**期待されるアクション**：ユーザーはワークスペース設定ファイルを開いてエラーを修正することが期待されます。

## 通知種別

アプリ内通知（エラープロンプト）

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 同期 |
| 優先度 | 高 |
| リトライ | 無 |

### 送信先決定ロジック

ワークスペース操作を行ったユーザーに対して、INotificationServiceのpromptメソッドを通じて通知されます。

## 通知テンプレート

### 通知パターン1: 無効なワークスペース構成ファイル

| 項目 | 内容 |
|-----|------|
| 通知レベル | Error |
| メッセージキー | errorInvalidTaskConfiguration |
| 形式 | プロンプト |

#### 本文テンプレート

```
Unable to write into workspace configuration file. Please open the file to correct errors/warnings in it and try again.
```

### アクションボタン

| ボタン | 説明 |
|-------|------|
| Open Workspace Configuration | ワークスペース設定ファイルを開く |

### 添付ファイル

なし

## テンプレート変数

| 変数名 | 説明 | データ取得元 | 必須 |
|--------|------|-------------|-----|
| なし | 固定メッセージ | - | - |

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| ワークスペース操作 | addFolders | JSONEditingErrorCode.ERROR_INVALID_FILE | フォルダ追加時のファイルエラー |
| ワークスペース操作 | removeFolders | JSONEditingErrorCode.ERROR_INVALID_FILE | フォルダ削除時のファイルエラー |
| ワークスペース操作 | updateFolders | JSONEditingErrorCode.ERROR_INVALID_FILE | フォルダ更新時のファイルエラー |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| donotNotifyError: true | オプションでエラー通知を抑制 |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A[ワークスペース操作要求] --> B{操作種別}
    B -->|addFolders| C[doAddFolders]
    B -->|removeFolders| D[removeFolders]
    B -->|updateFolders| E[doUpdateFolders]
    C --> F[contextService.addFolders]
    D --> G[contextService.removeFolders]
    E --> H[contextService.updateFolders]
    F --> I{結果}
    G --> I
    H --> I
    I -->|成功| J[終了]
    I -->|エラー| K{donotNotifyError?}
    K -->|true| L[エラーをスロー]
    K -->|false| M[handleWorkspaceConfigurationEditingError]
    M --> N{エラーコード}
    N -->|ERROR_INVALID_FILE| O[onInvalidWorkspaceConfigurationFileError]
    N -->|その他| P[notificationService.error]
    O --> Q[askToOpenWorkspaceConfigurationFile]
    Q --> R[notificationService.prompt]
    R --> J
    P --> J
    L --> J
```

## データベース参照・更新仕様

### 参照テーブル一覧

| サービス | 用途 | 備考 |
|---------|------|------|
| IWorkspaceContextService | ワークスペース状態の取得 | WorkbenchState |
| IFileService | ファイルの存在確認 | exists() |

### 更新テーブル一覧

| ファイル | 操作 | 概要 |
|---------|------|------|
| *.code-workspace | UPDATE | ワークスペース設定ファイルの更新 |

## エラー処理

### エラーケース一覧

| エラーコード | 発生条件 | 対処方法 |
|------------|---------|---------|
| JSONEditingErrorCode.ERROR_INVALID_FILE | ワークスペースファイルのJSON構文エラー | ワークスペース設定を開くことを提案 |
| その他 | 一般的なエラー | エラーメッセージを表示 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | なし |
| リトライ間隔 | - |
| リトライ対象エラー | - |

## 配信設定

### レート制限

| 項目 | 内容 |
|-----|------|
| 1分あたり上限 | 制限なし |
| 1日あたり上限 | 制限なし |

### 配信時間帯

制限なし

## セキュリティ考慮事項

- ワークスペースファイルのパスがエラーメッセージに関連する
- ワークスペーストラストの考慮が必要（信頼されていないワークスペースへの操作）

## 備考

- IJSONEditingServiceを使用してワークスペースファイルを編集
- rewriteWorkspaceFileForNewLocation関数でワークスペースの相対パスを調整
- ワークスペースの種類：Empty / Folder / Workspace（マルチルート）

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

ワークスペース編集サービスのインターフェースを理解します。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | workspaceEditing.ts | `src/vs/workbench/services/workspaces/common/workspaceEditing.ts` | IWorkspaceEditingServiceインターフェース |
| 1-2 | jsonEditing.ts | `src/vs/workbench/services/configuration/common/jsonEditing.ts` | JSONEditingErrorCode |

**読解のコツ**: WorkbenchState（Empty, Folder, Workspace）の3状態がワークスペースの種類を表します。

#### Step 2: エントリーポイントを理解する

AbstractWorkspaceEditingServiceの実装を確認します。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | abstractWorkspaceEditingService.ts | `src/vs/workbench/services/workspaces/browser/abstractWorkspaceEditingService.ts` | AbstractWorkspaceEditingServiceクラス |

**主要処理フロー**:
1. **102-150行目**: updateFoldersメソッド - フォルダの追加/削除の統合処理
2. **152-162行目**: doUpdateFolders - 実際の更新処理
3. **164-204行目**: doAddFolders - フォルダ追加処理
4. **206-224行目**: removeFolders - フォルダ削除処理
5. **331-339行目**: handleWorkspaceConfigurationEditingError - エラーハンドリング
6. **341-344行目**: onInvalidWorkspaceConfigurationFileError - 無効なファイルエラー
7. **346-353行目**: askToOpenWorkspaceConfigurationFile - プロンプト表示

#### Step 3: ワークスペースコンテキストを理解する

ワークスペースの状態管理を確認します。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | workspace.ts | `src/vs/platform/workspace/common/workspace.ts` | IWorkspaceContextService, WorkbenchState |

### プログラム呼び出し階層図

```
Workspace Commands / Explorer
    │
    └─ IWorkspaceEditingService
           │
           ├─ updateFolders (102行目)
           │      ├─ doAddFolders
           │      ├─ removeFolders
           │      └─ doUpdateFolders
           │
           ├─ addFolders (164行目)
           │      └─ doAddFolders
           │             └─ contextService.addFolders
           │                    │
           │                    └─ [on error] handleWorkspaceConfigurationEditingError
           │                           │
           │                           └─ onInvalidWorkspaceConfigurationFileError
           │                                  └─ askToOpenWorkspaceConfigurationFile
           │                                         └─ notificationService.prompt
           │
           └─ removeFolders (206行目)
                  └─ contextService.removeFolders
```

### データフロー図

```
[入力]               [処理]                    [出力]

フォルダ追加要求 ───▶ doAddFolders            ───▶ ワークスペース更新
                       │                            │
                       ▼                            ▼
               contextService.addFolders     ───▶ code-workspaceファイル
                       │
                       ▼
               [on error]                    ───▶ エラー通知
                       │
                       ▼
               handleWorkspaceConfigurationEditingError
                       │
                       ▼
               askToOpenWorkspaceConfigurationFile
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| abstractWorkspaceEditingService.ts | `src/vs/workbench/services/workspaces/browser/abstractWorkspaceEditingService.ts` | ソース | 抽象ワークスペース編集サービス |
| workspaceEditing.ts | `src/vs/workbench/services/workspaces/common/workspaceEditing.ts` | ソース | インターフェース定義 |
| jsonEditing.ts | `src/vs/workbench/services/configuration/common/jsonEditing.ts` | ソース | JSON編集サービス |
| workspace.ts | `src/vs/platform/workspace/common/workspace.ts` | ソース | ワークスペースコンテキスト |
| workspaces.ts | `src/vs/platform/workspaces/common/workspaces.ts` | ソース | ワークスペースユーティリティ |
| notification.ts | `src/vs/platform/notification/common/notification.ts` | ソース | 通知サービス |
