# 通知設計書 5-rename.failedApply

## 概要

本ドキュメントは、VS Codeのシンボルリネーム機能において、リネーム編集の適用に失敗した場合に表示されるエラー通知の設計について記述する。

### 本通知の処理概要

この通知は、エディタでシンボルのリネーム操作を実行し、言語サービスからの編集内容の適用に失敗した場合にエラーメッセージを表示する機能である。

**業務上の目的・背景**：シンボルのリネーム（変数名、関数名、クラス名などの変更）は、コードのリファクタリングにおいて頻繁に使用される機能である。複数ファイルにまたがる変更が発生する可能性があり、一部の編集が適用できなかった場合、ユーザーに明確にエラーを通知することで、不完全なリネーム状態を認識させ、適切な対応を取れるようにする必要がある。

**通知の送信タイミング**：リネーム操作で言語サービスから編集内容を取得し、BulkEditServiceを使用して編集を適用しようとした際に、編集の適用処理で例外がスローされた場合に通知が送信される。

**通知の受信者**：リネーム操作を実行したVS Codeユーザーが対象となる。

**通知内容の概要**：「Rename failed to apply edits」という固定メッセージが表示される。

**期待されるアクション**：ユーザーは以下のいずれかの対応を取ることが期待される：
- Undo（Ctrl+Z）で変更を元に戻す
- 手動でシンボル名を修正する
- ファイルの保存状態を確認する
- ログを確認してエラーの詳細を把握する

## 通知種別

アプリ内通知（VS Code内部のNotificationService経由、エラーレベル）

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 非同期（Promise内のcatch処理） |
| 優先度 | 高（エラー通知） |
| リトライ | なし |

### 送信先決定ロジック

リネーム操作を実行したユーザーに対して表示される。

## 通知テンプレート

### アプリ内通知の場合

| 項目 | 内容 |
|-----|------|
| 深刻度 | Error（エラー） |
| 形式 | テキスト |

### 本文テンプレート

```
Rename failed to apply edits
```

### 添付ファイル

| ファイル名 | 形式 | 条件 | 説明 |
|----------|------|------|------|
| なし | - | - | 添付ファイルなし |

## テンプレート変数

| 変数名 | 説明 | データ取得元 | 必須 |
|--------|------|-------------|-----|
| なし | - | 固定メッセージのため変数なし | - |

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| 画面操作 | F2キーでリネーム開始後、新しい名前を入力してEnter | bulkEditService.apply()でエラー発生 | 編集の適用処理で例外がスロー |
| コンテキストメニュー | 「シンボルの名前変更」を選択後、新しい名前を入力してEnter | bulkEditService.apply()でエラー発生 | 編集の適用処理で例外がスロー |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| 編集適用成功 | BulkEditServiceによる編集が正常に適用された場合は通知せず |
| リネームキャンセル | ユーザーがリネーム入力をキャンセルした場合 |
| 編集計算失敗 | 編集の計算段階で失敗した場合は別の通知（rename.failed）が表示される |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A[リネーム操作開始 F2] --> B[リネーム位置の解決]
    B --> C[リネームウィジェット表示]
    C --> D[ユーザー入力]
    D --> E{入力キャンセル?}
    E -->|Yes| F[処理終了]
    E -->|No| G[編集内容の取得 provideRenameEdits]
    G --> H{rejectReason?}
    H -->|Yes| I[info通知で理由表示]
    H -->|No| J[編集の適用 bulkEditService.apply]
    J --> K{適用成功?}
    K -->|Yes| L[成功アラート]
    K -->|No| M[エラー通知 rename.failedApply]
    M --> N[ログ出力]
    I --> F
    L --> F
    N --> F
```

## データベース参照・更新仕様

### 参照テーブル一覧

| テーブル名 | 用途 | 備考 |
|-----------|------|------|
| なし | - | データベースアクセスなし |

### 更新テーブル一覧

| テーブル名 | 操作 | 概要 |
|-----------|------|------|
| なし | - | データベースアクセスなし（ファイルシステム経由での編集） |

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| 編集適用失敗 | BulkEditService.apply()が例外をスロー | エラー通知を表示、エラーをログ出力 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | なし |
| リトライ間隔 | - |
| リトライ対象エラー | - |

## 配信設定

### レート制限

| 項目 | 内容 |
|-----|------|
| 1分あたり上限 | なし（ユーザー操作に応じて発生） |
| 1日あたり上限 | なし |

### 配信時間帯

制限なし（ユーザー操作に応じて随時発生）

## セキュリティ考慮事項

- 個人情報は含まれない
- ファイル内容やシンボル名に関する情報は通知に含まれない
- エラーの詳細はログにのみ出力される
- ローカライズ機能（nls.localize）を使用して多言語対応している

## 備考

- この通知は「rename.failed」（編集の計算失敗）とは別のエラーケースを処理する
- エラーの詳細は`_logService.error(err)`で開発者ログに出力される
- エディタ操作はPromiseベースの非同期処理で実行される

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

リネーム機能の状態管理とWorkspaceEditの構造を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | languages.ts | `src/vs/editor/common/languages.ts` | WorkspaceEdit、RenameLocation、Rejectionインターフェース |
| 1-2 | bulkEditService.ts | `src/vs/editor/browser/services/bulkEditService.ts` | IBulkEditServiceインターフェース |

**読解のコツ**: WorkspaceEditは複数ファイルにまたがる編集を表現するデータ構造。

#### Step 2: エントリーポイントを理解する

`RenameController.run`メソッドの実装を確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | rename.ts | `src/vs/editor/contrib/rename/browser/rename.ts` | RenameControllerクラスのrun()メソッド（178-340行目） |

**主要処理フロー**:
1. **178行目**: `run()`メソッドの定義開始
2. **284行目**: `skeleton.provideRenameEdits()`で編集内容を取得
3. **306行目**: `_bulkEditService.apply()`で編集を適用
4. **319-323行目**: 適用失敗時の`.catch()`処理
5. **321行目**: `_notificationService.error()`でエラー通知
6. **322行目**: `_logService.error()`でログ出力

#### Step 3: BulkEditServiceを理解する

編集の適用処理を確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | bulkEditService.ts | `src/vs/editor/browser/services/bulkEditService.ts` | apply()メソッドの仕様 |

### プログラム呼び出し階層図

```
RenameAction.run()
    │
    └─ RenameController.run()
           │
           ├─ RenameSkeleton.resolveRenameLocation()
           │      └─ RenameProvider.resolveRenameLocation()
           │
           ├─ RenameWidget.getInput()
           │      └─ ユーザー入力待ち
           │
           ├─ RenameSkeleton.provideRenameEdits()
           │      └─ RenameProvider.provideRenameEdits()
           │
           └─ BulkEditService.apply()
                  │
                  ├─ 成功 → alert()
                  │
                  └─ 失敗 → notificationService.error()
                            └─ nls.localize('rename.failedApply', ...)
```

### データフロー図

```
[入力]                    [処理]                              [出力]

ユーザー操作        ───▶ RenameController.run()        ───▶ ファイル編集
(F2 + 新名前)             │                                  または
                          ├─ 言語サービス                     エラー通知
                          │   └─ WorkspaceEdit取得
                          │
                          ├─ BulkEditService
                          │   └─ 編集適用試行
                          │
                          └─ NotificationService
                              └─ エラー通知表示
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| rename.ts | `src/vs/editor/contrib/rename/browser/rename.ts` | ソース | リネームコントローラー、run()メソッドの実装 |
| renameWidget.ts | `src/vs/editor/contrib/rename/browser/renameWidget.ts` | ソース | リネーム入力ウィジェット |
| languages.ts | `src/vs/editor/common/languages.ts` | ソース | WorkspaceEdit、RenameProviderインターフェース |
| bulkEditService.ts | `src/vs/editor/browser/services/bulkEditService.ts` | ソース | 複数ファイル編集サービス |
| notification.ts | `src/vs/platform/notification/common/notification.ts` | ソース | 通知サービスのインターフェース定義 |
| log.ts | `src/vs/platform/log/common/log.ts` | ソース | ログサービス |
