# 通知設計書 6-rename.failed

## 概要

本ドキュメントは、VS Codeのシンボルリネーム機能において、リネーム編集の計算に失敗した場合に表示されるエラー通知の設計について記述する。

### 本通知の処理概要

この通知は、エディタでシンボルのリネーム操作を実行し、言語サービスからの編集内容の取得（計算）に失敗した場合にエラーメッセージを表示する機能である。

**業務上の目的・背景**：シンボルのリネーム（変数名、関数名、クラス名などの変更）は、コードのリファクタリングにおいて頻繁に使用される機能である。言語サービスが編集内容を計算できない場合（例：構文エラー、言語サーバーの問題、対象シンボルの解析失敗など）、ユーザーに明確にエラーを通知することで、問題を認識させ、適切な対応を取れるようにする必要がある。

**通知の送信タイミング**：リネーム操作で言語サービス（RenameProvider）から編集内容を取得しようとした際に、provideRenameEditsの処理で例外がスローされた場合に通知が送信される。

**通知の受信者**：リネーム操作を実行したVS Codeユーザーが対象となる。

**通知内容の概要**：「Rename failed to compute edits」という固定メッセージが表示される。

**期待されるアクション**：ユーザーは以下のいずれかの対応を取ることが期待される：
- コード内の構文エラーを修正する
- 言語サーバーが正常に動作しているか確認する
- 手動でシンボル名を修正する
- ログを確認してエラーの詳細を把握する

## 通知種別

アプリ内通知（VS Code内部のNotificationService経由、エラーレベル）

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 非同期（Promise内のエラーハンドリング） |
| 優先度 | 高（エラー通知） |
| リトライ | なし |

### 送信先決定ロジック

リネーム操作を実行したユーザーに対して表示される。

## 通知テンプレート

### アプリ内通知の場合

| 項目 | 内容 |
|-----|------|
| 深刻度 | Error（エラー） |
| 形式 | テキスト |

### 本文テンプレート

```
Rename failed to compute edits
```

### 添付ファイル

| ファイル名 | 形式 | 条件 | 説明 |
|----------|------|------|------|
| なし | - | - | 添付ファイルなし |

## テンプレート変数

| 変数名 | 説明 | データ取得元 | 必須 |
|--------|------|-------------|-----|
| なし | - | 固定メッセージのため変数なし | - |

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| 画面操作 | F2キーでリネーム開始後、新しい名前を入力してEnter | skeleton.provideRenameEdits()でエラー発生 | 編集計算処理で例外がスロー |
| コンテキストメニュー | 「シンボルの名前変更」を選択後、新しい名前を入力してEnter | skeleton.provideRenameEdits()でエラー発生 | 編集計算処理で例外がスロー |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| 編集計算成功 | provideRenameEditsが正常に結果を返した場合は通知せず |
| リネームキャンセル | ユーザーがリネーム入力をキャンセルした場合 |
| rejectReason付きの結果 | 言語サービスが拒否理由を返した場合はinfo通知が表示される |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A[リネーム操作開始 F2] --> B[リネーム位置の解決]
    B --> C[リネームウィジェット表示]
    C --> D[ユーザー入力]
    D --> E{入力キャンセル?}
    E -->|Yes| F[処理終了]
    E -->|No| G[編集内容の取得 provideRenameEdits]
    G --> H{例外発生?}
    H -->|Yes| I[エラー通知 rename.failed]
    H -->|No| J{rejectReason?}
    J -->|Yes| K[info通知で理由表示]
    J -->|No| L[編集の適用処理へ]
    I --> M[ログ出力]
    M --> F
    K --> F
    L --> F
```

## データベース参照・更新仕様

### 参照テーブル一覧

| テーブル名 | 用途 | 備考 |
|-----------|------|------|
| なし | - | データベースアクセスなし |

### 更新テーブル一覧

| テーブル名 | 操作 | 概要 |
|-----------|------|------|
| なし | - | データベースアクセスなし |

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| 編集計算失敗 | provideRenameEdits()が例外をスロー | エラー通知を表示、エラーをログ出力 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | なし |
| リトライ間隔 | - |
| リトライ対象エラー | - |

## 配信設定

### レート制限

| 項目 | 内容 |
|-----|------|
| 1分あたり上限 | なし（ユーザー操作に応じて発生） |
| 1日あたり上限 | なし |

### 配信時間帯

制限なし（ユーザー操作に応じて随時発生）

## セキュリティ考慮事項

- 個人情報は含まれない
- ファイル内容やシンボル名に関する情報は通知に含まれない
- エラーの詳細はログにのみ出力される
- ローカライズ機能（nls.localize）を使用して多言語対応している

## 備考

- この通知は「rename.failedApply」（編集の適用失敗）とは別のエラーケースを処理する
- rename.failedは言語サービス側でのエラー、rename.failedApplyはファイル編集時のエラー
- エラーの詳細は`_logService.error(err)`で開発者ログに出力される

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

リネーム機能の状態管理とWorkspaceEditの構造を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | languages.ts | `src/vs/editor/common/languages.ts` | WorkspaceEdit、RenameLocation、Rejectionインターフェース |
| 1-2 | rename.ts | `src/vs/editor/contrib/rename/browser/rename.ts` | RenameSkeletonクラスの構造 |

**読解のコツ**: RenameSkeletonは言語サービスへのアクセスを抽象化するクラス。

#### Step 2: エントリーポイントを理解する

`RenameController.run`メソッドの実装を確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | rename.ts | `src/vs/editor/contrib/rename/browser/rename.ts` | RenameControllerクラスのrun()メソッド（178-340行目） |

**主要処理フロー**:
1. **178行目**: `run()`メソッドの定義開始
2. **284行目**: `skeleton.provideRenameEdits()`を呼び出し
3. **325-330行目**: provideRenameEditsの失敗時処理
4. **328行目**: `_notificationService.error()`でエラー通知
5. **329行目**: `_logService.error()`でログ出力

#### Step 3: RenameSkeleton.provideRenameEditsを理解する

編集内容の計算処理を確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | rename.ts | `src/vs/editor/contrib/rename/browser/rename.ts` | RenameSkeleton.provideRenameEdits()メソッド（99-119行目） |

**主要処理フロー**:
- **99行目**: `provideRenameEdits`メソッドの定義
- **112行目**: `provider.provideRenameEdits()`を呼び出し
- 各プロバイダーを順次試行し、有効な結果が返るまで続ける

### プログラム呼び出し階層図

```
RenameAction.run()
    │
    └─ RenameController.run()
           │
           ├─ RenameSkeleton.resolveRenameLocation()
           │
           ├─ RenameWidget.getInput()
           │
           └─ RenameSkeleton.provideRenameEdits()
                  │
                  ├─ RenameProvider.provideRenameEdits()
                  │      │
                  │      ├─ 成功 → 結果返却
                  │      │
                  │      └─ 失敗/null → 次のプロバイダーへ
                  │
                  └─ 全プロバイダー失敗時
                         └─ 例外発生 → catch
                                 │
                                 ├─ notificationService.error()
                                 │   └─ nls.localize('rename.failed', ...)
                                 │
                                 └─ logService.error()
```

### データフロー図

```
[入力]                    [処理]                              [出力]

ユーザー操作        ───▶ RenameController.run()        ───▶ 編集計算結果
(F2 + 新名前)             │                                  または
                          ├─ RenameSkeleton                  エラー通知
                          │   └─ provideRenameEdits()
                          │         │
                          │         └─ RenameProvider[]
                          │
                          └─ NotificationService
                              └─ エラー通知表示
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| rename.ts | `src/vs/editor/contrib/rename/browser/rename.ts` | ソース | リネームコントローラー、RenameSkeleton、run()メソッドの実装 |
| renameWidget.ts | `src/vs/editor/contrib/rename/browser/renameWidget.ts` | ソース | リネーム入力ウィジェット |
| languages.ts | `src/vs/editor/common/languages.ts` | ソース | WorkspaceEdit、RenameProviderインターフェース |
| languageFeatures.ts | `src/vs/editor/common/services/languageFeatures.ts` | ソース | 言語機能サービス |
| notification.ts | `src/vs/platform/notification/common/notification.ts` | ソース | 通知サービスのインターフェース定義 |
| log.ts | `src/vs/platform/log/common/log.ts` | ソース | ログサービス |
