# 通知設計書 7-invalid.url

## 概要

本ドキュメントは、VS Codeのエディタでリンクを開こうとした際に、URLが不正な形式であった場合に表示される警告通知の設計について記述する。

### 本通知の処理概要

この通知は、エディタ内で検出されたリンク（URL）をユーザーがクリックまたはキーボード操作で開こうとした際に、リンク先の解決処理でURLが不正（invalid）と判定された場合に警告メッセージを表示する機能である。

**業務上の目的・背景**：VS Codeのエディタはテキスト内のリンクを自動検出し、Ctrl+クリックやショートカットで開くことができる。しかし、リンクのURLが不正な形式（malformed）である場合、そのまま開こうとするとエラーになるか、予期しない動作を引き起こす可能性がある。この通知は、ユーザーに対してリンクが開けない理由を明確に伝え、URLを修正するよう促すことを目的としている。

**通知の送信タイミング**：ユーザーがエディタ内のリンクをクリック（Ctrl+クリックまたは設定に応じてAlt+クリック）した際、または「リンクを開く」コマンドを実行した際に、リンクの解決処理でエラー「invalid」が発生した場合に通知が送信される。

**通知の受信者**：リンクを開こうとしたVS Codeユーザーが対象となる。

**通知内容の概要**：「Failed to open this link because it is not well-formed: {URL}」というメッセージが、問題のURLと共に表示される。

**期待されるアクション**：ユーザーは以下のいずれかの対応を取ることが期待される：
- URLの形式を確認し、修正する
- URLをコピーしてブラウザで手動で開く
- URLエンコーディングの問題を確認する

## 通知種別

アプリ内通知（VS Code内部のNotificationService経由、警告レベル）

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 非同期（Promise内のcatch処理） |
| 優先度 | 中（警告通知） |
| リトライ | なし |

### 送信先決定ロジック

リンクを開こうとしたユーザーに対して表示される。

## 通知テンプレート

### アプリ内通知の場合

| 項目 | 内容 |
|-----|------|
| 深刻度 | Warning（警告） |
| 形式 | テキスト |

### 本文テンプレート

```
Failed to open this link because it is not well-formed: {0}
```

- `{0}`: 不正なURLの文字列

### 添付ファイル

| ファイル名 | 形式 | 条件 | 説明 |
|----------|------|------|------|
| なし | - | - | 添付ファイルなし |

## テンプレート変数

| 変数名 | 説明 | データ取得元 | 必須 |
|--------|------|-------------|-----|
| {0} | 不正なURL | link.url.toString() | Yes |

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| 画面操作 | Ctrl+クリック（または設定に応じてAlt+クリック） | link.resolve()でエラー「invalid」が発生 | リンク解決時にURLが不正 |
| キーボード | リンク上で「リンクを開く」コマンド実行 | link.resolve()でエラー「invalid」が発生 | リンク解決時にURLが不正 |
| ミドルクリック | マウスの中央ボタンクリック（設定により有効化） | link.resolve()でエラー「invalid」が発生 | リンク解決時にURLが不正 |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| リンク解決成功 | URLが正常に解決された場合は通知せず、リンク先を開く |
| 「missing」エラー | リンク先が見つからない場合は別の通知（missing.url）が表示される |
| その他の予期しないエラー | onUnexpectedErrorで処理される |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A[リンククリック検出] --> B{クリック条件確認}
    B -->|条件OK| C[リンク解決処理 link.resolve]
    B -->|条件NG| D[処理終了]
    C --> E{解決結果}
    E -->|成功| F[OpenerServiceでリンクを開く]
    E -->|エラー| G{エラー種別}
    G -->|invalid| H[警告通知 invalid.url]
    G -->|missing| I[警告通知 missing.url]
    G -->|その他| J[onUnexpectedError]
    F --> D
    H --> D
    I --> D
    J --> D
```

## データベース参照・更新仕様

### 参照テーブル一覧

| テーブル名 | 用途 | 備考 |
|-----------|------|------|
| なし | - | データベースアクセスなし |

### 更新テーブル一覧

| テーブル名 | 操作 | 概要 |
|-----------|------|------|
| なし | - | データベースアクセスなし |

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| invalid | URLの形式が不正 | invalid.url警告通知を表示 |
| missing | リンク先が存在しない | missing.url警告通知を表示 |
| その他 | 予期しないエラー | onUnexpectedErrorで処理 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | なし |
| リトライ間隔 | - |
| リトライ対象エラー | - |

## 配信設定

### レート制限

| 項目 | 内容 |
|-----|------|
| 1分あたり上限 | なし（ユーザー操作に応じて発生） |
| 1日あたり上限 | なし |

### 配信時間帯

制限なし（ユーザー操作に応じて随時発生）

## セキュリティ考慮事項

- 不正なURLがそのまま通知に表示されるため、潜在的なセキュリティリスクを含む可能性がある
- URLが悪意のあるスクリプトや長大な文字列の場合でも表示される
- ローカライズ機能（nls.localize）を使用して多言語対応している

## 備考

- LinkDetectorがエディタ内のリンクを自動検出する
- OpenerServiceが実際にリンクを開く処理を担当
- link.resolve()はCancellationTokenを使用して非同期で処理される

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

リンク検出機能とLinkの構造を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | getLinks.ts | `src/vs/editor/contrib/links/browser/getLinks.ts` | Linkクラスとresolve()メソッド |
| 1-2 | links.ts | `src/vs/editor/contrib/links/browser/links.ts` | LinkDetectorとLinkOccurrenceクラス |

**読解のコツ**: Linkはエディタ内で検出されたリンクを表現し、resolve()でURIを解決する。

#### Step 2: エントリーポイントを理解する

`openLinkOccurrence`メソッドの実装を確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | links.ts | `src/vs/editor/contrib/links/browser/links.ts` | LinkDetector.openLinkOccurrence()メソッド（221-266行目） |

**主要処理フロー**:
1. **221行目**: `openLinkOccurrence()`メソッドの定義開始
2. **229行目**: `link.resolve(CancellationToken.None)`でリンクを解決
3. **253行目**: `openerService.open()`でリンクを開く
4. **255-266行目**: エラーハンドリング（.catch）
5. **259行目**: エラーが「invalid」の場合、`notificationService.warn()`で警告
6. **260行目**: URLを含むメッセージを表示

#### Step 3: Link.resolve()を理解する

リンク解決処理を確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | getLinks.ts | `src/vs/editor/contrib/links/browser/getLinks.ts` | Link.resolve()メソッド |

### プログラム呼び出し階層図

```
ユーザー操作（Ctrl+クリック等）
    │
    ├─ ClickLinkGesture.onExecute
    │
    └─ LinkDetector.openLinkOccurrence()
           │
           ├─ link.resolve(CancellationToken.None)
           │      │
           │      └─ LinkProvider.resolveLink()
           │
           ├─ 成功時
           │      └─ openerService.open()
           │
           └─ 失敗時（.catch）
                  │
                  ├─ messageOrError === 'invalid'
                  │      └─ notificationService.warn()
                  │          └─ nls.localize('invalid.url', ...)
                  │
                  ├─ messageOrError === 'missing'
                  │      └─ notificationService.warn()
                  │          └─ nls.localize('missing.url', ...)
                  │
                  └─ その他
                         └─ onUnexpectedError()
```

### データフロー図

```
[入力]                    [処理]                              [出力]

ユーザー操作        ───▶ LinkDetector                  ───▶ リンク先を開く
(Ctrl+クリック)           │                                  または
                          ├─ Link.resolve()                  警告通知
                          │   └─ LinkProvider
                          │
                          ├─ OpenerService
                          │   └─ open()
                          │
                          └─ NotificationService
                              └─ warn()
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| links.ts | `src/vs/editor/contrib/links/browser/links.ts` | ソース | LinkDetectorクラス、リンク検出と開く処理 |
| getLinks.ts | `src/vs/editor/contrib/links/browser/getLinks.ts` | ソース | Linkクラス、resolve()メソッド |
| clickLinkGesture.ts | `src/vs/editor/contrib/gotoSymbol/browser/link/clickLinkGesture.ts` | ソース | クリックジェスチャーの検出 |
| opener.ts | `src/vs/platform/opener/common/opener.ts` | ソース | IOpenerServiceインターフェース |
| notification.ts | `src/vs/platform/notification/common/notification.ts` | ソース | 通知サービスのインターフェース定義 |
