# 通知設計書 8-missing.url

## 概要

本ドキュメントは、VS Codeのエディタでリンクを開こうとした際に、リンクのターゲット（リンク先）が見つからない場合に表示される警告通知の設計について記述する。

### 本通知の処理概要

この通知は、エディタ内で検出されたリンク（URL）をユーザーがクリックまたはキーボード操作で開こうとした際に、リンク先の解決処理でターゲットが見つからない（missing）と判定された場合に警告メッセージを表示する機能である。

**業務上の目的・背景**：VS Codeのエディタはテキスト内のリンクを自動検出し、Ctrl+クリックやショートカットで開くことができる。しかし、リンク先のファイルやリソースが存在しない場合、ユーザーに対してその状況を明確に伝え、リンク先を確認・修正するよう促すことを目的としている。相対パスや内部リンクが壊れている場合などに発生する。

**通知の送信タイミング**：ユーザーがエディタ内のリンクをクリック（Ctrl+クリックまたは設定に応じてAlt+クリック）した際、または「リンクを開く」コマンドを実行した際に、リンクの解決処理でエラー「missing」が発生した場合に通知が送信される。

**通知の受信者**：リンクを開こうとしたVS Codeユーザーが対象となる。

**通知内容の概要**：「Failed to open this link because its target is missing.」という固定メッセージが表示される。

**期待されるアクション**：ユーザーは以下のいずれかの対応を取ることが期待される：
- リンク先のファイルが存在するか確認する
- ファイルを作成する
- リンクのパスを修正する
- 相対パスと絶対パスを確認する

## 通知種別

アプリ内通知（VS Code内部のNotificationService経由、警告レベル）

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 非同期（Promise内のcatch処理） |
| 優先度 | 中（警告通知） |
| リトライ | なし |

### 送信先決定ロジック

リンクを開こうとしたユーザーに対して表示される。

## 通知テンプレート

### アプリ内通知の場合

| 項目 | 内容 |
|-----|------|
| 深刻度 | Warning（警告） |
| 形式 | テキスト |

### 本文テンプレート

```
Failed to open this link because its target is missing.
```

### 添付ファイル

| ファイル名 | 形式 | 条件 | 説明 |
|----------|------|------|------|
| なし | - | - | 添付ファイルなし |

## テンプレート変数

| 変数名 | 説明 | データ取得元 | 必須 |
|--------|------|-------------|-----|
| なし | - | 固定メッセージのため変数なし | - |

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| 画面操作 | Ctrl+クリック（または設定に応じてAlt+クリック） | link.resolve()でエラー「missing」が発生 | リンク先が存在しない |
| キーボード | リンク上で「リンクを開く」コマンド実行 | link.resolve()でエラー「missing」が発生 | リンク先が存在しない |
| ミドルクリック | マウスの中央ボタンクリック（設定により有効化） | link.resolve()でエラー「missing」が発生 | リンク先が存在しない |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| リンク解決成功 | URLが正常に解決された場合は通知せず、リンク先を開く |
| 「invalid」エラー | URLが不正な形式の場合は別の通知（invalid.url）が表示される |
| その他の予期しないエラー | onUnexpectedErrorで処理される |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A[リンククリック検出] --> B{クリック条件確認}
    B -->|条件OK| C[リンク解決処理 link.resolve]
    B -->|条件NG| D[処理終了]
    C --> E{解決結果}
    E -->|成功| F[OpenerServiceでリンクを開く]
    E -->|エラー| G{エラー種別}
    G -->|invalid| H[警告通知 invalid.url]
    G -->|missing| I[警告通知 missing.url]
    G -->|その他| J[onUnexpectedError]
    F --> D
    H --> D
    I --> D
    J --> D
```

## データベース参照・更新仕様

### 参照テーブル一覧

| テーブル名 | 用途 | 備考 |
|-----------|------|------|
| なし | - | データベースアクセスなし |

### 更新テーブル一覧

| テーブル名 | 操作 | 概要 |
|-----------|------|------|
| なし | - | データベースアクセスなし |

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| missing | リンク先のターゲットが存在しない | missing.url警告通知を表示 |
| invalid | URLの形式が不正 | invalid.url警告通知を表示 |
| その他 | 予期しないエラー | onUnexpectedErrorで処理 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | なし |
| リトライ間隔 | - |
| リトライ対象エラー | - |

## 配信設定

### レート制限

| 項目 | 内容 |
|-----|------|
| 1分あたり上限 | なし（ユーザー操作に応じて発生） |
| 1日あたり上限 | なし |

### 配信時間帯

制限なし（ユーザー操作に応じて随時発生）

## セキュリティ考慮事項

- 個人情報は含まれない
- リンク先のパス情報は通知に含まれない（セキュリティ配慮）
- ローカライズ機能（nls.localize）を使用して多言語対応している

## 備考

- LinkDetectorがエディタ内のリンクを自動検出する
- OpenerServiceが実際にリンクを開く処理を担当
- ファイルシステム上のファイルやリモートリソースの存在確認に失敗した場合にこのエラーが発生する

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

リンク検出機能とLinkの構造を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | getLinks.ts | `src/vs/editor/contrib/links/browser/getLinks.ts` | Linkクラスとresolve()メソッド |
| 1-2 | links.ts | `src/vs/editor/contrib/links/browser/links.ts` | LinkDetectorとLinkOccurrenceクラス |

**読解のコツ**: Linkはエディタ内で検出されたリンクを表現し、resolve()でURIを解決する。

#### Step 2: エントリーポイントを理解する

`openLinkOccurrence`メソッドの実装を確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | links.ts | `src/vs/editor/contrib/links/browser/links.ts` | LinkDetector.openLinkOccurrence()メソッド（221-266行目） |

**主要処理フロー**:
1. **221行目**: `openLinkOccurrence()`メソッドの定義開始
2. **229行目**: `link.resolve(CancellationToken.None)`でリンクを解決
3. **253行目**: `openerService.open()`でリンクを開く
4. **255-266行目**: エラーハンドリング（.catch）
5. **261-262行目**: エラーが「missing」の場合、`notificationService.warn()`で警告

#### Step 3: Link.resolve()を理解する

リンク解決処理を確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | getLinks.ts | `src/vs/editor/contrib/links/browser/getLinks.ts` | Link.resolve()メソッド |

### プログラム呼び出し階層図

```
ユーザー操作（Ctrl+クリック等）
    │
    ├─ ClickLinkGesture.onExecute
    │
    └─ LinkDetector.openLinkOccurrence()
           │
           ├─ link.resolve(CancellationToken.None)
           │      │
           │      └─ LinkProvider.resolveLink()
           │
           ├─ 成功時
           │      └─ openerService.open()
           │
           └─ 失敗時（.catch）
                  │
                  ├─ messageOrError === 'invalid'
                  │      └─ notificationService.warn()
                  │          └─ nls.localize('invalid.url', ...)
                  │
                  ├─ messageOrError === 'missing'
                  │      └─ notificationService.warn()
                  │          └─ nls.localize('missing.url', ...)
                  │
                  └─ その他
                         └─ onUnexpectedError()
```

### データフロー図

```
[入力]                    [処理]                              [出力]

ユーザー操作        ───▶ LinkDetector                  ───▶ リンク先を開く
(Ctrl+クリック)           │                                  または
                          ├─ Link.resolve()                  警告通知
                          │   └─ LinkProvider
                          │
                          ├─ OpenerService
                          │   └─ open()
                          │
                          └─ NotificationService
                              └─ warn()
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| links.ts | `src/vs/editor/contrib/links/browser/links.ts` | ソース | LinkDetectorクラス、リンク検出と開く処理 |
| getLinks.ts | `src/vs/editor/contrib/links/browser/getLinks.ts` | ソース | Linkクラス、resolve()メソッド |
| clickLinkGesture.ts | `src/vs/editor/contrib/gotoSymbol/browser/link/clickLinkGesture.ts` | ソース | クリックジェスチャーの検出 |
| opener.ts | `src/vs/platform/opener/common/opener.ts` | ソース | IOpenerServiceインターフェース |
| notification.ts | `src/vs/platform/notification/common/notification.ts` | ソース | 通知サービスのインターフェース定義 |
