# 通知設計書 9-openFolderFirst

## 概要

本ドキュメントは、VS Codeでワークスペース設定またはフォルダ設定を作成しようとした際に、まずフォルダまたはワークスペースを開く必要があることを通知する情報メッセージの設計について記述する。

### 本通知の処理概要

この通知は、ユーザーがワークスペース設定またはフォルダ設定を開こうとしたが、現在フォルダやワークスペースが開かれていない状態（Empty workspace）である場合に、情報メッセージを表示する機能である。

**業務上の目的・背景**：VS Codeの設定は、ユーザー設定、ワークスペース設定、フォルダ設定の3つのスコープに分かれている。ワークスペース設定やフォルダ設定は、フォルダまたはワークスペースが開かれていないと作成できない。この通知は、ユーザーに対して設定を作成する前提条件（フォルダを開く）を明確に伝え、適切な操作を促すことを目的としている。

**通知の送信タイミング**：ユーザーがワークスペース設定を開こうとした際（openWorkspaceSettings呼び出し時）に、ワークスペースリソース（workspaceSettingsResource）が存在しない場合に通知が送信される。

**通知の受信者**：ワークスペース設定を作成しようとしたVS Codeユーザーが対象となる。

**通知内容の概要**：「Open a folder or workspace first to create workspace or folder settings.」という固定メッセージが表示される。

**期待されるアクション**：ユーザーは以下のいずれかの対応を取ることが期待される：
- 「ファイル」>「フォルダを開く」でフォルダを開く
- 「ファイル」>「ワークスペースを開く」でワークスペースを開く
- コマンドパレットから「Open Folder」を実行する

## 通知種別

アプリ内通知（VS Code内部のNotificationService経由、情報レベル）

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 同期 |
| 優先度 | 低（情報通知） |
| リトライ | なし |

### 送信先決定ロジック

ワークスペース設定を開こうとしたユーザーに対して表示される。

## 通知テンプレート

### アプリ内通知の場合

| 項目 | 内容 |
|-----|------|
| 深刻度 | Info（情報） |
| 形式 | テキスト |

### 本文テンプレート

```
Open a folder or workspace first to create workspace or folder settings.
```

### 添付ファイル

| ファイル名 | 形式 | 条件 | 説明 |
|----------|------|------|------|
| なし | - | - | 添付ファイルなし |

## テンプレート変数

| 変数名 | 説明 | データ取得元 | 必須 |
|--------|------|-------------|-----|
| なし | - | 固定メッセージのため変数なし | - |

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| メニュー操作 | 「基本設定」>「設定」>「ワークスペース設定」 | workspaceSettingsResource === null | ワークスペースが開かれていない |
| コマンドパレット | 「Preferences: Open Workspace Settings」 | workspaceSettingsResource === null | ワークスペースが開かれていない |
| 設定UI | 設定エディタのワークスペースタブ | workspaceSettingsResource === null | ワークスペースが開かれていない |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| フォルダ/ワークスペースが開かれている | workspaceSettingsResourceが存在する場合は通知せず、設定ファイルを開く |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A[ワークスペース設定を開く要求] --> B{workspaceSettingsResource?}
    B -->|null| C[情報通知を表示]
    C --> D[Promise.reject]
    B -->|存在| E[設定ファイルを開く]
    D --> F[処理終了]
    E --> F
```

## データベース参照・更新仕様

### 参照テーブル一覧

| テーブル名 | 用途 | 備考 |
|-----------|------|------|
| なし | - | データベースアクセスなし |

### 更新テーブル一覧

| テーブル名 | 操作 | 概要 |
|-----------|------|------|
| なし | - | データベースアクセスなし |

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| 前提条件未満 | フォルダ/ワークスペースが開かれていない | 情報通知を表示してPromise.rejectを返す |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | なし |
| リトライ間隔 | - |
| リトライ対象エラー | - |

## 配信設定

### レート制限

| 項目 | 内容 |
|-----|------|
| 1分あたり上限 | なし（ユーザー操作に応じて発生） |
| 1日あたり上限 | なし |

### 配信時間帯

制限なし（ユーザー操作に応じて随時発生）

## セキュリティ考慮事項

- 個人情報は含まれない
- ワークスペースやフォルダのパス情報は通知に含まれない
- ローカライズ機能（nls.localize）を使用して多言語対応している

## 備考

- VS Codeの設定スコープ：ユーザー設定 > ワークスペース設定 > フォルダ設定
- WorkbenchStateがEMPTYの場合、workspaceSettingsResourceはnullになる
- この通知はユーザーを正しい操作に導くガイダンスの役割を持つ

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

ワークスペースの状態と設定リソースの構造を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | workspace.ts | `src/vs/platform/workspace/common/workspace.ts` | IWorkspaceContextService、WorkbenchState列挙型 |
| 1-2 | preferences.ts | `src/vs/workbench/services/preferences/common/preferences.ts` | IPreferencesServiceインターフェース |

**読解のコツ**: WorkbenchStateにはFOLDER、WORKSPACE、EMPTYの3つの状態がある。

#### Step 2: エントリーポイントを理解する

`openWorkspaceSettings`メソッドの実装を確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | preferencesService.ts | `src/vs/workbench/services/preferences/browser/preferencesService.ts` | PreferencesService.openWorkspaceSettings()メソッド（310-321行目） |

**主要処理フロー**:
1. **310行目**: `openWorkspaceSettings()`メソッドの定義開始
2. **311行目**: `workspaceSettingsResource`の存在チェック
3. **312行目**: リソースが存在しない場合、`notificationService.info()`で情報通知
4. **313行目**: `Promise.reject(null)`を返却
5. **315-320行目**: リソースが存在する場合、設定を開く処理

#### Step 3: workspaceSettingsResourceの取得を理解する

ワークスペース設定リソースの取得ロジックを確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | preferencesService.ts | `src/vs/workbench/services/preferences/browser/preferencesService.ts` | workspaceSettingsResourceゲッター（118-124行目） |

**主要処理フロー**:
- **118行目**: `workspaceSettingsResource`ゲッターの定義
- **119行目**: `WorkbenchState.EMPTY`の場合はnullを返す
- **122-123行目**: ワークスペースの設定ファイルパスを返す

### プログラム呼び出し階層図

```
ユーザー操作（ワークスペース設定を開く）
    │
    └─ PreferencesService.openWorkspaceSettings()
           │
           ├─ this.workspaceSettingsResource チェック
           │      │
           │      ├─ null の場合
           │      │      └─ notificationService.info()
           │      │          └─ nls.localize('openFolderFirst', ...)
           │      │          └─ Promise.reject(null)
           │      │
           │      └─ 存在する場合
           │             └─ this.open()
           │
           └─ workspaceSettingsResource ゲッター
                  │
                  └─ contextService.getWorkbenchState()
                         │
                         ├─ EMPTY → null
                         └─ FOLDER/WORKSPACE → URI
```

### データフロー図

```
[入力]                    [処理]                              [出力]

ユーザー操作        ───▶ PreferencesService             ───▶ 設定ファイルを開く
(ワークスペース設定)      │                                  または
                          ├─ WorkspaceContextService        情報通知
                          │   └─ getWorkbenchState()
                          │
                          └─ NotificationService
                              └─ info()
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| preferencesService.ts | `src/vs/workbench/services/preferences/browser/preferencesService.ts` | ソース | PreferencesServiceクラス、設定関連の操作 |
| preferences.ts | `src/vs/workbench/services/preferences/common/preferences.ts` | ソース | IPreferencesServiceインターフェース定義 |
| workspace.ts | `src/vs/platform/workspace/common/workspace.ts` | ソース | IWorkspaceContextService、WorkbenchState |
| notification.ts | `src/vs/platform/notification/common/notification.ts` | ソース | 通知サービスのインターフェース定義 |
