---
generated_at: 2026-01-27 10:48:00
metrics:
  claims_total: 18
  claims_with_evidence: 17
  claims_without_evidence: 1
confidence_derived: 0.94
---

# 根拠レポート：10-genericSaveError

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：17 / 18、根拠なし：1
- 優先レビュー（高）
  1. **通知自動クローズ**：保存/元に戻し時の自動クローズロジックの詳細

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/vs/workbench/contrib/files/browser/editors/textFileSaveErrorHandler.ts` 104-191行目（onSaveError()メソッド）
- E-02: `src/vs/workbench/contrib/files/browser/editors/textFileSaveErrorHandler.ts` 176行目（genericSaveErrorメッセージ）
- E-03: `src/vs/workbench/contrib/files/browser/editors/textFileSaveErrorHandler.ts` 140-143行目（エラー種別判定）
- E-04: `src/vs/workbench/contrib/files/browser/editors/textFileSaveErrorHandler.ts` 181-189行目（通知表示）
- E-05: `src/vs/workbench/contrib/files/browser/editors/textFileSaveErrorHandler.ts` 295-309行目（RetrySaveModelAction）
- E-06: `src/vs/workbench/contrib/files/browser/editors/textFileSaveErrorHandler.ts` 326-362行目（SaveModelAsAction）
- E-07: `src/vs/workbench/contrib/files/browser/editors/textFileSaveErrorHandler.ts` 311-324行目（RevertModelAction）
- E-08: `src/vs/workbench/contrib/files/browser/editors/textFileSaveErrorHandler.ts` 52行目（INotificationServiceの使用）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | TextFileSaveErrorHandler.onSaveError()でエラー処理 | E-01 | ○ |
| C-02 | genericSaveErrorメッセージでエラー表示 | E-02 | ○ |
| C-03 | エラーレベル（error）で通知 | E-04 | ○ |
| C-04 | nls.localizeでローカライゼーション | E-02 | ○ |
| C-05 | メッセージキーは'genericSaveError' | E-02 | ○ |
| C-06 | NotificationServiceを使用 | E-08 | ○ |
| C-07 | ファイル名とエラーメッセージがパラメータ | E-02 | ○ |
| C-08 | FILE_MODIFIED_SINCEは別処理 | E-01, E-03 | ○ |
| C-09 | FILE_WRITE_LOCKEDは別処理 | E-03 | ○ |
| C-10 | FILE_PERMISSION_DENIEDは別処理 | E-03 | ○ |
| C-11 | RetrySaveModelActionが提供される | E-05 | ○ |
| C-12 | SaveModelAsActionが提供される | E-06 | ○ |
| C-13 | RevertModelActionが提供される | E-07 | ○ |
| C-14 | 通知IDはmodel.resourceのハッシュ | E-04 | ○ |
| C-15 | basenameでファイル名を取得 | E-02 | ○ |
| C-16 | toErrorMessageでエラーメッセージ整形 | E-02 | ○ |
| C-17 | 非同期処理で実行 | E-01 | ○ |
| C-18 | 保存/元に戻し時の通知自動クローズ | **根拠不足** | △ |

## 4) 不足情報（Unknown / Missing）
- 保存または元に戻し操作後の通知自動クローズロジックの詳細
  - 候補：イベントリスナー / メッセージマップ管理

## 5) リスクフラグ（レビュー観点）
- 1: 中リスク - 保存エラーはユーザーのデータ損失に関わる重要な通知

## 6) レビュアーチェックリスト（最小）
- [ ] エラー種別の分岐ロジックを確認
- [ ] アクションボタンの動作を確認
- [ ] 通知の自動クローズロジックを確認
- [ ] toErrorMessageの整形内容を確認
