---
generated_at: 2026-01-27 10:30:00
metrics:
  claims_total: 12
  claims_with_evidence: 12
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：extensionsDisabled（11-extensionsDisabled）

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：12 / 12、根拠なし：0
- 優先レビュー（高）
  - なし（全ての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/vs/workbench/services/extensionManagement/browser/extensionEnablementService.ts` 行127
- E-02: `src/vs/workbench/services/extensionManagement/browser/extensionEnablementService.ts` 行125-126
- E-03: `src/vs/workbench/services/extensionManagement/browser/extensionEnablementService.ts` 行142-143
- E-04: `src/vs/workbench/services/extensionManagement/browser/extensionEnablementService.ts` 行128-129
- E-05: `src/vs/workbench/services/extensionManagement/browser/extensionEnablementService.ts` 行131-132
- E-06: `docs/code-to-docs/通知一覧/通知一覧.csv` 行12

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 通知メッセージは「All installed extensions are temporarily disabled.」 | E-01 | ○ |
| C-02 | 通知レベルは Info | E-01 (Severity.Info) | ○ |
| C-03 | LifecyclePhase.Eventually で通知が発行される | E-02 | ○ |
| C-04 | environmentService.disableExtensions が true の場合に通知 | E-03 | ○ |
| C-05 | 「Reload and Enable Extensions」ボタンが表示される | E-04 | ○ |
| C-06 | hostService.reload({ disableExtensions: false }) が呼び出される | E-04 | ○ |
| C-07 | 通知は sticky: true で設定される | E-05 | ○ |
| C-08 | 通知の優先度は NotificationPriority.URGENT | E-05 | ○ |
| C-09 | 拡張機能カテゴリの通知である | E-06 | ○ |
| C-10 | テンプレート変数は使用されない | E-01 (localize の引数を確認) | ○ |
| C-11 | アプリ内通知として表示される | E-01 (notificationService.prompt) | ○ |
| C-12 | allUserExtensionsDisabled プロパティで条件判定 | E-02, E-03 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全ての主張がソースコードで裏付けられている

## 6) レビュアーチェックリスト（最小）
- [x] 通知メッセージがソースコードと一致している
- [x] 通知レベル（Info）が正しい
- [x] トリガー条件が正しく記述されている
- [x] アクションボタンの動作が正しい
