---
generated_at: 2026-01-27 10:35:00
metrics:
  claims_total: 15
  claims_with_evidence: 15
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：extensionService.crash（12-extensionService.crash）

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：15 / 15、根拠なし：0
- 優先レビュー（高）
  - なし（全ての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/vs/workbench/services/extensions/electron-browser/nativeExtensionService.ts` 行225
- E-02: `src/vs/workbench/services/extensions/common/abstractExtensionService.ts` 行926
- E-03: `src/vs/workbench/services/extensions/electron-browser/nativeExtensionService.ts` 行192-200
- E-04: `src/vs/workbench/services/extensions/electron-browser/nativeExtensionService.ts` 行208-211
- E-05: `src/vs/workbench/services/extensions/electron-browser/nativeExtensionService.ts` 行213-222
- E-06: `src/vs/workbench/services/extensions/electron-browser/nativeExtensionService.ts` 行201-205
- E-07: `src/vs/workbench/services/extensions/electron-browser/nativeExtensionService.ts` 行183-188
- E-08: `src/vs/workbench/services/extensions/common/abstractExtensionService.ts` 行927-932
- E-09: `src/vs/workbench/services/extensions/electron-browser/nativeExtensionService.ts` 行162-177
- E-10: `docs/code-to-docs/通知一覧/通知一覧.csv` 行13

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | ローカル通知メッセージは「Extension host terminated unexpectedly 3 times within the last 5 minutes.」 | E-01 | ○ |
| C-02 | リモート通知メッセージは「Remote Extension host terminated unexpectedly 3 times within the last 5 minutes.」 | E-02 | ○ |
| C-03 | 通知レベルは Error | E-01, E-02 (Severity.Error) | ○ |
| C-04 | 製品版では「Start Extension Bisect」ボタンが表示される | E-03 | ○ |
| C-05 | 「Restart Extension Host」ボタンが表示される | E-04 | ○ |
| C-06 | 製品版では「Learn More」ボタンが表示される | E-05 | ○ |
| C-07 | 開発版では「Open Developer Tools」ボタンが表示される | E-06 | ○ |
| C-08 | 自動再起動可能な場合はステータス通知のみ | E-07 | ○ |
| C-09 | リモート版では「Restart Remote Extension Host」ボタンが表示される | E-08 | ○ |
| C-10 | VersionMismatch の場合は別通知が表示される | E-09 | ○ |
| C-11 | クラッシュトラッカーでクラッシュ回数を管理 | E-07 (_localCrashTracker.registerCrash) | ○ |
| C-12 | shouldAutomaticallyRestart() で自動再起動判定 | E-07 | ○ |
| C-13 | 拡張機能カテゴリの通知である | E-10 | ○ |
| C-14 | テレメトリデータとして拡張機能ID等が送信される | E-01周辺のテレメトリコード | ○ |
| C-15 | テンプレート変数は使用されない | E-01 (localize の引数を確認) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全ての主張がソースコードで裏付けられている

## 6) レビュアーチェックリスト（最小）
- [x] 通知メッセージがソースコードと一致している
- [x] 通知レベル（Error）が正しい
- [x] アクションボタンが正しく記述されている
- [x] トリガー条件（5分以内に3回クラッシュ）が正しい
- [x] ローカルとリモートの違いが正しく記述されている
