---
generated_at: 2026-01-27 10:40:00
metrics:
  claims_total: 11
  claims_with_evidence: 10
  claims_without_evidence: 1
confidence_derived: 0.91
---

# 根拠レポート：resolverExtensionNotFound（13-resolverExtensionNotFound）

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.91**
  - 根拠あり：10 / 11、根拠なし：1
- 優先レビュー（高）
  1. **C-05**：テンプレート変数の実際の使用状況

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/vs/workbench/services/extensions/electron-browser/nativeExtensionService.ts` 行503
- E-02: `src/vs/workbench/services/extensions/electron-browser/nativeExtensionService.ts` 行464-469
- E-03: `src/vs/workbench/services/extensions/electron-browser/nativeExtensionService.ts` 行491-513
- E-04: `src/vs/workbench/services/extensions/electron-browser/nativeExtensionService.ts` 行498
- E-05: `src/vs/workbench/services/extensions/electron-browser/nativeExtensionService.ts` 行493-494
- E-06: `docs/code-to-docs/通知一覧/通知一覧.csv` 行14

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 通知メッセージは「`{0}` not found on marketplace」 | E-01 | ○ |
| C-02 | 通知レベルは Error | E-01 (notificationService.error) | ○ |
| C-03 | remoteExtensionTips から推奨拡張機能を取得 | E-02 | ○ |
| C-04 | マーケットプレイス検索後に通知が発行される | E-03, E-04 | ○ |
| C-05 | テンプレート変数 {0} に拡張機能IDが入る | **根拠不明** | △ |
| C-06 | 先行してインストール確認通知が表示される | E-05 | ○ |
| C-07 | extensionGalleryService.getExtensions() で検索 | E-04 | ○ |
| C-08 | 拡張機能カテゴリの通知である | E-06 | ○ |
| C-09 | _handleNoResolverFound メソッドで処理される | E-02, E-03 | ○ |
| C-10 | 拡張機能が既にインストール済みの場合は別処理 | E-03 周辺のコード | ○ |
| C-11 | sticky: true, priority: URGENT の設定あり | E-03 (行508-510) | ○ |

## 4) 不足情報（Unknown / Missing）
- **C-05**: ソースコード行503では `localize('resolverExtensionNotFound', "\`{0}\` not found on marketplace")` となっているが、第3引数以降が渡されておらず、`{0}` に実際に値が入るかは要確認
  - 候補：localize の第2引数のフォーマット文字列の仕様確認が必要

## 5) リスクフラグ（レビュー観点）
- 1: 中リスク - テンプレート変数の使用状況に不明点あり

## 6) レビュアーチェックリスト（最小）
- [x] 通知メッセージがソースコードと一致している
- [x] 通知レベル（Error）が正しい
- [ ] テンプレート変数 {0} が実際に使用されているか確認
- [x] トリガー条件が正しく記述されている
- [x] 処理フローが正しい
