---
generated_at: 2026-01-27 10:45:00
metrics:
  claims_total: 12
  claims_with_evidence: 12
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：unknownDep（14-unknownDep）

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：12 / 12、根拠なし：0
- 優先レビュー（高）
  - なし（全ての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/vs/workbench/api/browser/mainThreadExtensionService.ts` 行178
- E-02: `src/vs/workbench/api/browser/mainThreadExtensionService.ts` 行157-163
- E-03: `src/vs/workbench/api/browser/mainThreadExtensionService.ts` 行164-176
- E-04: `src/vs/workbench/api/browser/mainThreadExtensionService.ts` 行90-98
- E-05: `src/vs/workbench/api/browser/mainThreadExtensionService.ts` 行158
- E-06: `docs/code-to-docs/通知一覧/通知一覧.csv` 行15

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 通知メッセージは「Cannot activate the '{0}' extension because it depends on an unknown '{1}' extension.」 | E-01 | ○ |
| C-02 | 通知レベルは Error | E-01 (notificationService.error) | ○ |
| C-03 | テンプレート変数 {0} は拡張機能名 | E-05 (extension.displayName \|\| extension.name) | ○ |
| C-04 | テンプレート変数 {1} は依存拡張機能ID | E-01 (missingDependency) | ○ |
| C-05 | マーケットプレイス検索で見つからない場合に表示 | E-02, E-03 | ○ |
| C-06 | _handleMissingNotInstalledDependency で処理 | E-02 | ○ |
| C-07 | 依存拡張機能が見つかった場合は別の通知（uninstalledDep） | E-03 | ○ |
| C-08 | ローカルにある場合は別の処理フロー | E-04 | ○ |
| C-09 | extensionsWorkbenchService.getExtensions() で検索 | E-02 | ○ |
| C-10 | 拡張機能カテゴリの通知である | E-06 | ○ |
| C-11 | $onExtensionActivationError でエラー処理が開始 | E-04 | ○ |
| C-12 | アクションボタンは提供されない | E-01 (error メソッドはアクションなし) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全ての主張がソースコードで裏付けられている

## 6) レビュアーチェックリスト（最小）
- [x] 通知メッセージがソースコードと一致している
- [x] 通知レベル（Error）が正しい
- [x] テンプレート変数が正しく記述されている
- [x] トリガー条件が正しく記述されている
- [x] 関連する他の通知との違いが明確
