---
generated_at: 2026-01-27 11:05:00
metrics:
  claims_total: 11
  claims_with_evidence: 11
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：failedToLoadFrames（18-failedToLoadFrames）

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：11 / 11、根拠なし：0
- 優先レビュー（高）
  - なし（全ての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/vs/workbench/contrib/debug/browser/callStackWidget.ts` 行642
- E-02: `src/vs/workbench/contrib/debug/browser/callStackWidget.ts` 行635-644
- E-03: `src/vs/workbench/contrib/debug/browser/callStackWidget.ts` 行640
- E-04: `src/vs/workbench/contrib/debug/browser/callStackWidget.ts` 行636-638
- E-05: `src/vs/workbench/contrib/debug/browser/callStackWidget.ts` 行620-627
- E-06: `docs/code-to-docs/通知一覧/通知一覧.csv` 行19

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 通知メッセージは「Failed to load stack frames: {0}」 | E-01 | ○ |
| C-02 | 通知レベルは Error | E-01 (notificationService.error) | ○ |
| C-03 | テンプレート変数 {0} は e.message | E-01 | ○ |
| C-04 | ボタンクリックで処理が開始 | E-02 | ○ |
| C-05 | ボタン無効化で連打防止 | E-03 | ○ |
| C-06 | button.enabled のチェック | E-04 | ○ |
| C-07 | SkippedRenderer クラスで処理 | E-05 | ○ |
| C-08 | loadFrames の catch で通知発行 | E-02 | ○ |
| C-09 | デバッグカテゴリの通知である | E-06 | ○ |
| C-10 | アクションボタンは提供されない | E-01 (error メソッドはアクションなし) | ○ |
| C-11 | INotificationService を使用 | E-05 (行626) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全ての主張がソースコードで裏付けられている

## 6) レビュアーチェックリスト（最小）
- [x] 通知メッセージがソースコードと一致している
- [x] 通知レベル（Error）が正しい
- [x] テンプレート変数が正しく記述されている
- [x] トリガー条件が正しく記述されている
- [x] ボタン無効化の仕組みが正しく記述されている
