---
generated_at: 2026-01-27 11:10:00
metrics:
  claims_total: 11
  claims_with_evidence: 11
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：sync turned on（19-sync-turned-on）

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：11 / 11、根拠なし：0
- 優先レビュー（高）
  - なし（全ての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/vs/workbench/services/userDataSync/browser/userDataSyncWorkbenchService.ts` 行340
- E-02: `src/vs/workbench/services/userDataSync/common/userDataSync.ts` 行81
- E-03: `src/vs/workbench/services/userDataSync/browser/userDataSyncWorkbenchService.ts` 行288-294
- E-04: `src/vs/workbench/services/userDataSync/browser/userDataSyncWorkbenchService.ts` 行324
- E-05: `src/vs/workbench/services/userDataSync/browser/userDataSyncWorkbenchService.ts` 行329
- E-06: `src/vs/workbench/services/userDataSync/browser/userDataSyncWorkbenchService.ts` 行341
- E-07: `docs/code-to-docs/通知一覧/通知一覧.csv` 行20

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 通知メッセージは「{0} is turned on」 | E-01 | ○ |
| C-02 | {0} は SYNC_TITLE.value（"Settings Sync"） | E-01, E-02 | ○ |
| C-03 | 通知レベルは Info | E-01 (notificationService.info) | ○ |
| C-04 | turnOn() メソッドで処理される | E-03 | ○ |
| C-05 | doTurnOnSync() で初期同期実行 | E-04 | ○ |
| C-06 | userDataAutoSyncService.turnOn() で自動同期有効化 | E-05 | ○ |
| C-07 | 通知後に _onDidTurnOnSync イベント発火 | E-06 | ○ |
| C-08 | ユーザーデータ同期カテゴリの通知である | E-07 | ○ |
| C-09 | 既に有効な場合は早期リターン | E-03 (行292-293) | ○ |
| C-10 | アクションボタンは提供されない | E-01 (info メソッドはアクションなし) | ○ |
| C-11 | SYNC_TITLE は国際化対応されている | E-02 (localize2 使用) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全ての主張がソースコードで裏付けられている

## 6) レビュアーチェックリスト（最小）
- [x] 通知メッセージがソースコードと一致している
- [x] 通知レベル（Info）が正しい
- [x] テンプレート変数が正しく記述されている
- [x] トリガー条件が正しく記述されている
- [x] 処理フローが正しく記述されている
