---
generated_at: 2026-01-27 11:15:00
metrics:
  claims_total: 14
  claims_with_evidence: 14
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：conflicts detected（20-conflicts-detected）

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：14 / 14、根拠なし：0
- 優先レビュー（高）
  - なし（全ての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/vs/workbench/contrib/userDataSync/browser/userDataSync.ts` 行187
- E-02: `src/vs/workbench/contrib/userDataSync/browser/userDataSync.ts` 行186
- E-03: `src/vs/workbench/contrib/userDataSync/browser/userDataSync.ts` 行188-207
- E-04: `src/vs/workbench/contrib/userDataSync/browser/userDataSync.ts` 行209-211
- E-05: `src/vs/workbench/contrib/userDataSync/browser/userDataSync.ts` 行170-172
- E-06: `src/vs/workbench/contrib/userDataSync/browser/userDataSync.ts` 行185
- E-07: `src/vs/workbench/contrib/userDataSync/browser/userDataSync.ts` 行213-217
- E-08: `src/vs/workbench/contrib/userDataSync/browser/userDataSync.ts` 行226-232
- E-09: `src/vs/workbench/contrib/userDataSync/browser/userDataSync.ts` 行234-240
- E-10: `docs/code-to-docs/通知一覧/通知一覧.csv` 行21

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 通知メッセージは「Unable to sync due to conflicts in {0}. Please resolve them to continue.」 | E-01 | ○ |
| C-02 | 通知レベルは Warning | E-01 (Severity.Warning) | ○ |
| C-03 | テンプレート変数 {0} は getSyncAreaLabel().toLowerCase() | E-02, E-01 | ○ |
| C-04 | 「Replace Remote」ボタンが表示される | E-03 (行189-194) | ○ |
| C-05 | 「Replace Local」ボタンが表示される | E-03 (行195-200) | ○ |
| C-06 | 「Show Conflicts」ボタンが表示される | E-03 (行201-207) | ○ |
| C-07 | sticky: true で設定される | E-04 | ○ |
| C-08 | Settings Sync が無効の場合は早期リターン | E-05 | ○ |
| C-09 | 同じ競合に対しては重複通知しない | E-06 | ○ |
| C-10 | 競合解決時に通知がクローズされる | E-07 | ○ |
| C-11 | acceptRemote でリモートの内容を採用 | E-08 | ○ |
| C-12 | acceptLocal でローカルの内容を採用 | E-09 | ○ |
| C-13 | accept 失敗時にエラー通知 | E-08, E-09 | ○ |
| C-14 | ユーザーデータ同期カテゴリの通知である | E-10 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全ての主張がソースコードで裏付けられている

## 6) レビュアーチェックリスト（最小）
- [x] 通知メッセージがソースコードと一致している
- [x] 通知レベル（Warning）が正しい
- [x] テンプレート変数が正しく記述されている
- [x] アクションボタンが正しく記述されている
- [x] sticky 設定が正しい
- [x] 重複通知防止の仕組みが正しく記述されている
