---
generated_at: 2026-01-27 12:50:00
metrics:
  claims_total: 11
  claims_with_evidence: 11
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：22-too_many_profiles.md

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：11 / 11、根拠なし：0
- 優先レビュー（高）
  - 全ての主張に根拠あり

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/vs/workbench/contrib/userDataSync/browser/userDataSync.ts` 行277-279
- E-02: `src/vs/platform/userDataSync/common/userDataProfilesManifestSync.ts` 行181-182
- E-03: `src/vs/platform/userDataSync/common/userDataSync.ts` (UserDataSyncErrorCode定義)
- E-04: `docs/code-to-docs/通知一覧/通知一覧.csv` 行23

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | プロファイル数の上限は20個である | E-02 (行181の条件式 > 20) | ○ |
| C-02 | LocalTooManyProfilesエラーコードで通知が発火する | E-01 (行277のcase文) | ○ |
| C-03 | notificationService.errorを使用する | E-01 (行279) | ○ |
| C-04 | 同期を無効化する処理がある | E-01 (行278のdisableSync呼び出し) | ○ |
| C-05 | SyncResource.Profilesを無効化対象とする | E-01 (行278) | ○ |
| C-06 | メッセージ内容は「Disabled syncing profiles...」である | E-01 (行279のlocalize呼び出し) | ○ |
| C-07 | applyResultメソッドでプロファイル数を検証する | E-02 (行181) | ○ |
| C-08 | UserDataSyncErrorをスローする | E-02 (行182) | ○ |
| C-09 | onAutoSyncErrorでエラーを処理する | E-01 (行242以降のonAutoSyncErrorメソッド) | ○ |
| C-10 | 通知種別はエラーである | E-01 (notificationService.error使用) | ○ |
| C-11 | 通知一覧の説明と一致する | E-04 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全ての主張がコードで確認済み

## 6) レビュアーチェックリスト（最小）
- [ ] プロファイル数の上限値（20）が仕様として適切か確認
- [ ] disableSyncの動作が期待通りか確認
- [ ] エラーメッセージがユーザーにとって分かりやすいか確認
