---
generated_at: 2026-01-27 13:00:00
metrics:
  claims_total: 11
  claims_with_evidence: 11
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：24-turn_on_failed_with_user_data_sync_error.md

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：11 / 11、根拠なし：0
- 優先レビュー（高）
  - 全ての主張に根拠あり

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/vs/workbench/contrib/userDataSync/browser/userDataSync.ts` 行546-548
- E-02: `src/vs/workbench/contrib/userDataSync/browser/userDataSync.ts` 行486-552
- E-03: `src/vs/workbench/contrib/userDataSync/browser/userDataSync.ts` 行503
- E-04: `src/vs/workbench/services/userDataSync/common/userDataSync.ts` (SHOW_SYNC_LOG_COMMAND_ID)
- E-05: `docs/code-to-docs/通知一覧/通知一覧.csv` 行25

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | default caseで処理される（認証エラー以外） | E-01 (行546のdefault case) | ○ |
| C-02 | notificationService.errorを使用する | E-01 (行547) | ○ |
| C-03 | メッセージにログリンクが含まれる | E-01 (行547のlocalize呼び出しと変数) | ○ |
| C-04 | SHOW_SYNC_LOG_COMMAND_IDを使用する | E-01, E-04 | ○ |
| C-05 | turnOnメソッド内で処理される | E-02 | ○ |
| C-06 | UserDataSyncErrorのinstanceof判定を行う | E-03 | ○ |
| C-07 | キャンセル時は通知しない | E-02 (行500-502のisCancellationError判定) | ○ |
| C-08 | 認証エラーとは別の処理パスである | E-01, E-02 (switch文の構造) | ○ |
| C-09 | メッセージキーは'turn on failed with user data sync error' | E-01 | ○ |
| C-10 | ログリンクはMarkdown形式 | E-01 (メッセージ内の[]()形式) | ○ |
| C-11 | 通知一覧の説明と一致する | E-05 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全ての主張がコードで確認済み

## 6) レビュアーチェックリスト（最小）
- [ ] ログリンクが正しくログ表示画面を開くか確認
- [ ] 汎用エラーメッセージがユーザーにとって十分な情報を提供しているか確認
- [ ] 各種UserDataSyncErrorコードがこの通知でカバーされることを確認
